/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.security.userstore;

import java.sql.SQLException;
import org.apache.airavata.common.utils.DBUtil;
import org.apache.airavata.security.UserStoreException;
import org.apache.airavata.security.userstore.AbstractJDBCUserStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class SessionDBUserStore
extends AbstractJDBCUserStore {
    private String sessionTable;
    private String sessionColumn;
    private String comparingColumn;
    protected DBUtil dbUtil;
    protected static Logger log = LoggerFactory.getLogger(SessionDBUserStore.class);

    @Override
    public boolean authenticate(String userName, Object credentials) throws UserStoreException {
        throw new NotImplementedException();
    }

    @Override
    public boolean authenticate(Object credentials) throws UserStoreException {
        String sessionTicket = (String)credentials;
        try {
            String sessionString = this.dbUtil.getMatchingColumnValue(this.sessionTable, this.sessionColumn, sessionTicket);
            return sessionString != null;
        }
        catch (SQLException e) {
            throw new UserStoreException("Error querying database for session information.", e);
        }
    }

    @Override
    public void configure(Node node) throws UserStoreException {
        super.configure(node);
        NodeList databaseNodeList = node.getChildNodes();
        Node databaseNode = null;
        for (int k = 0; k < databaseNodeList.getLength(); ++k) {
            Node n = databaseNodeList.item(k);
            if (n == null || n.getNodeType() != 1) continue;
            databaseNode = n;
        }
        if (databaseNode != null) {
            NodeList nodeList = databaseNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n = nodeList.item(i);
                if (n.getNodeType() != 1) continue;
                Element element = (Element)n;
                if (element.getNodeName().equals("sessionTable")) {
                    this.sessionTable = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (element.getNodeName().equals("sessionColumn")) {
                    this.sessionColumn = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (!element.getNodeName().equals("comparingColumn")) continue;
                this.comparingColumn = element.getFirstChild().getNodeValue();
            }
        }
        this.initializeDatabaseLookup();
        StringBuilder stringBuilder = new StringBuilder("Configuring DB parameters for authenticator with Session Table - ");
        stringBuilder.append(this.sessionTable).append(" Session column - ").append(this.sessionColumn).append(" Comparing column - ").append(this.comparingColumn);
        log.debug(stringBuilder.toString());
    }

    private void initializeDatabaseLookup() throws RuntimeException {
        try {
            this.dbUtil = new DBUtil(this.getDatabaseURL(), this.getDatabaseUserName(), this.getDatabasePassword(), this.getDatabaseDriver());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error loading database driver. Driver class not found.", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error loading database driver. Error instantiating driver object.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error loading database driver. Illegal access to driver object.", e);
        }
    }
}

