/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.polynomials;

import org.apache.commons.math.DuplicateSampleAbscissaException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;

public class PolynomialFunctionLagrangeForm
implements UnivariateRealFunction {
    private double[] coefficients;
    private final double[] x;
    private final double[] y;
    private boolean coefficientsComputed;

    public PolynomialFunctionLagrangeForm(double[] x, double[] y) throws IllegalArgumentException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y);
        this.x = new double[x.length];
        this.y = new double[y.length];
        System.arraycopy(x, 0, this.x, 0, x.length);
        System.arraycopy(y, 0, this.y, 0, y.length);
        this.coefficientsComputed = false;
    }

    public double value(double z) throws FunctionEvaluationException {
        try {
            return PolynomialFunctionLagrangeForm.evaluate(this.x, this.y, z);
        }
        catch (DuplicateSampleAbscissaException e) {
            throw new FunctionEvaluationException((Throwable)e, z, e.getPattern(), e.getArguments());
        }
    }

    public int degree() {
        return this.x.length - 1;
    }

    public double[] getInterpolatingPoints() {
        double[] out = new double[this.x.length];
        System.arraycopy(this.x, 0, out, 0, this.x.length);
        return out;
    }

    public double[] getInterpolatingValues() {
        double[] out = new double[this.y.length];
        System.arraycopy(this.y, 0, out, 0, this.y.length);
        return out;
    }

    public double[] getCoefficients() {
        if (!this.coefficientsComputed) {
            this.computeCoefficients();
        }
        double[] out = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, out, 0, this.coefficients.length);
        return out;
    }

    public static double evaluate(double[] x, double[] y, double z) throws DuplicateSampleAbscissaException, IllegalArgumentException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y);
        int nearest = 0;
        int n = x.length;
        double[] c = new double[n];
        double[] d = new double[n];
        double min_dist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            c[i] = y[i];
            d[i] = y[i];
            double dist = Math.abs(z - x[i]);
            if (!(dist < min_dist)) continue;
            nearest = i;
            min_dist = dist;
        }
        double value = y[nearest];
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < n - i; ++j) {
                double tc = x[j] - z;
                double td = x[i + j] - z;
                double divider = x[j] - x[i + j];
                if (divider == 0.0) {
                    throw new DuplicateSampleAbscissaException(x[i], i, i + j);
                }
                double w = (c[j + 1] - d[j]) / divider;
                c[j] = tc * w;
                d[j] = td * w;
            }
            if ((double)nearest < 0.5 * (double)(n - i + 1)) {
                value += c[nearest];
                continue;
            }
            value += d[--nearest];
        }
        return value;
    }

    protected void computeCoefficients() throws ArithmeticException {
        int n = this.degree() + 1;
        this.coefficients = new double[n];
        for (int i = 0; i < n; ++i) {
            this.coefficients[i] = 0.0;
        }
        double[] c = new double[n + 1];
        c[0] = 1.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j > 0; --j) {
                c[j] = c[j - 1] - c[j] * this.x[i];
            }
            c[0] = c[0] * -this.x[i];
            c[i + 1] = 1.0;
        }
        double[] tc = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = 1.0;
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                d *= this.x[i] - this.x[j];
            }
            if (d == 0.0) {
                for (int k = 0; k < n; ++k) {
                    if (i == k || this.x[i] != this.x[k]) continue;
                    throw MathRuntimeException.createArithmeticException("identical abscissas x[{0}] == x[{1}] == {2} cause division by zero", i, k, this.x[i]);
                }
            }
            double t = this.y[i] / d;
            tc[n - 1] = c[n];
            int n2 = n - 1;
            this.coefficients[n2] = this.coefficients[n2] + t * tc[n - 1];
            for (int j = n - 2; j >= 0; --j) {
                tc[j] = c[j + 1] + tc[j + 1] * this.x[i];
                int n3 = j;
                this.coefficients[n3] = this.coefficients[n3] + t * tc[j];
            }
        }
        this.coefficientsComputed = true;
    }

    public static void verifyInterpolationArray(double[] x, double[] y) throws IllegalArgumentException {
        if (x.length != y.length) {
            throw MathRuntimeException.createIllegalArgumentException("dimension mismatch {0} != {1}", x.length, y.length);
        }
        if (x.length < 2) {
            throw MathRuntimeException.createIllegalArgumentException("{0} points are required, got only {1}", 2, x.length);
        }
    }
}

