/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.pretty.MessageHelper;

public abstract class AbstractSelectingDelegate
implements InsertGeneratedIdentifierDelegate {
    private final PostInsertIdentityPersister persister;

    protected AbstractSelectingDelegate(PostInsertIdentityPersister persister) {
        this.persister = persister;
    }

    protected abstract String getSelectSQL();

    protected void bindParameters(Object entity, PreparedStatement ps, SharedSessionContractImplementor session) throws SQLException {
    }

    protected Object extractGeneratedValue(ResultSet resultSet, SharedSessionContractImplementor session) throws SQLException {
        return IdentifierGeneratorHelper.getGeneratedIdentity(this.persister.getNavigableRole().getFullPath(), resultSet, this.persister, session);
    }

    @Override
    public PreparedStatement prepareStatement(String insertSql, SharedSessionContractImplementor session) {
        return session.getJdbcCoordinator().getMutationStatementPreparer().prepareStatement(insertSql, 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object performInsert(PreparedStatementDetails insertStatementDetails, JdbcValueBindings jdbcValueBindings, Object entity, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        JdbcServices jdbcServices = session.getJdbcServices();
        jdbcServices.getSqlStatementLogger().logStatement(insertStatementDetails.getSqlString());
        jdbcValueBindings.beforeStatement(insertStatementDetails);
        jdbcCoordinator.getResultSetReturn().executeUpdate(insertStatementDetails.resolveStatement(), insertStatementDetails.getSqlString());
        String idSelectSql = this.getSelectSQL();
        PreparedStatement idSelect = jdbcCoordinator.getStatementPreparer().prepareStatement(idSelectSql);
        try {
            this.bindParameters(entity, idSelect, session);
            ResultSet resultSet = session.getJdbcCoordinator().getResultSetReturn().extract(idSelect, idSelectSql);
            try {
                Object object = this.extractGeneratedValue(resultSet, session);
                return object;
            }
            catch (SQLException e) {
                throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to execute post-insert id selection query", idSelectSql);
            }
            finally {
                session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(idSelect);
                session.getJdbcCoordinator().afterStatementExecution();
            }
        }
        catch (SQLException e) {
            throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to bind parameters for post-insert id selection query", idSelectSql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Object performInsert(String insertSQL, SharedSessionContractImplementor session, Binder binder) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        StatementPreparer statementPreparer = jdbcCoordinator.getStatementPreparer();
        try {
            PreparedStatement insert = statementPreparer.prepareStatement(insertSQL, 2);
            try {
                binder.bindValues(insert);
                jdbcCoordinator.getResultSetReturn().executeUpdate(insert, insertSQL);
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(insert);
                jdbcCoordinator.afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(sqle, "could not insert: " + MessageHelper.infoString(this.persister), insertSQL);
        }
        String selectSQL = this.getSelectSQL();
        try {
            PreparedStatement idSelect = statementPreparer.prepareStatement(selectSQL, false);
            try {
                this.bindParameters(binder.getEntity(), idSelect, session);
                ResultSet resultSet = jdbcCoordinator.getResultSetReturn().extract(idSelect, selectSQL);
                try {
                    Object object = this.extractGeneratedValue(resultSet, session);
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(resultSet, idSelect);
                    return object;
                }
                catch (Throwable throwable) {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(resultSet, idSelect);
                    throw throwable;
                }
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(idSelect);
                jdbcCoordinator.afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(sqle, "could not retrieve generated id after insert: " + MessageHelper.infoString(this.persister), selectSQL);
        }
    }
}

