/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataSupport;
import org.springframework.cloud.vault.config.VaultKeyValueBackendPropertiesSupport;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.vault.core.util.PropertyTransformer;
import org.springframework.vault.core.util.PropertyTransformers;

public class KeyValueSecretBackendMetadata
extends SecretBackendMetadataSupport
implements SecretBackendMetadata {
    private final String path;
    private final PropertyTransformer propertyTransformer;

    KeyValueSecretBackendMetadata(String path) {
        this(path, PropertyTransformers.noop());
    }

    private KeyValueSecretBackendMetadata(String path, PropertyTransformer propertyTransformer) {
        Assert.hasText((String)path, (String)"Secret backend path must not be empty");
        Assert.notNull((Object)propertyTransformer, (String)"PropertyTransformer must not be null");
        this.path = path;
        this.propertyTransformer = propertyTransformer;
    }

    public static SecretBackendMetadata create(String secretBackendPath, String key) {
        Assert.hasText((String)secretBackendPath, (String)"Secret backend path must not be null or empty");
        Assert.hasText((String)key, (String)"Key must not be null or empty");
        return KeyValueSecretBackendMetadata.create(String.format("%s/%s", secretBackendPath, key), UnwrappingPropertyTransformer.unwrap("data"));
    }

    public static SecretBackendMetadata create(String path) {
        return new KeyValueSecretBackendMetadata(path, PropertyTransformers.noop());
    }

    public static SecretBackendMetadata create(String path, PropertyTransformer propertyTransformer) {
        return new KeyValueSecretBackendMetadata(path, propertyTransformer);
    }

    public static List<String> buildContexts(VaultKeyValueBackendPropertiesSupport properties, List<String> profiles) {
        String appName = properties.getApplicationName();
        String defaultContext = properties.getDefaultContext();
        LinkedHashSet<String> contexts = new LinkedHashSet<String>(KeyValueSecretBackendMetadata.buildContexts(defaultContext, profiles, properties.getProfileSeparator()));
        for (String applicationName : StringUtils.commaDelimitedListToSet((String)appName)) {
            contexts.addAll(KeyValueSecretBackendMetadata.buildContexts(applicationName, profiles, properties.getProfileSeparator()));
        }
        ArrayList<String> result = new ArrayList<String>(contexts);
        Collections.reverse(result);
        return result;
    }

    public static List<String> buildContexts(String applicationName, List<String> profiles, String profileSeparator) {
        if (!StringUtils.hasText((String)applicationName)) {
            return Collections.emptyList();
        }
        ArrayList<String> contexts = new ArrayList<String>(profiles.size() + 1);
        contexts.add(applicationName);
        for (String profile : profiles) {
            String contextName;
            if (!StringUtils.hasText((String)profile) || contexts.contains(contextName = applicationName + profileSeparator + profile.trim())) continue;
            contexts.add(contextName);
        }
        return contexts;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public PropertyTransformer getPropertyTransformer() {
        return this.propertyTransformer;
    }

    static final class UnwrappingPropertyTransformer
    implements PropertyTransformer {
        private final String prefixToStrip;

        private UnwrappingPropertyTransformer(String prefixToStrip) {
            Assert.notNull((Object)prefixToStrip, (String)"Property name prefix must not be null");
            this.prefixToStrip = prefixToStrip;
        }

        public static PropertyTransformer unwrap(String propertyNamePrefix) {
            return new UnwrappingPropertyTransformer(propertyNamePrefix);
        }

        public Map<String, Object> transformProperties(Map<String, ? extends Object> input) {
            LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>(input.size(), 1.0f);
            for (Map.Entry<String, ? extends Object> entry : input.entrySet()) {
                if (entry.getKey().startsWith(this.prefixToStrip + ".")) {
                    target.put(entry.getKey().substring(this.prefixToStrip.length() + 1), entry.getValue());
                    continue;
                }
                target.put(entry.getKey(), entry.getValue());
            }
            return target;
        }
    }
}

