/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingTestConstants;
import org.apache.commons.imaging.formats.png.AbstractPngTest;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.apache.commons.imaging.formats.png.PngWriter;
import org.apache.commons.imaging.palette.Palette;
import org.apache.commons.imaging.palette.PaletteFactory;
import org.apache.commons.imaging.palette.SimplePalette;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngWriterTest
extends AbstractPngTest {
    private static String[][] testSet = new String[][]{{"1/Oregon Scientific DS6639 - DSC_0307 - small.png", "1"}, {"2/12118.png", "1"}, {"2/28569-4.png", "1"}, {"2/28569-8.png", "1"}, {"2/28569.png", "1"}, {"3/testImage.png", "116"}, {"3/testImageNoAlpha.png", "1"}, {"4/buttons_level_menu_down.ipad.png", "2"}, {"5/trns-gray.png", "26"}, {"5/trns-palette8.png", "18"}, {"5/trns-rgb.png", "26"}};

    private static int countColors(byte[] bytes) throws IOException {
        BufferedImage imageParsed = Imaging.getBufferedImage((byte[])bytes);
        return new PaletteFactory().makeExactRgbPaletteSimple(imageParsed, Integer.MAX_VALUE).length();
    }

    private static byte[] getImageBytes(BufferedImage image, PngImagingParameters params, PaletteFactory paletteFactory) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            new PngWriter().writeImage(image, (OutputStream)os, params, paletteFactory);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    private File getPngFile(String name) {
        File pngFolder = new File(ImagingTestConstants.TEST_IMAGE_FOLDER, "png");
        return new File(pngFolder, name);
    }

    @Test
    public void testNullParameters() throws IOException {
        for (String[] testTarget : testSet) {
            String filePath = testTarget[0];
            File imageFile = this.getPngFile(filePath);
            BufferedImage image = Imaging.getBufferedImage((File)imageFile);
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                new PngWriter().writeImage(image, (OutputStream)os, null, null);
                byte[] bytes = os.toByteArray();
                int numColors = PngWriterTest.countColors(bytes);
                Assertions.assertTrue((numColors > 1 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testPaletteFactory() throws IOException {
        for (String[] testTarget : testSet) {
            String filePath = testTarget[0];
            File imageFile = this.getPngFile(filePath);
            int colorCount = Integer.parseInt(testTarget[1]);
            BufferedImage image = Imaging.getBufferedImage((File)imageFile);
            PngImagingParameters params = new PngImagingParameters();
            params.setForceIndexedColor(true);
            byte[] bytes = PngWriterTest.getImageBytes(image, params, null);
            int numColors = PngWriterTest.countColors(bytes);
            Assertions.assertTrue((numColors > 1 ? 1 : 0) != 0, imageFile::toString);
            PaletteFactory factory = new PaletteFactory(){

                public Palette makeQuantizedRgbPalette(BufferedImage src, int max) {
                    return new SimplePalette(new int[max]);
                }
            };
            byte[] palettedBytes = PngWriterTest.getImageBytes(image, params, factory);
            Assertions.assertEquals((int)colorCount, (int)PngWriterTest.countColors(palettedBytes), (String)filePath);
        }
    }
}

