/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class AbstractStreamBuilderTest {
    AbstractStreamBuilderTest() {
    }

    private static Stream<IOConsumer<Builder>> fileBasedConfigurers() throws URISyntaxException {
        URI uri = Objects.requireNonNull(AbstractStreamBuilderTest.class.getResource("/org/apache/commons/io/test-file-20byteslength.bin")).toURI();
        Path path = Paths.get("src/test/resources/org/apache/commons/io/test-file-20byteslength.bin", new String[0]);
        return Stream.of(b -> b.setByteArray(ArrayUtils.EMPTY_BYTE_ARRAY), b -> b.setFile("src/test/resources/org/apache/commons/io/test-file-20byteslength.bin"), b -> b.setFile(path.toFile()), b -> b.setPath("src/test/resources/org/apache/commons/io/test-file-20byteslength.bin"), b -> b.setPath(path), b -> b.setRandomAccessFile(new RandomAccessFile("src/test/resources/org/apache/commons/io/test-file-20byteslength.bin", "r")), b -> b.setInputStream(new FileInputStream("src/test/resources/org/apache/commons/io/test-file-20byteslength.bin")), b -> b.setChannel(Files.newByteChannel(path, new OpenOption[0])), b -> b.setURI(uri));
    }

    private void assertResult(char[] arr, int size) {
        Assertions.assertNotNull((Object)arr);
        Assertions.assertEquals((int)size, (int)arr.length);
        for (char c : arr) {
            Assertions.assertEquals((char)'a', (char)c);
        }
    }

    protected Builder builder() {
        return new Builder();
    }

    @ParameterizedTest
    @MethodSource(value={"fileBasedConfigurers"})
    void getGetSeekableByteChannel(IOConsumer<Builder> configurer) throws Exception {
        Builder builder = this.builder();
        configurer.accept((Object)builder);
        try (ReadableByteChannel channel = (ReadableByteChannel)Assertions.assertDoesNotThrow(() -> (SeekableByteChannel)builder.getChannel(SeekableByteChannel.class));){
            Assertions.assertTrue((boolean)channel.isOpen());
        }
    }

    @Test
    void testBufferSizeChecker() {
        Builder builder = this.builder();
        this.assertResult(builder.get(), builder.getBufferSize());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((Builder)this.builder().setBufferSizeMax(2)).setBufferSize(3));
        this.assertResult(((Builder)((Builder)((Builder)builder.setBufferSizeMax(2)).setBufferSizeMax(0)).setBufferSize(3)).get(), 3);
        this.assertResult(((Builder)((Builder)((Builder)this.builder().setBufferSizeMax(2)).setBufferSizeChecker(i -> 100)).setBufferSize(3)).get(), 100);
    }

    @ParameterizedTest
    @MethodSource(value={"fileBasedConfigurers"})
    void testGetInputStream(IOConsumer<Builder> configurer) throws Exception {
        Builder builder = this.builder();
        configurer.accept((Object)builder);
        Assertions.assertNotNull((Object)builder.getInputStream());
    }

    public static class Builder
    extends AbstractStreamBuilder<char[], Builder> {
        public char[] get() {
            char[] arr = new char[this.getBufferSize()];
            Arrays.fill(arr, 'a');
            return arr;
        }
    }
}

