/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.io.channels.FileChannelProxy;

class FixedReadSizeFileChannelProxy
extends FileChannelProxy {
    final int readSize;

    FixedReadSizeFileChannelProxy(FileChannel fileChannel, int readSize) {
        super(fileChannel);
        if (readSize < 1) {
            throw new IllegalArgumentException("readSize: " + readSize);
        }
        this.readSize = readSize;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int saveLimit = dst.limit();
        dst.limit(Math.min(dst.position() + this.readSize, dst.capacity()));
        if (!dst.hasRemaining()) {
            throw new IllegalStateException("Programming error.");
        }
        int numRead = super.read(dst);
        if (numRead > this.readSize) {
            throw new IllegalStateException(String.format("numRead %,d > readSize %,d", numRead, this.readSize));
        }
        dst.limit(saveLimit);
        return numRead;
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        int saveLimit = dst.limit();
        dst.limit(Math.min(dst.position() + this.readSize, dst.capacity()));
        if (!dst.hasRemaining()) {
            throw new IllegalStateException("Programming error.");
        }
        int numRead = super.read(dst, position);
        if (numRead > this.readSize) {
            throw new IllegalStateException(String.format("numRead %,d > readSize %,d", numRead, this.readSize));
        }
        dst.limit(saveLimit);
        return numRead;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }
}

