/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import org.apache.commons.io.output.StringBuilderWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StringBuilderWriterTest {
    private static final char[] FOOBAR_CHARS = new char[]{'F', 'o', 'o', 'B', 'a', 'r'};

    StringBuilderWriterTest() {
    }

    @Test
    void testAppendChar() throws IOException {
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            writer.append('F').append('o').append('o');
            Assertions.assertEquals((Object)"Foo", (Object)writer.toString());
        }
    }

    @Test
    void testAppendCharSequence() throws IOException {
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            writer.append("Foo").append("Bar");
            Assertions.assertEquals((Object)"FooBar", (Object)writer.toString());
        }
    }

    @Test
    void testAppendCharSequencePortion() throws IOException {
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            writer.append("FooBar", 3, 6).append(new StringBuffer("FooBar"), 0, 3);
            Assertions.assertEquals((Object)"BarFoo", (Object)writer.toString());
        }
    }

    @Test
    void testAppendConstructCapacity() throws IOException {
        try (StringBuilderWriter writer = new StringBuilderWriter(100);){
            writer.append("Foo");
            Assertions.assertEquals((Object)"Foo", (Object)writer.toString());
        }
    }

    @Test
    void testAppendConstructNull() throws IOException {
        try (StringBuilderWriter writer = new StringBuilderWriter(null);){
            writer.append("Foo");
            Assertions.assertEquals((Object)"Foo", (Object)writer.toString());
        }
    }

    @Test
    void testAppendConstructStringBuilder() {
        StringBuilder builder = new StringBuilder("Foo");
        try (StringBuilderWriter writer = new StringBuilderWriter(builder);){
            writer.append((CharSequence)"Bar");
            Assertions.assertEquals((Object)"FooBar", (Object)writer.toString());
            Assertions.assertSame((Object)builder, (Object)writer.getBuilder());
        }
    }

    @Test
    void testClose() throws IOException {
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            writer.append("Foo");
            writer.close();
            writer.append("Bar");
            Assertions.assertEquals((Object)"FooBar", (Object)writer.toString());
        }
    }

    @Test
    void testWriteChar() throws IOException {
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            writer.write(70);
            Assertions.assertEquals((Object)"F", (Object)writer.toString());
            writer.write(111);
            Assertions.assertEquals((Object)"Fo", (Object)writer.toString());
            writer.write(111);
            Assertions.assertEquals((Object)"Foo", (Object)writer.toString());
        }
    }

    @Test
    void testWriteCharArray() throws IOException {
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            writer.write(new char[]{'F', 'o', 'o'});
            Assertions.assertEquals((Object)"Foo", (Object)writer.toString());
            writer.write(new char[]{'B', 'a', 'r'});
            Assertions.assertEquals((Object)"FooBar", (Object)writer.toString());
        }
    }

    @Test
    void testWriteCharArrayPortion() throws IOException {
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            writer.write(FOOBAR_CHARS, 3, 3);
            Assertions.assertEquals((Object)"Bar", (Object)writer.toString());
            writer.write(FOOBAR_CHARS, 0, 3);
            Assertions.assertEquals((Object)"BarFoo", (Object)writer.toString());
        }
    }

    @Test
    void testWriteString() throws IOException {
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            writer.write("Foo");
            Assertions.assertEquals((Object)"Foo", (Object)writer.toString());
            writer.write("Bar");
            Assertions.assertEquals((Object)"FooBar", (Object)writer.toString());
        }
    }

    @Test
    void testWriteStringPortion() throws IOException {
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            writer.write("FooBar", 3, 3);
            Assertions.assertEquals((Object)"Bar", (Object)writer.toString());
            writer.write("FooBar", 0, 3);
            Assertions.assertEquals((Object)"BarFoo", (Object)writer.toString());
        }
    }
}

