/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;

public class MapLiteralTest
extends JexlTestCase {
    public void testLiteralWithStrings() throws Exception {
        Expression e = this.JEXL.createExpression("{ 'foo' : 'bar' }");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals(Collections.singletonMap("foo", "bar"), (Object)o);
    }

    public void testLiteralWithMultipleEntries() throws Exception {
        Expression e = this.JEXL.createExpression("{ 'foo' : 'bar', 'eat' : 'food' }");
        MapContext jc = new MapContext();
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("foo", "bar");
        expected.put("eat", "food");
        Object o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals(expected, (Object)o);
    }

    public void testLiteralWithNumbers() throws Exception {
        Expression e = this.JEXL.createExpression("{ 5 : 10 }");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals(Collections.singletonMap(new Integer(5), new Integer(10)), (Object)o);
        e = this.JEXL.createExpression("m = { 3 : 30, 4 : 40, 5 : 'fifty', '7' : 'seven', 7 : 'SEVEN' }");
        e.evaluate((JexlContext)jc);
        e = this.JEXL.createExpression("m.3");
        o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals((Object)new Integer(30), (Object)o);
        e = this.JEXL.createExpression("m[4]");
        o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals((Object)new Integer(40), (Object)o);
        jc.set("i", (Object)5);
        e = this.JEXL.createExpression("m[i]");
        o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals((Object)"fifty", (Object)o);
        e = this.JEXL.createExpression("m.3 = 'thirty'");
        e.evaluate((JexlContext)jc);
        e = this.JEXL.createExpression("m.3");
        o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals((Object)"thirty", (Object)o);
        e = this.JEXL.createExpression("m['7']");
        o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals((Object)"seven", (Object)o);
        e = this.JEXL.createExpression("m.7");
        o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals((Object)"SEVEN", (Object)o);
        jc.set("k", (Object)7);
        e = this.JEXL.createExpression("m[k]");
        o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals((Object)"SEVEN", (Object)o);
        jc.set("k", (Object)"7");
        e = this.JEXL.createExpression("m[k]");
        o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals((Object)"seven", (Object)o);
    }

    public void testSizeOfSimpleMapLiteral() throws Exception {
        Expression e = this.JEXL.createExpression("size({ 'foo' : 'bar' })");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals((Object)new Integer(1), (Object)o);
    }

    public void testCallingMethodsOnNewMapLiteral() throws Exception {
        Expression e = this.JEXL.createExpression("size({ 'foo' : 'bar' }.values())");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals((Object)new Integer(1), (Object)o);
    }

    public void testNotEmptySimpleMapLiteral() throws Exception {
        Expression e = this.JEXL.createExpression("empty({ 'foo' : 'bar' })");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertFalse((boolean)((Boolean)o));
    }

    public void testMapMapLiteral() throws Exception {
        Expression e = this.JEXL.createExpression("{'foo' : { 'inner' : 'bar' }}");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertNotNull((Object)o);
        jc.set("outer", o);
        e = this.JEXL.createExpression("outer.foo.inner");
        o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals((Object)"bar", (Object)o);
    }

    public void testMapArrayLiteral() throws Exception {
        Expression e = this.JEXL.createExpression("{'foo' : [ 'inner' , 'bar' ]}");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertNotNull((Object)o);
        jc.set("outer", o);
        e = this.JEXL.createExpression("outer.foo.1");
        o = e.evaluate((JexlContext)jc);
        MapLiteralTest.assertEquals((Object)"bar", (Object)o);
    }
}

