/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng;

import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.commons.rng.SplittableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;

final class UniformRandomProviderSupport {
    private static final String INVALID_STREAM_SIZE = "Invalid stream size: ";
    private static final String INVALID_UPPER_BOUND = "Upper bound must be above zero: ";
    private static final String INVALID_RANGE = "Invalid range: [%s, %s)";
    private static final long POW_32 = 0x100000000L;
    private static final String NULL_ACTION = "action must not be null";

    private UniformRandomProviderSupport() {
    }

    static void validateStreamSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException(INVALID_STREAM_SIZE + size);
        }
    }

    static void validateUpperBound(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException(INVALID_UPPER_BOUND + bound);
        }
    }

    static void validateUpperBound(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException(INVALID_UPPER_BOUND + bound);
        }
    }

    static void validateUpperBound(float bound) {
        if (!(bound > 0.0f) || !(bound <= Float.MAX_VALUE)) {
            throw new IllegalArgumentException(INVALID_UPPER_BOUND + bound);
        }
    }

    static void validateUpperBound(double bound) {
        if (!(bound > 0.0) || !(bound <= Double.MAX_VALUE)) {
            throw new IllegalArgumentException(INVALID_UPPER_BOUND + bound);
        }
    }

    static void validateRange(int origin, int bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException(String.format(INVALID_RANGE, origin, bound));
        }
    }

    static void validateRange(long origin, long bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException(String.format(INVALID_RANGE, origin, bound));
        }
    }

    static void validateRange(double origin, double bound) {
        if (origin >= bound || !Double.isFinite(origin) || !Double.isFinite(bound)) {
            throw new IllegalArgumentException(String.format(INVALID_RANGE, origin, bound));
        }
    }

    static void validateFromIndexSize(int fromIndex, int size, int length) {
        if ((fromIndex | size) < 0 || size > length - fromIndex) {
            throw new IndexOutOfBoundsException(String.format("Range [%d, %<d + %d) out of bounds for length %d", fromIndex, size, length));
        }
    }

    static void nextBytes(UniformRandomProvider source, byte[] bytes, int start, int len) {
        int indexLoopLimit = start + (len & 0x7FFFFFF8);
        int index = start;
        while (index < indexLoopLimit) {
            long random = source.nextLong();
            bytes[index++] = (byte)random;
            bytes[index++] = (byte)(random >>> 8);
            bytes[index++] = (byte)(random >>> 16);
            bytes[index++] = (byte)(random >>> 24);
            bytes[index++] = (byte)(random >>> 32);
            bytes[index++] = (byte)(random >>> 40);
            bytes[index++] = (byte)(random >>> 48);
            bytes[index++] = (byte)(random >>> 56);
        }
        int indexLimit = start + len;
        if (index < indexLimit) {
            long random = source.nextLong();
            while (true) {
                bytes[index++] = (byte)random;
                if (index == indexLimit) break;
                random >>>= 8;
            }
        }
    }

    static int nextInt(UniformRandomProvider source, int n) {
        long m = ((long)source.nextInt() & 0xFFFFFFFFL) * (long)n;
        long l = m & 0xFFFFFFFFL;
        if (l < (long)n) {
            long t = 0x100000000L % (long)n;
            while (l < t) {
                m = ((long)source.nextInt() & 0xFFFFFFFFL) * (long)n;
                l = m & 0xFFFFFFFFL;
            }
        }
        return (int)(m >>> 32);
    }

    static int nextInt(UniformRandomProvider source, int origin, int bound) {
        int n = bound - origin;
        if (n > 0) {
            return UniformRandomProviderSupport.nextInt(source, n) + origin;
        }
        int v = source.nextInt();
        while (v < origin || v >= bound) {
            v = source.nextInt();
        }
        return v;
    }

    static long nextLong(UniformRandomProvider source, long n) {
        long val;
        long bits;
        while ((bits = source.nextLong() >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    static long nextLong(UniformRandomProvider source, long origin, long bound) {
        long n = bound - origin;
        if (n > 0L) {
            return UniformRandomProviderSupport.nextLong(source, n) + origin;
        }
        long v = source.nextLong();
        while (v < origin || v >= bound) {
            v = source.nextLong();
        }
        return v;
    }

    static float nextFloat(UniformRandomProvider source, float bound) {
        float v = source.nextFloat() * bound;
        if (v >= bound) {
            v = Math.nextDown(bound);
        }
        return v;
    }

    static float nextFloat(UniformRandomProvider source, float origin, float bound) {
        float v = source.nextFloat();
        if ((v = (1.0f - v) * origin + v * bound) >= bound) {
            v = Math.nextDown(bound);
        }
        return v;
    }

    static double nextDouble(UniformRandomProvider source, double bound) {
        double v = source.nextDouble() * bound;
        if (v >= bound) {
            v = Math.nextDown(bound);
        }
        return v;
    }

    static double nextDouble(UniformRandomProvider source, double origin, double bound) {
        double v = source.nextDouble();
        if ((v = (1.0 - v) * origin + v * bound) >= bound) {
            v = Math.nextDown(bound);
        }
        return v;
    }

    static class ProviderDoublesSpliterator
    extends ProviderSpliterator
    implements Spliterator.OfDouble {
        private final SplittableUniformRandomProvider source;
        private final ToDoubleFunction<SplittableUniformRandomProvider> gen;

        ProviderDoublesSpliterator(long start, long end, SplittableUniformRandomProvider source, ToDoubleFunction<SplittableUniformRandomProvider> gen) {
            super(start, end);
            this.source = source;
            this.gen = gen;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            long start = this.position;
            long middle = start + this.end >>> 1;
            if (middle <= start) {
                return null;
            }
            this.position = middle;
            return new ProviderDoublesSpliterator(start, middle, this.source.split(), this.gen);
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            Objects.requireNonNull(action, UniformRandomProviderSupport.NULL_ACTION);
            long pos = this.position;
            if (pos < this.end) {
                this.position = pos + 1L;
                action.accept(this.gen.applyAsDouble(this.source));
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            Objects.requireNonNull(action, UniformRandomProviderSupport.NULL_ACTION);
            long pos = this.position;
            long last = this.end;
            if (pos < last) {
                this.position = last;
                SplittableUniformRandomProvider s = this.source;
                ToDoubleFunction<SplittableUniformRandomProvider> g = this.gen;
                do {
                    action.accept(g.applyAsDouble(s));
                } while (++pos < last);
            }
        }
    }

    static class ProviderLongsSpliterator
    extends ProviderSpliterator
    implements Spliterator.OfLong {
        private final SplittableUniformRandomProvider source;
        private final ToLongFunction<SplittableUniformRandomProvider> gen;

        ProviderLongsSpliterator(long start, long end, SplittableUniformRandomProvider source, ToLongFunction<SplittableUniformRandomProvider> gen) {
            super(start, end);
            this.source = source;
            this.gen = gen;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            long start = this.position;
            long middle = start + this.end >>> 1;
            if (middle <= start) {
                return null;
            }
            this.position = middle;
            return new ProviderLongsSpliterator(start, middle, this.source.split(), this.gen);
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            Objects.requireNonNull(action, UniformRandomProviderSupport.NULL_ACTION);
            long pos = this.position;
            if (pos < this.end) {
                this.position = pos + 1L;
                action.accept(this.gen.applyAsLong(this.source));
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            Objects.requireNonNull(action, UniformRandomProviderSupport.NULL_ACTION);
            long pos = this.position;
            long last = this.end;
            if (pos < last) {
                this.position = last;
                SplittableUniformRandomProvider s = this.source;
                ToLongFunction<SplittableUniformRandomProvider> g = this.gen;
                do {
                    action.accept(g.applyAsLong(s));
                } while (++pos < last);
            }
        }
    }

    static class ProviderIntsSpliterator
    extends ProviderSpliterator
    implements Spliterator.OfInt {
        private final SplittableUniformRandomProvider source;
        private final ToIntFunction<SplittableUniformRandomProvider> gen;

        ProviderIntsSpliterator(long start, long end, SplittableUniformRandomProvider source, ToIntFunction<SplittableUniformRandomProvider> gen) {
            super(start, end);
            this.source = source;
            this.gen = gen;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            long start = this.position;
            long middle = start + this.end >>> 1;
            if (middle <= start) {
                return null;
            }
            this.position = middle;
            return new ProviderIntsSpliterator(start, middle, this.source.split(), this.gen);
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            Objects.requireNonNull(action, UniformRandomProviderSupport.NULL_ACTION);
            long pos = this.position;
            if (pos < this.end) {
                this.position = pos + 1L;
                action.accept(this.gen.applyAsInt(this.source));
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            Objects.requireNonNull(action, UniformRandomProviderSupport.NULL_ACTION);
            long pos = this.position;
            long last = this.end;
            if (pos < last) {
                this.position = last;
                SplittableUniformRandomProvider s = this.source;
                ToIntFunction<SplittableUniformRandomProvider> g = this.gen;
                do {
                    action.accept(g.applyAsInt(s));
                } while (++pos < last);
            }
        }
    }

    static class ProviderSplitsSpliterator
    extends ProviderSpliterator
    implements Spliterator<SplittableUniformRandomProvider> {
        private final SplittableUniformRandomProvider source;
        private final SplittableUniformRandomProvider rng;

        ProviderSplitsSpliterator(long start, long end, SplittableUniformRandomProvider source, SplittableUniformRandomProvider rng) {
            super(start, end);
            this.source = source;
            this.rng = rng;
        }

        @Override
        public Spliterator<SplittableUniformRandomProvider> trySplit() {
            long start = this.position;
            long middle = start + this.end >>> 1;
            if (middle <= start) {
                return null;
            }
            this.position = middle;
            return new ProviderSplitsSpliterator(start, middle, this.source.split(), this.rng);
        }

        @Override
        public boolean tryAdvance(Consumer<? super SplittableUniformRandomProvider> action) {
            Objects.requireNonNull(action, UniformRandomProviderSupport.NULL_ACTION);
            long pos = this.position;
            if (pos < this.end) {
                this.position = pos + 1L;
                action.accept(this.rng.split(this.source));
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super SplittableUniformRandomProvider> action) {
            Objects.requireNonNull(action, UniformRandomProviderSupport.NULL_ACTION);
            long pos = this.position;
            long last = this.end;
            if (pos < last) {
                this.position = last;
                SplittableUniformRandomProvider s = this.source;
                SplittableUniformRandomProvider r = this.rng;
                do {
                    action.accept(r.split(s));
                } while (++pos < last);
            }
        }
    }

    private static class ProviderSpliterator {
        protected long position;
        protected final long end;

        ProviderSpliterator(long start, long end) {
            this.position = start;
            this.end = end;
        }

        public long estimateSize() {
            return this.end - this.position;
        }

        public int characteristics() {
            return 17728;
        }
    }
}

