/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.util;

import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.rng.SplittableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;

public final class RandomStreams {
    private static final int SEED_CHAR_BITS = 4;

    private RandomStreams() {
    }

    public static <T> Stream<T> generateWithSeed(long streamSize, SplittableUniformRandomProvider source, SeededObjectFactory<T> factory) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException("Invalid stream size: " + streamSize);
        }
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(factory, "factory");
        long seed = RandomStreams.createSeed((UniformRandomProvider)source);
        return StreamSupport.stream(new SeededObjectSpliterator<T>(0L, streamSize, source, factory, seed), false);
    }

    static long createSeed(UniformRandomProvider rng) {
        long bits = rng.nextLong() | 1L;
        long n = 15L;
        long unique = bits & 0xFL;
        for (int i = 4; i < 64; i += 4) {
            long c = bits >>> i & 0xFL;
            if (c != unique) continue;
            c = 15L * Integer.toUnsignedLong(rng.nextInt()) >>> 32;
            c = unique + c + 1L & 0xFL;
            bits = bits & (15L << i ^ 0xFFFFFFFFFFFFFFFFL) | c << i;
        }
        return bits;
    }

    private static final class SeededObjectSpliterator<T>
    implements Spliterator<T> {
        private static final String NULL_ACTION = "action must not be null";
        private long position;
        private final long end;
        private long seed;
        private final SplittableUniformRandomProvider source;
        private final SeededObjectFactory<T> factory;

        SeededObjectSpliterator(long start, long end, SplittableUniformRandomProvider source, SeededObjectFactory<T> factory, long seed) {
            this.position = start;
            this.end = end;
            this.seed = seed;
            this.source = source;
            this.factory = factory;
        }

        @Override
        public long estimateSize() {
            return this.end - this.position;
        }

        @Override
        public int characteristics() {
            return 17472;
        }

        @Override
        public Spliterator<T> trySplit() {
            long start = this.position;
            long middle = start + this.end >>> 1;
            if (middle <= start) {
                return null;
            }
            SeededObjectSpliterator<T> s = new SeededObjectSpliterator<T>(start, middle, this.source.split(), this.factory, this.seed);
            this.position = middle;
            while (this.seed != 0L && Long.compareUnsigned(Long.lowestOneBit(this.seed), middle) <= 0) {
                this.seed <<= 4;
            }
            return s;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Objects.requireNonNull(action, NULL_ACTION);
            long pos = this.position;
            if (pos < this.end) {
                this.position = pos + 1L;
                action.accept(this.factory.create(this.seed | pos, (UniformRandomProvider)this.source));
                if ((this.position & this.seed) != 0L) {
                    this.seed <<= 4;
                }
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            Objects.requireNonNull(action, NULL_ACTION);
            long pos = this.position;
            long last = this.end;
            if (pos < last) {
                this.position = last;
                SplittableUniformRandomProvider s = this.source;
                SeededObjectFactory<T> f = this.factory;
                do {
                    action.accept(f.create(this.seed | pos, (UniformRandomProvider)s));
                    if ((++pos & this.seed) == 0L) continue;
                    this.seed <<= 4;
                } while (pos < last);
            }
        }
    }

    public static interface SeededObjectFactory<T> {
        public T create(long var1, UniformRandomProvider var3);
    }
}

