/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import java.util.function.LongToDoubleFunction;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;

public class InverseTransformParetoSampler
extends SamplerBase
implements SharedStateContinuousSampler {
    private final double scale;
    private final double oneOverShape;
    private final UniformRandomProvider rng;
    private final LongToDoubleFunction nextDouble;

    public InverseTransformParetoSampler(UniformRandomProvider rng, double scale, double shape) {
        this(InternalUtils.requireStrictlyPositive(scale, "scale"), InternalUtils.requireStrictlyPositive(shape, "shape"), rng);
    }

    private InverseTransformParetoSampler(double scale, double shape, UniformRandomProvider rng) {
        super(null);
        this.rng = rng;
        this.scale = scale;
        this.oneOverShape = 1.0 / shape;
        this.nextDouble = shape >= 1.0 ? InternalUtils::makeNonZeroDouble : InternalUtils::makeDouble;
    }

    private InverseTransformParetoSampler(UniformRandomProvider rng, InverseTransformParetoSampler source) {
        super(null);
        this.rng = rng;
        this.scale = source.scale;
        this.oneOverShape = source.oneOverShape;
        this.nextDouble = source.nextDouble;
    }

    @Override
    public double sample() {
        return this.scale / Math.pow(this.nextDouble.applyAsDouble(this.rng.nextLong()), this.oneOverShape);
    }

    @Override
    public String toString() {
        return "[Inverse method for Pareto distribution " + this.rng.toString() + "]";
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new InverseTransformParetoSampler(rng, this);
    }

    public static SharedStateContinuousSampler of(UniformRandomProvider rng, double scale, double shape) {
        return new InverseTransformParetoSampler(rng, scale, shape);
    }
}

