/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;

public final class MarsagliaTsangWangDiscreteSampler {
    private static final int INT_8 = 256;
    private static final int INT_16 = 65536;
    private static final int INT_30 = 0x40000000;
    private static final double DOUBLE_31 = 2.147483648E9;

    private MarsagliaTsangWangDiscreteSampler() {
    }

    private static int getBase64Digit(int m, int k) {
        return m >>> 30 - 6 * k & 0x3F;
    }

    private static int toUnsignedInt30(double p) {
        return (int)(p * 1.073741824E9 + 0.5);
    }

    private static SharedStateDiscreteSampler createSampler(UniformRandomProvider rng, String distributionName, int[] prob, int offset) {
        int maxIndex = prob.length + offset - 1;
        if (maxIndex < 256) {
            return new MarsagliaTsangWangBase64Int8DiscreteSampler(rng, distributionName, prob, offset);
        }
        if (maxIndex < 65536) {
            return new MarsagliaTsangWangBase64Int16DiscreteSampler(rng, distributionName, prob, offset);
        }
        return new MarsagliaTsangWangBase64Int32DiscreteSampler(rng, distributionName, prob, offset);
    }

    public static final class Binomial {
        private static final String BINOMIAL_NAME = "Binomial";

        private Binomial() {
        }

        public static SharedStateDiscreteSampler of(UniformRandomProvider rng, int trials, double probabilityOfSuccess) {
            Binomial.validateBinomialDistributionParameters(trials, probabilityOfSuccess);
            if (probabilityOfSuccess == 0.0) {
                return new MarsagliaTsangWangFixedResultBinomialSampler(0);
            }
            if (probabilityOfSuccess == 1.0) {
                return new MarsagliaTsangWangFixedResultBinomialSampler(trials);
            }
            if (trials >= 65536) {
                throw new IllegalArgumentException("Unsupported number of trials: " + trials);
            }
            return Binomial.createBinomialDistributionSampler(rng, trials, probabilityOfSuccess);
        }

        private static void validateBinomialDistributionParameters(int trials, double probabilityOfSuccess) {
            if (trials < 0) {
                throw new IllegalArgumentException("Trials is not positive: " + trials);
            }
            InternalUtils.requireRangeClosed(0.0, 1.0, probabilityOfSuccess, "probability of success");
        }

        private static SharedStateDiscreteSampler createBinomialDistributionSampler(UniformRandomProvider rng, int trials, double probabilityOfSuccess) {
            boolean useInversion = probabilityOfSuccess > 0.5;
            double p = useInversion ? 1.0 - probabilityOfSuccess : probabilityOfSuccess;
            double p0 = Math.exp((double)trials * Math.log(1.0 - p));
            if (p0 < Double.MIN_VALUE) {
                throw new IllegalArgumentException("Unable to compute distribution");
            }
            double t = p0;
            double h = p / (1.0 - p);
            int begin = 0;
            if (t * 2.147483648E9 < 1.0) {
                for (int i = 1; i <= trials; ++i) {
                    if (!((t *= (double)(trials + 1 - i) * h / (double)i) * 2.147483648E9 >= 1.0)) continue;
                    begin = i;
                    break;
                }
            }
            int end = trials;
            for (int i = begin + 1; i <= trials; ++i) {
                if (!((t *= (double)(trials + 1 - i) * h / (double)i) * 2.147483648E9 < 1.0)) continue;
                end = i - 1;
                break;
            }
            return Binomial.createBinomialDistributionSamplerFromRange(rng, trials, p, useInversion, p0, begin, end);
        }

        private static SharedStateDiscreteSampler createBinomialDistributionSamplerFromRange(UniformRandomProvider rng, int trials, double p, boolean useInversion, double p0, int begin, int end) {
            int mode;
            int sum;
            int size = end - begin + 1;
            int[] prob = new int[size];
            double t = p0;
            double h = p / (1.0 - p);
            for (int i = 1; i <= begin; ++i) {
                t *= (double)(trials + 1 - i) * h / (double)i;
            }
            prob[0] = sum = MarsagliaTsangWangDiscreteSampler.toUnsignedInt30(t);
            for (int i = begin + 1; i <= end; ++i) {
                prob[i - begin] = MarsagliaTsangWangDiscreteSampler.toUnsignedInt30(t *= (double)(trials + 1 - i) * h / (double)i);
                sum += prob[i - begin];
            }
            int n = mode = (int)((double)(trials + 1) * p) - begin;
            prob[n] = prob[n] + Math.max(0, 0x40000000 - sum);
            SharedStateDiscreteSampler sampler = MarsagliaTsangWangDiscreteSampler.createSampler(rng, BINOMIAL_NAME, prob, begin);
            return useInversion ? new MarsagliaTsangWangInversionBinomialSampler(trials, sampler) : sampler;
        }

        private static final class MarsagliaTsangWangInversionBinomialSampler
        extends AbstractMarsagliaTsangWangDiscreteSampler {
            private final int trials;
            private final SharedStateDiscreteSampler sampler;

            MarsagliaTsangWangInversionBinomialSampler(int trials, SharedStateDiscreteSampler sampler) {
                super(null, Binomial.BINOMIAL_NAME);
                this.trials = trials;
                this.sampler = sampler;
            }

            @Override
            public int sample() {
                return this.trials - this.sampler.sample();
            }

            @Override
            public String toString() {
                return this.sampler.toString();
            }

            @Override
            public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
                return new MarsagliaTsangWangInversionBinomialSampler(this.trials, (SharedStateDiscreteSampler)this.sampler.withUniformRandomProvider(rng));
            }
        }

        private static final class MarsagliaTsangWangFixedResultBinomialSampler
        extends AbstractMarsagliaTsangWangDiscreteSampler {
            private final int result;

            MarsagliaTsangWangFixedResultBinomialSampler(int result) {
                super(null, Binomial.BINOMIAL_NAME);
                this.result = result;
            }

            @Override
            public int sample() {
                return this.result;
            }

            @Override
            public String toString() {
                return "Binomial deviate";
            }

            @Override
            public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
                return this;
            }
        }
    }

    public static final class Poisson {
        private static final String POISSON_NAME = "Poisson";
        private static final double MAX_MEAN = 1024.0;
        private static final double MEAN_THRESHOLD = 21.4;

        private Poisson() {
        }

        public static SharedStateDiscreteSampler of(UniformRandomProvider rng, double mean) {
            Poisson.validatePoissonDistributionParameters(mean);
            return mean < 21.4 ? Poisson.createPoissonDistributionFromX0(rng, mean) : Poisson.createPoissonDistributionFromXMode(rng, mean);
        }

        private static void validatePoissonDistributionParameters(double mean) {
            InternalUtils.requireStrictlyPositive(mean, "mean");
            if (mean > 1024.0) {
                throw new IllegalArgumentException("mean " + mean + " > " + 1024.0);
            }
        }

        private static SharedStateDiscreteSampler createPoissonDistributionFromX0(UniformRandomProvider rng, double mean) {
            double p0;
            double p = p0 = Math.exp(-mean);
            int i = 1;
            while (p * 2.147483648E9 >= 1.0) {
                p *= mean / (double)i++;
            }
            int size = i - 1;
            int[] prob = new int[size];
            p = p0;
            prob[0] = MarsagliaTsangWangDiscreteSampler.toUnsignedInt30(p);
            int sum = prob[0];
            for (i = 1; i < prob.length; ++i) {
                prob[i] = MarsagliaTsangWangDiscreteSampler.toUnsignedInt30(p *= mean / (double)i);
                sum += prob[i];
            }
            int n = (int)mean;
            prob[n] = prob[n] + Math.max(0, 0x40000000 - sum);
            return MarsagliaTsangWangDiscreteSampler.createSampler(rng, POISSON_NAME, prob, 0);
        }

        private static SharedStateDiscreteSampler createPoissonDistributionFromXMode(UniformRandomProvider rng, double mean) {
            int mode = (int)mean;
            double c = mean * Math.exp(-mean / (double)mode);
            double p = 1.0;
            for (int i = 1; i <= mode; ++i) {
                p *= c / (double)i;
            }
            double pMode = p;
            int i = mode + 1;
            while (p * 2.147483648E9 >= 1.0) {
                p *= mean / (double)i++;
            }
            int last = i - 2;
            p = pMode;
            int j = -1;
            for (i = mode - 1; i >= 0; --i) {
                if (!((p *= (double)(i + 1) / mean) * 2.147483648E9 < 1.0)) continue;
                j = i;
                break;
            }
            int offset = j + 1;
            int size = last - offset + 1;
            int[] prob = new int[size];
            p = pMode;
            prob[mode - offset] = MarsagliaTsangWangDiscreteSampler.toUnsignedInt30(p);
            int sum = prob[mode - offset];
            for (i = mode + 1; i <= last; ++i) {
                prob[i - offset] = MarsagliaTsangWangDiscreteSampler.toUnsignedInt30(p *= mean / (double)i);
                sum += prob[i - offset];
            }
            p = pMode;
            for (i = mode - 1; i >= offset; --i) {
                prob[i - offset] = MarsagliaTsangWangDiscreteSampler.toUnsignedInt30(p *= (double)(i + 1) / mean);
                sum += prob[i - offset];
            }
            int n = mode - offset;
            prob[n] = prob[n] + Math.max(0, 0x40000000 - sum);
            return MarsagliaTsangWangDiscreteSampler.createSampler(rng, POISSON_NAME, prob, offset);
        }
    }

    public static final class Enumerated {
        private static final String ENUMERATED_NAME = "Enumerated";

        private Enumerated() {
        }

        public static SharedStateDiscreteSampler of(UniformRandomProvider rng, double[] probabilities) {
            return MarsagliaTsangWangDiscreteSampler.createSampler(rng, ENUMERATED_NAME, Enumerated.normaliseProbabilities(probabilities), 0);
        }

        private static int[] normaliseProbabilities(double[] probabilities) {
            double sumProb = InternalUtils.validateProbabilities(probabilities);
            double normalisation = 1.073741824E9 / sumProb;
            int[] prob = new int[probabilities.length];
            int sum = 0;
            int max = 0;
            int mode = 0;
            for (int i = 0; i < prob.length; ++i) {
                int p = (int)(probabilities[i] * normalisation + 0.5);
                sum += p;
                if (max < p) {
                    max = p;
                    mode = i;
                }
                prob[i] = p;
            }
            int n = mode;
            prob[n] = prob[n] + (0x40000000 - sum);
            return prob;
        }
    }

    private static final class MarsagliaTsangWangBase64Int32DiscreteSampler
    extends AbstractMarsagliaTsangWangDiscreteSampler {
        private final int t1;
        private final int t2;
        private final int t3;
        private final int t4;
        private final int[] table1;
        private final int[] table2;
        private final int[] table3;
        private final int[] table4;
        private final int[] table5;

        MarsagliaTsangWangBase64Int32DiscreteSampler(UniformRandomProvider rng, String distributionName, int[] prob, int offset) {
            super(rng, distributionName);
            int n1 = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int m : prob) {
                n1 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 1);
                n2 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 2);
                n3 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 3);
                n4 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 4);
                n5 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 5);
            }
            this.table1 = new int[n1];
            this.table2 = new int[n2];
            this.table3 = new int[n3];
            this.table4 = new int[n4];
            this.table5 = new int[n5];
            this.t1 = n1 << 24;
            this.t2 = this.t1 + (n2 << 18);
            this.t3 = this.t2 + (n3 << 12);
            this.t4 = this.t3 + (n4 << 6);
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            n1 = 0;
            for (int i = 0; i < prob.length; ++i) {
                int m = prob[i];
                int k = i + offset;
                n1 = MarsagliaTsangWangBase64Int32DiscreteSampler.fill(this.table1, n1, n1 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 1), k);
                n2 = MarsagliaTsangWangBase64Int32DiscreteSampler.fill(this.table2, n2, n2 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 2), k);
                n3 = MarsagliaTsangWangBase64Int32DiscreteSampler.fill(this.table3, n3, n3 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 3), k);
                n4 = MarsagliaTsangWangBase64Int32DiscreteSampler.fill(this.table4, n4, n4 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 4), k);
                n5 = MarsagliaTsangWangBase64Int32DiscreteSampler.fill(this.table5, n5, n5 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 5), k);
            }
        }

        private MarsagliaTsangWangBase64Int32DiscreteSampler(UniformRandomProvider rng, MarsagliaTsangWangBase64Int32DiscreteSampler source) {
            super(rng, source);
            this.t1 = source.t1;
            this.t2 = source.t2;
            this.t3 = source.t3;
            this.t4 = source.t4;
            this.table1 = source.table1;
            this.table2 = source.table2;
            this.table3 = source.table3;
            this.table4 = source.table4;
            this.table5 = source.table5;
        }

        private static int fill(int[] table, int from, int to, int value) {
            for (int i = from; i < to; ++i) {
                table[i] = value;
            }
            return to;
        }

        @Override
        public int sample() {
            int j = this.rng.nextInt() >>> 2;
            if (j < this.t1) {
                return this.table1[j >>> 24];
            }
            if (j < this.t2) {
                return this.table2[j - this.t1 >>> 18];
            }
            if (j < this.t3) {
                return this.table3[j - this.t2 >>> 12];
            }
            if (j < this.t4) {
                return this.table4[j - this.t3 >>> 6];
            }
            return this.table5[j - this.t4];
        }

        @Override
        public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new MarsagliaTsangWangBase64Int32DiscreteSampler(rng, this);
        }
    }

    private static final class MarsagliaTsangWangBase64Int16DiscreteSampler
    extends AbstractMarsagliaTsangWangDiscreteSampler {
        private static final int MASK = 65535;
        private final int t1;
        private final int t2;
        private final int t3;
        private final int t4;
        private final short[] table1;
        private final short[] table2;
        private final short[] table3;
        private final short[] table4;
        private final short[] table5;

        MarsagliaTsangWangBase64Int16DiscreteSampler(UniformRandomProvider rng, String distributionName, int[] prob, int offset) {
            super(rng, distributionName);
            int n1 = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int m : prob) {
                n1 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 1);
                n2 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 2);
                n3 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 3);
                n4 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 4);
                n5 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 5);
            }
            this.table1 = new short[n1];
            this.table2 = new short[n2];
            this.table3 = new short[n3];
            this.table4 = new short[n4];
            this.table5 = new short[n5];
            this.t1 = n1 << 24;
            this.t2 = this.t1 + (n2 << 18);
            this.t3 = this.t2 + (n3 << 12);
            this.t4 = this.t3 + (n4 << 6);
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            n1 = 0;
            for (int i = 0; i < prob.length; ++i) {
                int m = prob[i];
                short k = (short)(i + offset);
                n1 = MarsagliaTsangWangBase64Int16DiscreteSampler.fill(this.table1, n1, n1 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 1), k);
                n2 = MarsagliaTsangWangBase64Int16DiscreteSampler.fill(this.table2, n2, n2 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 2), k);
                n3 = MarsagliaTsangWangBase64Int16DiscreteSampler.fill(this.table3, n3, n3 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 3), k);
                n4 = MarsagliaTsangWangBase64Int16DiscreteSampler.fill(this.table4, n4, n4 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 4), k);
                n5 = MarsagliaTsangWangBase64Int16DiscreteSampler.fill(this.table5, n5, n5 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 5), k);
            }
        }

        private MarsagliaTsangWangBase64Int16DiscreteSampler(UniformRandomProvider rng, MarsagliaTsangWangBase64Int16DiscreteSampler source) {
            super(rng, source);
            this.t1 = source.t1;
            this.t2 = source.t2;
            this.t3 = source.t3;
            this.t4 = source.t4;
            this.table1 = source.table1;
            this.table2 = source.table2;
            this.table3 = source.table3;
            this.table4 = source.table4;
            this.table5 = source.table5;
        }

        private static int fill(short[] table, int from, int to, short value) {
            for (int i = from; i < to; ++i) {
                table[i] = value;
            }
            return to;
        }

        @Override
        public int sample() {
            int j = this.rng.nextInt() >>> 2;
            if (j < this.t1) {
                return this.table1[j >>> 24] & 0xFFFF;
            }
            if (j < this.t2) {
                return this.table2[j - this.t1 >>> 18] & 0xFFFF;
            }
            if (j < this.t3) {
                return this.table3[j - this.t2 >>> 12] & 0xFFFF;
            }
            if (j < this.t4) {
                return this.table4[j - this.t3 >>> 6] & 0xFFFF;
            }
            return this.table5[j - this.t4] & 0xFFFF;
        }

        @Override
        public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new MarsagliaTsangWangBase64Int16DiscreteSampler(rng, this);
        }
    }

    private static final class MarsagliaTsangWangBase64Int8DiscreteSampler
    extends AbstractMarsagliaTsangWangDiscreteSampler {
        private static final int MASK = 255;
        private final int t1;
        private final int t2;
        private final int t3;
        private final int t4;
        private final byte[] table1;
        private final byte[] table2;
        private final byte[] table3;
        private final byte[] table4;
        private final byte[] table5;

        MarsagliaTsangWangBase64Int8DiscreteSampler(UniformRandomProvider rng, String distributionName, int[] prob, int offset) {
            super(rng, distributionName);
            int n1 = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int m : prob) {
                n1 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 1);
                n2 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 2);
                n3 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 3);
                n4 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 4);
                n5 += MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 5);
            }
            this.table1 = new byte[n1];
            this.table2 = new byte[n2];
            this.table3 = new byte[n3];
            this.table4 = new byte[n4];
            this.table5 = new byte[n5];
            this.t1 = n1 << 24;
            this.t2 = this.t1 + (n2 << 18);
            this.t3 = this.t2 + (n3 << 12);
            this.t4 = this.t3 + (n4 << 6);
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            n1 = 0;
            for (int i = 0; i < prob.length; ++i) {
                int m = prob[i];
                byte k = (byte)(i + offset);
                n1 = MarsagliaTsangWangBase64Int8DiscreteSampler.fill(this.table1, n1, n1 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 1), k);
                n2 = MarsagliaTsangWangBase64Int8DiscreteSampler.fill(this.table2, n2, n2 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 2), k);
                n3 = MarsagliaTsangWangBase64Int8DiscreteSampler.fill(this.table3, n3, n3 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 3), k);
                n4 = MarsagliaTsangWangBase64Int8DiscreteSampler.fill(this.table4, n4, n4 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 4), k);
                n5 = MarsagliaTsangWangBase64Int8DiscreteSampler.fill(this.table5, n5, n5 + MarsagliaTsangWangDiscreteSampler.getBase64Digit(m, 5), k);
            }
        }

        private MarsagliaTsangWangBase64Int8DiscreteSampler(UniformRandomProvider rng, MarsagliaTsangWangBase64Int8DiscreteSampler source) {
            super(rng, source);
            this.t1 = source.t1;
            this.t2 = source.t2;
            this.t3 = source.t3;
            this.t4 = source.t4;
            this.table1 = source.table1;
            this.table2 = source.table2;
            this.table3 = source.table3;
            this.table4 = source.table4;
            this.table5 = source.table5;
        }

        private static int fill(byte[] table, int from, int to, byte value) {
            for (int i = from; i < to; ++i) {
                table[i] = value;
            }
            return to;
        }

        @Override
        public int sample() {
            int j = this.rng.nextInt() >>> 2;
            if (j < this.t1) {
                return this.table1[j >>> 24] & 0xFF;
            }
            if (j < this.t2) {
                return this.table2[j - this.t1 >>> 18] & 0xFF;
            }
            if (j < this.t3) {
                return this.table3[j - this.t2 >>> 12] & 0xFF;
            }
            if (j < this.t4) {
                return this.table4[j - this.t3 >>> 6] & 0xFF;
            }
            return this.table5[j - this.t4] & 0xFF;
        }

        @Override
        public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new MarsagliaTsangWangBase64Int8DiscreteSampler(rng, this);
        }
    }

    private static abstract class AbstractMarsagliaTsangWangDiscreteSampler
    implements SharedStateDiscreteSampler {
        protected final UniformRandomProvider rng;
        private final String distributionName;

        AbstractMarsagliaTsangWangDiscreteSampler(UniformRandomProvider rng, String distributionName) {
            this.rng = rng;
            this.distributionName = distributionName;
        }

        AbstractMarsagliaTsangWangDiscreteSampler(UniformRandomProvider rng, AbstractMarsagliaTsangWangDiscreteSampler source) {
            this.rng = rng;
            this.distributionName = source.distributionName;
        }

        public String toString() {
            return "Marsaglia Tsang Wang " + this.distributionName + " deviate [" + this.rng.toString() + "]";
        }
    }
}

