/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.common.security.SimpleSecurityContext;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oidc.common.AbstractUserInfo;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContext;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContextImpl;

public class OidcSecurityContext
extends SimpleSecurityContext
implements SecurityContext {
    private OidcClientTokenContext oidcContext;
    private String roleClaim;

    public OidcSecurityContext(IdToken token) {
        this(new OidcClientTokenContextImpl(token));
    }

    public OidcSecurityContext(OidcClientTokenContext oidcContext) {
        super(OidcSecurityContext.getPrincipalName(oidcContext));
        this.oidcContext = oidcContext;
    }

    public OidcClientTokenContext getOidcContext() {
        return this.oidcContext;
    }

    protected static String getPrincipalName(OidcClientTokenContext oidcContext) {
        String name = null;
        if (oidcContext.getUserInfo() != null) {
            name = OidcSecurityContext.getPrincipalName(oidcContext.getUserInfo());
        }
        if (name == null && oidcContext.getIdToken() != null) {
            name = OidcSecurityContext.getPrincipalName(oidcContext.getIdToken());
        }
        return name;
    }

    protected static String getPrincipalName(AbstractUserInfo info) {
        String name = info.getPreferredUserName();
        if (name == null) {
            name = info.getGivenName();
        }
        if (name == null) {
            name = info.getNickName();
        }
        if (name == null) {
            name = info.getName();
        }
        if (name == null) {
            name = info.getSubject();
        }
        return name;
    }

    public boolean isSecure() {
        String value = HttpUtils.getEndpointAddress((Message)JAXRSUtils.getCurrentMessage());
        return value.startsWith("https://");
    }

    public String getAuthenticationScheme() {
        return "OIDC";
    }

    public boolean isUserInRole(String role) {
        return this.roleClaim != null && role != null && (this.containsClaim(this.oidcContext.getIdToken(), this.roleClaim, role) || this.containsClaim(this.oidcContext.getUserInfo(), this.roleClaim, role));
    }

    private boolean containsClaim(AbstractUserInfo userInfo, String claim, String claimValue) {
        return userInfo != null && userInfo.containsProperty(claim) && claimValue.equals(userInfo.getProperty(claim));
    }

    public void setRoleClaim(String roleClaim) {
        this.roleClaim = roleClaim;
    }
}

