/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmFilter
extends AbstractInitializableComponent
implements MetadataFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AlgorithmFilter.class);
    @Nonnull
    private AlgorithmRegistry registry = AlgorithmSupport.getGlobalAlgorithmRegistry();
    @Nonnull
    @NonnullElements
    private Multimap<Predicate<EntityDescriptor>, XMLObject> applyMap;
    @Nonnull
    private final SAMLObjectBuilder<Extensions> extBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Extensions.DEFAULT_ELEMENT_NAME);

    public AlgorithmFilter() {
        this.applyMap = ArrayListMultimap.create();
    }

    public void setRules(@Nonnull @NonnullElements Map<Predicate<EntityDescriptor>, Collection<XMLObject>> rules) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(rules, (String)"Rules map cannot be null");
        rules.values().stream().flatMap(Collection::stream).filter(DigestMethod.class::isInstance).map(DigestMethod.class::cast).map(DigestMethod::getAlgorithm).distinct().forEach(uri -> this.checkDigestMethod((String)uri));
        rules.values().stream().flatMap(Collection::stream).filter(SigningMethod.class::isInstance).map(SigningMethod.class::cast).map(SigningMethod::getAlgorithm).distinct().forEach(uri -> this.checkSigningMethod((String)uri));
        rules.values().stream().flatMap(Collection::stream).filter(EncryptionMethod.class::isInstance).map(EncryptionMethod.class::cast).map(org.opensaml.xmlsec.encryption.EncryptionMethod::getAlgorithm).distinct().forEach(uri -> this.checkEncryptionMethod((String)uri));
        this.applyMap = ArrayListMultimap.create((int)rules.size(), (int)1);
        for (Map.Entry<Predicate<EntityDescriptor>, Collection<XMLObject>> entry : rules.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.applyMap.putAll(entry.getKey(), List.copyOf(entry.getValue()));
        }
    }

    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof EntitiesDescriptor) {
            this.filterEntitiesDescriptor((EntitiesDescriptor)metadata);
        } else {
            this.filterEntityDescriptor((EntityDescriptor)metadata);
        }
        return metadata;
    }

    protected void filterEntityDescriptor(@Nonnull EntityDescriptor descriptor) {
        Set existingDigests = Collections.emptySet();
        Set existingSignings = Collections.emptySet();
        Extensions exts = descriptor.getExtensions();
        if (exts != null) {
            existingDigests = exts.getUnknownXMLObjects(DigestMethod.DEFAULT_ELEMENT_NAME).stream().filter(DigestMethod.class::isInstance).map(DigestMethod.class::cast).map(DigestMethod::getAlgorithm).distinct().collect(Collectors.toUnmodifiableSet());
            existingSignings = exts.getUnknownXMLObjects(SigningMethod.DEFAULT_ELEMENT_NAME).stream().filter(SigningMethod.class::isInstance).map(SigningMethod.class::cast).map(SigningMethod::getAlgorithm).distinct().collect(Collectors.toUnmodifiableSet());
        }
        for (Map.Entry entry : this.applyMap.asMap().entrySet()) {
            if (((Collection)entry.getValue()).isEmpty() || !((Predicate)entry.getKey()).test(descriptor)) continue;
            for (XMLObject xmlObject : (Collection)entry.getValue()) {
                try {
                    if (xmlObject instanceof DigestMethod) {
                        if (existingDigests.contains(((DigestMethod)xmlObject).getAlgorithm())) {
                            this.log.debug("Skipping pre-existing DigestMethod ({}) on EntityDescriptor ({})", (Object)((DigestMethod)xmlObject).getAlgorithm(), (Object)descriptor.getEntityID());
                            continue;
                        }
                        this.log.info("Adding DigestMethod ({}) to EntityDescriptor ({})", (Object)((DigestMethod)xmlObject).getAlgorithm(), (Object)descriptor.getEntityID());
                        this.getExtensions(descriptor).getUnknownXMLObjects().add(XMLObjectSupport.cloneXMLObject((XMLObject)xmlObject));
                        continue;
                    }
                    if (xmlObject instanceof SigningMethod) {
                        if (existingSignings.contains(((SigningMethod)xmlObject).getAlgorithm())) {
                            this.log.debug("Skipping pre-existing SigningMethod ({}) on EntityDescriptor ({})", (Object)((SigningMethod)xmlObject).getAlgorithm(), (Object)descriptor.getEntityID());
                            continue;
                        }
                        this.log.info("Adding SigningMethod ({}) to EntityDescriptor ({})", (Object)((SigningMethod)xmlObject).getAlgorithm(), (Object)descriptor.getEntityID());
                        this.getExtensions(descriptor).getUnknownXMLObjects().add(XMLObjectSupport.cloneXMLObject((XMLObject)xmlObject));
                        continue;
                    }
                    if (!(xmlObject instanceof EncryptionMethod)) continue;
                    this.addEncryptionMethod(descriptor, (EncryptionMethod)xmlObject);
                }
                catch (MarshallingException | UnmarshallingException e) {
                    this.log.error("Error cloning XMLObject", e);
                }
            }
        }
    }

    protected void filterEntitiesDescriptor(@Nonnull EntitiesDescriptor descriptor) {
        for (EntitiesDescriptor group : descriptor.getEntitiesDescriptors()) {
            this.filterEntitiesDescriptor(group);
        }
        for (EntityDescriptor entity : descriptor.getEntityDescriptors()) {
            this.filterEntityDescriptor(entity);
        }
    }

    @Nonnull
    protected Extensions getExtensions(@Nonnull EntityDescriptor descriptor) {
        Extensions extensions = descriptor.getExtensions();
        if (extensions == null) {
            extensions = (Extensions)this.extBuilder.buildObject();
            descriptor.setExtensions(extensions);
        }
        return extensions;
    }

    protected void addEncryptionMethod(@Nonnull EntityDescriptor descriptor, @Nonnull EncryptionMethod encryptionMethod) {
        for (RoleDescriptor role : descriptor.getRoleDescriptors()) {
            for (KeyDescriptor key : role.getKeyDescriptors()) {
                if (key.getUse() != null && key.getUse() == UsageType.SIGNING) continue;
                List existingMethods = key.getEncryptionMethods();
                for (EncryptionMethod method : existingMethods) {
                    if (!Objects.equals(method.getAlgorithm(), encryptionMethod.getAlgorithm())) continue;
                    this.log.debug("Skipping pre-existing EncryptionMethod ({}) on EntityDescriptor ({})", (Object)encryptionMethod.getAlgorithm(), (Object)descriptor.getEntityID());
                    return;
                }
                try {
                    this.log.info("Adding EncryptionMethod ({}) to EntityDescriptor ({})", (Object)encryptionMethod.getAlgorithm(), (Object)descriptor.getEntityID());
                    existingMethods.add((EncryptionMethod)XMLObjectSupport.cloneXMLObject((XMLObject)encryptionMethod));
                }
                catch (MarshallingException | UnmarshallingException e) {
                    this.log.error("Error cloning XMLObject", e);
                }
            }
        }
    }

    private void checkDigestMethod(@Nonnull @NotEmpty String uri) {
        if (this.registry != null) {
            if (!this.registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.MessageDigest).contains(uri)) {
                this.log.warn("DigestMethod {} unrecognized by algorithm registry", (Object)uri);
            } else if (!this.registry.isRuntimeSupported(uri)) {
                this.log.warn("DigestMethod {} unsupported by runtime", (Object)uri);
            }
        }
    }

    private void checkSigningMethod(@Nonnull @NotEmpty String uri) {
        if (this.registry != null) {
            if (!this.registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.Signature).contains(uri) && !this.registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.Mac).contains(uri)) {
                this.log.warn("SigningMethod {} unrecognized by algorithm registry", (Object)uri);
            } else if (!this.registry.isRuntimeSupported(uri)) {
                this.log.warn("SigningMethod {} unsupported by runtime", (Object)uri);
            }
        }
    }

    private void checkEncryptionMethod(@Nonnull @NotEmpty String uri) {
        if (this.registry != null) {
            if (!(this.registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.BlockEncryption).contains(uri) || this.registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.KeyTransport).contains(uri) || this.registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.KeyAgreement).contains(uri) || this.registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.SymmetricKeyWrap).contains(uri))) {
                this.log.warn("EncryptionMethod {} unrecognized by algorithm registry", (Object)uri);
            } else if (!this.registry.isRuntimeSupported(uri)) {
                this.log.warn("EncryptionMethod {} unsupported by runtime", (Object)uri);
            }
        }
    }
}

