/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import org.apache.activemq.artemis.core.management.impl.view.ConsumerField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerConsumer;

public class ConsumerFilterPredicate
extends ActiveMQFilterPredicate<ServerConsumer> {
    private ConsumerField f;
    private final ActiveMQServer server;

    public ConsumerFilterPredicate(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean test(ServerConsumer consumer) {
        if (this.f == null) {
            return true;
        }
        switch (this.f) {
            case ID: {
                return this.matches(consumer.getSequentialID());
            }
            case SESSION: {
                return this.matches(consumer.getSessionID());
            }
            case USER: {
                return this.matches(this.server.getSessionByID(consumer.getSessionID()).getUsername());
            }
            case VALIDATED_USER: {
                return this.matches(this.server.getSessionByID(consumer.getSessionID()).getValidatedUser());
            }
            case ADDRESS: {
                return this.matches(consumer.getQueue().getAddress());
            }
            case QUEUE: {
                return this.matches(consumer.getQueue().getName());
            }
            case FILTER: {
                return this.matches(consumer.getFilterString());
            }
            case PROTOCOL: {
                return this.matches(this.server.getSessionByID(consumer.getSessionID()).getRemotingConnection().getProtocolName());
            }
            case CLIENT_ID: {
                return this.matches(this.server.getSessionByID(consumer.getSessionID()).getRemotingConnection().getClientID());
            }
            case LOCAL_ADDRESS: {
                return this.matches(this.server.getSessionByID(consumer.getSessionID()).getRemotingConnection().getTransportConnection().getLocalAddress());
            }
            case REMOTE_ADDRESS: {
                return this.matches(this.server.getSessionByID(consumer.getSessionID()).getRemotingConnection().getTransportConnection().getRemoteAddress());
            }
            case MESSAGES_IN_TRANSIT: {
                return this.matches(consumer.getMessagesInTransit());
            }
            case MESSAGES_IN_TRANSIT_SIZE: {
                return this.matches(consumer.getMessagesInTransitSize());
            }
            case MESSAGES_DELIVERED: {
                return this.matches(consumer.getDeliveringMessages());
            }
            case MESSAGES_DELIVERED_SIZE: {
                return this.matches(consumer.getMessagesDeliveredSize());
            }
            case MESSAGES_ACKNOWLEDGED: {
                return this.matches(consumer.getMessagesAcknowledged());
            }
            case MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT: {
                return this.matches(consumer.getMessagesAcknowledgedAwaitingCommit());
            }
        }
        return true;
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.equals("")) {
            this.f = ConsumerField.valueOfName(field);
            if (this.f == null) {
                this.f = ConsumerField.valueOf(field);
            }
        }
    }
}

