/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.atmosphere;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.transport.websocket.atmosphere.DefaultProtocolInterceptor;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.interceptor.CacheHeadersInterceptor;
import org.atmosphere.interceptor.HeartbeatInterceptor;
import org.atmosphere.interceptor.JavaScriptProtocol;
import org.atmosphere.interceptor.SSEAtmosphereInterceptor;
import org.atmosphere.util.Utils;

public final class AtmosphereUtils {
    private AtmosphereUtils() {
    }

    public static void addInterceptors(AtmosphereFramework framework, Bus bus) {
        Object ais = bus.getProperty("atmosphere.interceptors");
        framework.interceptor((AtmosphereInterceptor)new CacheHeadersInterceptor()).interceptor((AtmosphereInterceptor)new HeartbeatInterceptor()).interceptor((AtmosphereInterceptor)new SSEAtmosphereInterceptor()).interceptor((AtmosphereInterceptor)new JavaScriptProtocol());
        if (ais == null || ais instanceof AtmosphereInterceptor) {
            framework.interceptor((AtmosphereInterceptor)(ais == null ? new DefaultProtocolInterceptor() : (AtmosphereInterceptor)ais));
            return;
        }
        if (ais instanceof List) {
            List icps = CastUtils.cast((List)((List)ais));
            for (AtmosphereInterceptor icp : icps) {
                framework.interceptor(icp);
            }
        }
    }

    public static boolean useAtmosphere(HttpServletRequest req) {
        return Utils.webSocketEnabled((HttpServletRequest)req) || req.getParameter("X-Atmosphere-Transport") != null;
    }
}

