/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jgroups.util.Streamable;

public class DrawCommand
implements Streamable {
    static final byte DRAW = 1;
    static final byte CLEAR = 2;
    byte mode;
    int x;
    int y;
    int rgb;

    public DrawCommand() {
    }

    DrawCommand(byte mode) {
        this.mode = mode;
    }

    DrawCommand(byte mode, int x, int y, int rgb) {
        this.mode = mode;
        this.x = x;
        this.y = y;
        this.rgb = rgb;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.mode);
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.rgb);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.mode = in.readByte();
        this.x = in.readInt();
        this.y = in.readInt();
        this.rgb = in.readInt();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        switch (this.mode) {
            case 1: {
                ret.append("DRAW(" + this.x + ", " + this.y + ") [" + this.rgb + "]");
                break;
            }
            case 2: {
                ret.append("CLEAR");
                break;
            }
            default: {
                return "<undefined>";
            }
        }
        return ret.toString();
    }
}

