/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ForwardingRoute
implements Comparable<ForwardingRoute> {
    protected String to;
    protected String gateway;
    protected Pattern p;

    public ForwardingRoute(String to, String gateway) {
        this.to = Objects.requireNonNull(to);
        this.gateway = Objects.requireNonNull(gateway);
        this.p = Pattern.compile(to);
    }

    public String to() {
        return this.to;
    }

    public ForwardingRoute to(String to) {
        this.to = Objects.requireNonNull(to);
        this.p = Pattern.compile(to);
        return this;
    }

    public String gateway() {
        return this.gateway;
    }

    public ForwardingRoute gateway(String gw) {
        this.gateway = Objects.requireNonNull(gw);
        return this;
    }

    public boolean matches(String site) {
        Matcher m = this.p.matcher(site);
        return m.matches();
    }

    @Override
    public int compareTo(ForwardingRoute o) {
        if (this == o) {
            return 0;
        }
        int rc = this.gateway.compareTo(o.gateway);
        return rc != 0 ? rc : this.to.compareTo(o.to);
    }

    public boolean equals(Object obj) {
        return this.compareTo((ForwardingRoute)obj) == 0;
    }

    public String toString() {
        return String.format("to=%s, gw=%s", this.to, this.gateway);
    }
}

