/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.xml;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.DOMTypeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.shared.xml.QNameSupport;
import net.shibboleth.shared.xml.XMLConstants;
import net.shibboleth.shared.xml.XMLSpace;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public final class AttributeSupport {
    private AttributeSupport() {
    }

    public static void addXMLBase(@Nonnull Element element, @Nonnull String base) {
        Constraint.isNotNull(element, "Element may not be null");
        Constraint.isNotNull(base, "base attribute value may not be null");
        Attr attr = AttributeSupport.constructAttribute(ElementSupport.ensureOwnerDocument(element), XMLConstants.XML_BASE_ATTRIB_NAME);
        attr.setValue(base);
        element.setAttributeNodeNS(attr);
    }

    public static void addXMLId(@Nonnull Element element, @Nonnull String id) {
        Constraint.isNotNull(element, "Element may not be null");
        Constraint.isNotNull(id, "id attribute value may not be null");
        Attr attr = AttributeSupport.constructAttribute(ElementSupport.ensureOwnerDocument(element), XMLConstants.XML_ID_ATTRIB_NAME);
        attr.setValue(id);
        element.setAttributeNodeNS(attr);
        element.setIdAttributeNode(attr, true);
    }

    public static void addXMLLang(@Nonnull Element element, @Nonnull String lang) {
        Constraint.isNotNull(element, "Element may not be null");
        Constraint.isNotNull(lang, "lang attribute value may not be null");
        Attr attr = AttributeSupport.constructAttribute(ElementSupport.ensureOwnerDocument(element), XMLConstants.XML_LANG_ATTRIB_NAME);
        attr.setValue(lang);
        element.setAttributeNodeNS(attr);
    }

    public static void addXMLSpace(@Nonnull Element element, @Nonnull XMLSpace space) {
        Constraint.isNotNull(element, "Element may not be null");
        Constraint.isNotNull(space, "space attribute value may not be null");
        Attr attr = AttributeSupport.constructAttribute(ElementSupport.ensureOwnerDocument(element), XMLConstants.XML_SPACE_ATTRIB_NAME);
        attr.setValue(space.toString());
        element.setAttributeNodeNS(attr);
    }

    public static void appendAttribute(@Nonnull Element element, @Nonnull QName attributeName, @Nonnull List<String> attributeValues, boolean isIDAttribute) {
        AttributeSupport.appendAttribute(element, attributeName, StringSupport.listToStringValue(attributeValues, " "), isIDAttribute);
    }

    public static void appendAttribute(@Nonnull Element element, @Nonnull QName attributeName, @Nonnull String attributeValue) {
        AttributeSupport.appendAttribute(element, attributeName, attributeValue, false);
    }

    public static void appendAttribute(@Nonnull Element element, @Nonnull QName attributeName, @Nonnull String attributeValue, boolean isIDAttribute) {
        Constraint.isNotNull(element, "Element may not be null");
        Constraint.isNotNull(attributeName, "Attribute name may not be null");
        Constraint.isNotNull(attributeValue, "Attribute value may not be null");
        Document document = element.getOwnerDocument();
        assert (document != null);
        Attr attribute = AttributeSupport.constructAttribute(document, attributeName);
        attribute.setValue(attributeValue);
        element.setAttributeNodeNS(attribute);
        if (isIDAttribute) {
            element.setIdAttributeNode(attribute, true);
        }
    }

    public static void appendDateTimeAttribute(@Nonnull Element element, @Nonnull QName attributeName, @Nonnull Instant instant) {
        AttributeSupport.appendAttribute(element, attributeName, DOMTypeSupport.instantToString(instant));
    }

    public static void appendDurationAttribute(@Nonnull Element element, @Nonnull QName attributeName, @Nonnull Duration duration) {
        AttributeSupport.appendAttribute(element, attributeName, DOMTypeSupport.durationToString(duration));
    }

    @Nonnull
    public static Attr constructAttribute(@Nonnull Document owningDocument, @Nonnull QName attributeName) {
        Constraint.isNotNull(attributeName, "Attribute name can not be null");
        return AttributeSupport.constructAttribute(owningDocument, attributeName.getNamespaceURI(), QNameSupport.ensureLocalPart(attributeName), attributeName.getPrefix());
    }

    @Nonnull
    public static Attr constructAttribute(@Nonnull Document document, @Nullable String namespaceURI, @Nonnull String localName, @Nullable String prefix) {
        Constraint.isNotNull(document, "Document may not null");
        String trimmedLocalName = Constraint.isNotNull(StringSupport.trimOrNull(localName), "Attribute local name may not be null or empty");
        String trimmedPrefix = StringSupport.trimOrNull(prefix);
        Object qualifiedName = trimmedPrefix != null ? trimmedPrefix + ":" + StringSupport.trimOrNull(trimmedLocalName) : StringSupport.trimOrNull(trimmedLocalName);
        Attr ret = document.createAttributeNS(StringSupport.trimOrNull(namespaceURI), (String)qualifiedName);
        assert (ret != null);
        return ret;
    }

    @Nullable
    public static Attr getAttribute(@Nonnull Element element, @Nonnull QName attributeName) {
        return element.getAttributeNodeNS(StringSupport.trimOrNull(attributeName.getNamespaceURI()), attributeName.getLocalPart());
    }

    @Nullable
    public static String getAttributeValue(@Nonnull Element element, @Nonnull QName attributeName) {
        return AttributeSupport.getAttributeValue(element, StringSupport.trimOrNull(attributeName.getNamespaceURI()), QNameSupport.ensureLocalPart(attributeName));
    }

    @Nullable
    public static String getAttributeValue(@Nonnull Element element, @Nullable String namespace, @Nonnull @NotEmpty String attributeLocalName) {
        Attr attr = element.getAttributeNodeNS(namespace, attributeLocalName);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    @Nonnull
    @NotEmpty
    public static String ensureAttributeValue(@Nonnull Element element, @Nullable String namespace, @Nonnull @NotEmpty String attributeLocalName) {
        String value = StringSupport.trimOrNull(AttributeSupport.getAttributeValue(element, namespace, attributeLocalName));
        if (value == null) {
            throw new IllegalStateException(attributeLocalName + " cannot be null or empty");
        }
        return value;
    }

    @Nonnull
    @NotEmpty
    public static String ensureAttributeValue(@Nonnull Element element, @Nonnull QName attributeName) {
        String value = StringSupport.trimOrNull(AttributeSupport.getAttributeValue(element, attributeName));
        if (value == null) {
            throw new IllegalStateException(QNameSupport.ensureLocalPart(attributeName) + " cannot be null or empty");
        }
        return value;
    }

    @Nullable
    public static Boolean getAttributeValueAsBoolean(@Nonnull Attr attribute) {
        String valueStr = StringSupport.trimOrNull(attribute.getValue());
        if ("0".equals(valueStr) || "false".equals(valueStr)) {
            return Boolean.FALSE;
        }
        if ("1".equals(valueStr) || "true".equals(valueStr)) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static List<String> getAttributeValueAsList(@Nonnull Attr attribute) {
        String value = StringSupport.trimOrNull(attribute.getTextContent());
        if (value != null) {
            return StringSupport.stringToList(value, " \n\r\t");
        }
        return CollectionSupport.emptyList();
    }

    @Nullable
    public static QName getAttributeValueAsQName(@Nonnull Attr attribute) {
        String attributeValue = StringSupport.trimOrNull(attribute.getTextContent());
        if (attributeValue == null) {
            return null;
        }
        String[] valueComponents = attributeValue.split(":");
        if (valueComponents.length == 1) {
            String localName = valueComponents[0];
            assert (localName != null);
            return QNameSupport.constructQName(attribute.lookupNamespaceURI(null), localName, null);
        }
        if (valueComponents.length > 2) {
            throw new IllegalStateException("Attribute value contained multiple colons");
        }
        String prefix = valueComponents[0];
        String localName = valueComponents[1];
        assert (localName != null);
        return QNameSupport.constructQName(attribute.lookupNamespaceURI(prefix), localName, prefix);
    }

    @Nullable
    public static Instant getDateTimeAttribute(@Nonnull Attr attribute) {
        String value = StringSupport.trimOrNull(attribute.getValue());
        return value != null ? DOMTypeSupport.stringToInstant(value) : null;
    }

    @Nullable
    public static Duration getDurationAttributeValue(@Nonnull Attr attribute) {
        String value = StringSupport.trimOrNull(attribute.getValue());
        return value != null ? DOMTypeSupport.stringToDuration(value) : null;
    }

    @Nullable
    public static Attr getIdAttribute(@Nonnull Element element) {
        if (!element.hasAttributes()) {
            return null;
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!attribute.isId()) continue;
            return attribute;
        }
        return null;
    }

    @Nullable
    public static String getXMLBase(@Nonnull Element element) {
        return AttributeSupport.getAttributeValue(element, XMLConstants.XML_BASE_ATTRIB_NAME);
    }

    @Nullable
    public static String getXMLId(@Nonnull Element element) {
        return AttributeSupport.getAttributeValue(element, XMLConstants.XML_ID_ATTRIB_NAME);
    }

    @Nullable
    public static String getXMLLang(@Nonnull Element element) {
        return AttributeSupport.getAttributeValue(element, XMLConstants.XML_LANG_ATTRIB_NAME);
    }

    @Nullable
    public static XMLSpace getXMLSpace(@Nullable Element element) {
        if (null == element) {
            return null;
        }
        String value = AttributeSupport.getAttributeValue(element, XMLConstants.XML_SPACE_ATTRIB_NAME);
        if (null == value) {
            return null;
        }
        try {
            return XMLSpace.parseValue(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static boolean hasAttribute(@Nonnull Element element, @Nonnull QName name) {
        return element.hasAttributeNS(StringSupport.trimOrNull(name.getNamespaceURI()), name.getLocalPart());
    }

    public static boolean removeAttribute(@Nonnull Element element, @Nonnull QName attributeName) {
        if (AttributeSupport.hasAttribute(element, attributeName)) {
            element.removeAttributeNS(StringSupport.trimOrNull(attributeName.getNamespaceURI()), attributeName.getLocalPart());
            return true;
        }
        return false;
    }
}

