/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.io.IOCallback;

public class ScheduledWrite {
    ActiveMQBuffer amqBuffer;
    ByteBuffer ioBuffer;
    final IOCallback callback;
    final boolean append;

    public ScheduledWrite(ActiveMQBuffer amqBuffer, IOCallback callback, boolean append) {
        this.amqBuffer = amqBuffer;
        this.ioBuffer = null;
        this.callback = callback;
        this.append = append;
    }

    public ScheduledWrite(ByteBuffer ioBuffer, IOCallback callback, boolean append) {
        this.ioBuffer = ioBuffer;
        this.amqBuffer = null;
        this.callback = callback;
        this.append = append;
    }

    public ScheduledWrite(IOCallback callback) {
        this.ioBuffer = null;
        this.amqBuffer = null;
        this.callback = callback;
        this.append = false;
    }

    public int readable() {
        if (this.ioBuffer != null) {
            return this.ioBuffer.remaining();
        }
        if (this.amqBuffer != null) {
            return this.amqBuffer.readableBytes();
        }
        return 0;
    }

    public int readAt(byte[] dst, int offset) {
        if (this.ioBuffer != null) {
            int size = this.ioBuffer.remaining();
            this.ioBuffer.get(dst, offset, size);
            return size;
        }
        if (this.amqBuffer != null) {
            int size = this.amqBuffer.readableBytes();
            this.amqBuffer.getBytes(0, dst, offset, size);
            return size;
        }
        return 0;
    }

    public void releaseBuffer() {
        this.amqBuffer = null;
        this.ioBuffer = null;
    }
}

