/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import org.ehcache.jsr107.CloseUtil;
import org.ehcache.jsr107.Eh107Expiry;
import org.ehcache.jsr107.ListenerResources;
import org.ehcache.jsr107.internal.Jsr107CacheLoaderWriter;

class CacheResources<K, V> {
    private final Eh107Expiry<K, V> expiryPolicy;
    private final Jsr107CacheLoaderWriter<? super K, V> cacheLoaderWriter;
    private final Map<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>> listenerResources = new ConcurrentHashMap<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final String cacheName;

    CacheResources(String cacheName, Jsr107CacheLoaderWriter<? super K, V> cacheLoaderWriter, Eh107Expiry<K, V> expiry, Map<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>> listenerResources) {
        this.cacheName = cacheName;
        this.cacheLoaderWriter = cacheLoaderWriter;
        this.expiryPolicy = expiry;
        this.listenerResources.putAll(listenerResources);
    }

    CacheResources(String cacheName, Jsr107CacheLoaderWriter<? super K, V> cacheLoaderWriter, Eh107Expiry<K, V> expiry) {
        this(cacheName, cacheLoaderWriter, expiry, new ConcurrentHashMap<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>>());
    }

    Eh107Expiry<K, V> getExpiryPolicy() {
        return this.expiryPolicy;
    }

    Jsr107CacheLoaderWriter<? super K, V> getCacheLoaderWriter() {
        return this.cacheLoaderWriter;
    }

    Map<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>> getListenerResources() {
        return Collections.unmodifiableMap(this.listenerResources);
    }

    synchronized ListenerResources<K, V> registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerConfig) {
        this.checkClosed();
        if (this.listenerResources.containsKey(listenerConfig)) {
            throw new IllegalArgumentException("listener config already registered");
        }
        ListenerResources<K, V> rv = ListenerResources.createListenerResources(listenerConfig);
        this.listenerResources.put(listenerConfig, rv);
        return rv;
    }

    private void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("cache resources closed for cache [" + this.cacheName + "]");
        }
    }

    synchronized ListenerResources<K, V> deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerConfig) {
        this.checkClosed();
        ListenerResources<K, V> resources = this.listenerResources.remove(listenerConfig);
        if (resources == null) {
            return null;
        }
        try {
            CloseUtil.closeAll(resources);
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
        return resources;
    }

    synchronized void closeResources() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                CloseUtil.closeAll(this.expiryPolicy, this.cacheLoaderWriter, this.listenerResources.values());
            }
            catch (Throwable t) {
                throw new CacheException(t);
            }
        }
    }

    synchronized CacheException closeResourcesAfter(CacheException exception) {
        if (this.closed.compareAndSet(false, true)) {
            return CloseUtil.closeAllAfter(exception, this.expiryPolicy, this.cacheLoaderWriter, this.listenerResources.values());
        }
        return exception;
    }
}

