/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.messages;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.server.i18n.I18n;

public final class HardwareAddress {
    private final short type;
    private final short length;
    private final byte[] address;
    private static final Pattern PARSE_PATTERN = Pattern.compile("(\\d+)/(?:(\\p{XDigit}{1,2}):)*(\\p{XDigit}{1,2})?");

    public HardwareAddress(short type, short length, byte[] address) {
        this.type = type;
        this.length = length;
        this.address = address;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public short getLength() {
        return this.length;
    }

    public short getType() {
        return this.type;
    }

    public int hashCode() {
        int hashCode = 0x5E12E4C ^ this.type ^ this.length;
        for (int i = 0; i < this.length; ++i) {
            hashCode ^= this.address[i];
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (null == obj || !obj.getClass().equals(HardwareAddress.class)) {
            return false;
        }
        HardwareAddress hw = (HardwareAddress)obj;
        return this.length == hw.length && this.type == hw.type && Arrays.equals(this.address, hw.address);
    }

    public String getNativeRepresentation() {
        StringBuilder sb = new StringBuilder();
        if (this.type == 1) {
            for (int i = 0; i < this.length; ++i) {
                String hex;
                if (i > 0) {
                    sb.append(":");
                }
                if ((hex = Integer.toHexString(this.address[i] & 0xFF)).length() < 2) {
                    sb.append('0');
                }
                sb.append(hex);
            }
        } else {
            sb.append(this.toString());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type);
        sb.append("/");
        for (int i = 0; i < this.length; ++i) {
            String hex;
            if (i > 0) {
                sb.append(":");
            }
            if ((hex = Integer.toHexString(this.address[i] & 0xFF)).length() < 2) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static HardwareAddress valueOf(String s) {
        if (null == s || s.length() == 0) {
            return null;
        }
        Matcher m = PARSE_PATTERN.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_637, s));
        }
        int type = Integer.parseInt(m.group(1));
        int len = m.groupCount() - 1;
        byte[] addr = new byte[len];
        for (int i = 0; i < addr.length; ++i) {
            addr[i] = (byte)Integer.parseInt(m.group(i + 2), 16);
        }
        return new HardwareAddress((short)type, (short)len, addr);
    }
}

