/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlForm;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.event.PhaseId;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.db.exceptions.FieldIllegalValueException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidValueException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.components.ControlTag;
import org.apache.empire.jsf2.components.InputTag;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.utils.StyleClass;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextInputControl
extends InputControl {
    private static final Logger log = LoggerFactory.getLogger(TextInputControl.class);
    public static final String NAME = "text";
    public static final String FORMAT_UNIT = "unit:";
    public static final String FORMAT_UNIT_ATTRIBUTE = "format:unit";
    public static final String DATE_FORMAT = "date-format:";
    public static final String DATE_FORMAT_ATTRIBUTE = "format:date";
    public static final String FRACTION_DIGITS = "fraction-digits:";
    private Class<? extends HtmlInputText> inputComponentClass;

    public TextInputControl(String name, Class<? extends HtmlInputText> inputComponentClass) {
        super(name);
        this.inputComponentClass = inputComponentClass;
    }

    public TextInputControl(String name) {
        this(name, HtmlInputText.class);
    }

    public TextInputControl() {
        this(NAME, HtmlInputText.class);
    }

    @Override
    protected void createInputComponents(UIComponent parent, InputControl.InputInfo ii, FacesContext context, List<UIComponent> compList) {
        String hint;
        if (!compList.isEmpty()) {
            throw new InvalidArgumentException("compList", compList);
        }
        HtmlInputText input = InputControlManager.createComponent(context, this.inputComponentClass);
        this.copyAttributes(parent, ii, (UIInput)input);
        input.setLang(ii.getLocale().getLanguage());
        int maxLength = this.getMaxInputLength(ii);
        if (maxLength > 0) {
            input.setMaxlength(maxLength);
        }
        compList.add((UIComponent)input);
        String unit = this.getUnitString(ii);
        if (StringUtils.isNotEmpty((String)unit) && !this.hasFormatOption(ii, "nounit")) {
            compList.add(this.createUnitLabel(TagStyleClass.UNIT.get(), ii, unit));
        }
        if (StringUtils.isNotEmpty((String)(hint = StringUtils.toString((Object)ii.getAttribute("hint")))) && !ii.isDisabled()) {
            compList.add(this.createUnitLabel(TagStyleClass.INPUT_HINT.get(), ii, hint));
        }
        this.updateInputState(compList, ii, context, PhaseId.RENDER_RESPONSE);
    }

    @Override
    protected void updateInputState(List<UIComponent> compList, InputControl.InputInfo ii, FacesContext context, PhaseId phaseId) {
        UIComponent comp = compList.get(0);
        if (!(comp instanceof HtmlInputText)) {
            throw new UnexpectedReturnValueException((Object)comp.getClass().getName(), "compList.get(0)");
        }
        HtmlInputText input = (HtmlInputText)comp;
        InputControl.DisabledType disabled = ii.getDisabled();
        input.setReadonly(disabled == InputControl.DisabledType.READONLY);
        input.setDisabled(disabled == InputControl.DisabledType.DISABLED);
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            this.setInputStyleClass((UIInput)input, ii);
            this.setInputValue((UIInput)input, ii);
        }
    }

    protected UIComponent createUnitLabel(String tagStyle, InputControl.InputInfo ii, String value) {
        HtmlOutputText text = new HtmlOutputText();
        text.setValue((Object)value);
        HtmlPanelGroup span = new HtmlPanelGroup();
        span.getAttributes().put("styleClass", tagStyle);
        span.getChildren().add(text);
        return span;
    }

    @Override
    protected void setInputStyleClass(UIInput input, StyleClass styleClass) {
        if (input instanceof HtmlInputText) {
            ((HtmlInputText)input).setStyleClass(styleClass.build());
        } else {
            super.setInputStyleClass(input, styleClass);
        }
    }

    @Override
    protected void setInputValueExpression(UIInput input, ValueExpression value, InputControl.InputInfo ii) {
        super.setInputValueExpression(input, value, ii);
        DataType dataType = ii.getColumn().getDataType();
        if (dataType.isNumeric()) {
            NumberFormat nf;
            if (dataType == DataType.INTEGER || dataType == DataType.AUTOINC) {
                nf = NumberFormat.getIntegerInstance(ii.getLocale());
            } else {
                nf = this.getNumberFormat(dataType, ii, ii.getColumn());
                if (nf instanceof DecimalFormat) {
                    ((DecimalFormat)nf).setParseBigDecimal(dataType == DataType.DECIMAL);
                }
            }
            input.setConverter((Converter)new NumberInputConverter(nf));
        }
    }

    @Override
    protected Object parseInputValue(String value, InputControl.InputInfo ii) {
        Column column;
        DataType type;
        if (!this.hasFormatOption(ii, "notrim")) {
            value = value.trim();
        }
        if ((type = (column = ii.getColumn()).getDataType()).isText()) {
            return value;
        }
        if (type == DataType.INTEGER) {
            NumberFormat nf = NumberFormat.getIntegerInstance(ii.getLocale());
            return this.parseNumber(value, nf);
        }
        if (type == DataType.DECIMAL || type == DataType.FLOAT) {
            NumberFormat nf = this.getNumberFormat(type, ii, column);
            if (nf instanceof DecimalFormat) {
                ((DecimalFormat)nf).setParseBigDecimal(type == DataType.DECIMAL);
            }
            return this.parseNumber(value, nf);
        }
        if (type == DataType.DATE || type == DataType.DATETIME || type == DataType.TIMESTAMP) {
            return this.parseDate(value, this.getDateFormat(column.getDataType(), ii, column));
        }
        if (type == DataType.BOOL) {
            return ObjectUtils.getBoolean((Object)value);
        }
        if (type == DataType.AUTOINC) {
            log.error("Autoinc-value cannot be changed.");
            return null;
        }
        return value;
    }

    @Override
    protected String formatValue(Object value, InputControl.ValueInfo vi) {
        String text;
        Options options = vi.getOptions();
        if (options != null && !this.hasFormatOption(vi, "nolookup") && (text = this.getOptionText(options, value, vi)) != null) {
            return text;
        }
        if (value == null) {
            Object nullValue = this.getFormatOption(vi, "null:", "format:null");
            if (nullValue != null) {
                return this.formatValue(nullValue, vi);
            }
            return "";
        }
        Column column = vi.getColumn();
        DataType dataType = this.getValueType(value, column != null ? column.getDataType() : DataType.UNKNOWN);
        if (dataType.isText() || dataType == DataType.UNKNOWN) {
            return String.valueOf(value);
        }
        if (dataType == DataType.INTEGER || dataType == DataType.AUTOINC) {
            NumberFormat nf = NumberFormat.getIntegerInstance(vi.getLocale());
            nf.setGroupingUsed(false);
            return nf.format(value);
        }
        if (dataType == DataType.DECIMAL || dataType == DataType.FLOAT) {
            NumberFormat nf = this.getNumberFormat(dataType, vi, column);
            return nf.format(value);
        }
        if (dataType == DataType.DATE || dataType == DataType.DATETIME || dataType == DataType.TIMESTAMP) {
            if (dataType != DataType.DATE && this.hasFormatOption(vi, "notime")) {
                dataType = DataType.DATE;
            }
            DateFormat df = this.getDateFormat(dataType, vi, column);
            return df.format(value);
        }
        return String.valueOf(value);
    }

    @Override
    protected Object formatInputValue(Object value, InputControl.InputInfo ii) {
        if (value == null) {
            return "";
        }
        Options options = ii.getOptions();
        if (options != null && !options.isEmpty()) {
            return value;
        }
        return this.formatValue(value, ii);
    }

    @Override
    public void renderValue(Object value, InputControl.ValueInfo vi, ResponseWriter writer) throws IOException {
        boolean escapeHtml = !this.hasFormatOption(vi, "noescape");
        String text = this.formatValue(value, vi, escapeHtml);
        if (StringUtils.isEmpty((String)text)) {
            writer.append((CharSequence)HTML_EXPR_NBSP);
            return;
        }
        super.renderValue(value, vi, writer);
        String unit = this.getUnitString(vi);
        if (StringUtils.isNotEmpty((String)unit) && !this.hasFormatOption(vi, "nounit")) {
            writer.append((CharSequence)" ");
            writer.append((CharSequence)unit);
        }
    }

    protected int getMaxInputLength(InputControl.InputInfo ii) {
        int ml;
        String maxlen = this.getFormatOption(ii, "maxlength:");
        if (StringUtils.isNotEmpty((String)maxlen) && (ml = ObjectUtils.getInteger((Object)maxlen)) > 0) {
            return ml;
        }
        Column col = ii.getColumn();
        DataType type = col.getDataType();
        if (type == DataType.CHAR || type == DataType.VARCHAR) {
            return (int)Math.round(col.getSize());
        }
        if (type == DataType.AUTOINC || type == DataType.INTEGER) {
            return 10;
        }
        if (type == DataType.FLOAT) {
            return 18;
        }
        if (type == DataType.DECIMAL) {
            Object minVal;
            Object groupSep;
            double size = col.getSize();
            int prec = (int)Math.round(size);
            if (prec == 0) {
                return 0;
            }
            int len = prec;
            int scale = (int)(size * 10.0) - prec * 10;
            if (scale > 0) {
                ++len;
            }
            if ((groupSep = col.getAttribute("numberGroupSeparator")) != null && ObjectUtils.getBoolean((Object)groupSep)) {
                len += (prec - scale - 1) / 3;
            }
            if ((minVal = col.getAttribute("minValue")) == null || ObjectUtils.getInteger((Object)minVal) < 0) {
                ++len;
            }
            return len;
        }
        if (type == DataType.BOOL) {
            return 1;
        }
        if (type == DataType.DATE) {
            return 10;
        }
        if (type == DataType.DATETIME || type == DataType.TIMESTAMP) {
            return 16;
        }
        if (type == DataType.CLOB) {
            return 0;
        }
        log.info("No max-length available for data type {}.", (Object)type);
        return 0;
    }

    protected DataType getValueType(Object value, DataType desiredType) {
        if (value instanceof String) {
            return DataType.VARCHAR;
        }
        if (value instanceof Number) {
            if (desiredType == DataType.AUTOINC || desiredType == DataType.INTEGER || desiredType == DataType.FLOAT || desiredType == DataType.DECIMAL) {
                return desiredType;
            }
            if (value instanceof Integer || value instanceof Long || value instanceof Short) {
                return DataType.INTEGER;
            }
            if (value instanceof Float || value instanceof Double) {
                return DataType.FLOAT;
            }
            return DataType.DECIMAL;
        }
        if (value instanceof Date) {
            if (desiredType == DataType.DATETIME || desiredType == DataType.DATE || desiredType == DataType.TIMESTAMP) {
                return desiredType;
            }
            if (value instanceof Timestamp) {
                return DataType.DATETIME;
            }
            return DataType.DATE;
        }
        if (value instanceof Boolean) {
            return DataType.BOOL;
        }
        return DataType.UNKNOWN;
    }

    protected NumberFormat getNumberFormat(DataType dataType, InputControl.ValueInfo vi, Column column) {
        int integerDigits;
        int maxFactionDigits;
        Object limitFractionDigits;
        Locale locale = vi.getLocale();
        if (column == null) {
            return NumberFormat.getNumberInstance(locale);
        }
        String type = StringUtils.valueOf((Object)column.getAttribute("numberType"));
        boolean isInteger = Column.NUMTYPE_INTEGER.equalsIgnoreCase(type);
        NumberFormat nf = isInteger ? NumberFormat.getIntegerInstance(locale) : NumberFormat.getNumberInstance(locale);
        Object groupSep = column.getAttribute("numberGroupSeparator");
        nf.setGroupingUsed(groupSep != null && ObjectUtils.getBoolean((Object)groupSep));
        Object object = limitFractionDigits = isInteger ? null : this.getFormatOption(vi, FRACTION_DIGITS, "numberFractionDigits");
        if (limitFractionDigits != null) {
            int minFactionDigits = 0;
            maxFactionDigits = -1;
            if (!(limitFractionDigits instanceof Number)) {
                String limit = limitFractionDigits.toString();
                if (limit.startsWith("min:")) {
                    minFactionDigits = ObjectUtils.getInteger((Object)limit.substring(4), (int)0);
                } else if (limit.startsWith("max:")) {
                    maxFactionDigits = ObjectUtils.getInteger((Object)limit.substring(4), (int)-1);
                } else if ("auto".equals(limitFractionDigits)) {
                    minFactionDigits = 999;
                } else if (!"limit".equals(limitFractionDigits)) {
                    minFactionDigits = maxFactionDigits = ObjectUtils.getInteger((Object)limit, (int)-1);
                }
            } else {
                minFactionDigits = maxFactionDigits = ((Number)limitFractionDigits).intValue();
            }
            if (minFactionDigits < 0) {
                minFactionDigits = 0;
            }
            if (maxFactionDigits < 0) {
                int length = (int)column.getSize();
                maxFactionDigits = (int)(column.getSize() * 10.0) - length * 10;
                if (minFactionDigits > maxFactionDigits) {
                    minFactionDigits = maxFactionDigits;
                }
            }
            nf.setMinimumFractionDigits(minFactionDigits);
            nf.setMaximumFractionDigits(maxFactionDigits);
        } else if (!isInteger && dataType == DataType.DECIMAL) {
            int length = (int)column.getSize();
            maxFactionDigits = (int)(column.getSize() * 10.0) - length * 10;
            nf.setMaximumFractionDigits(maxFactionDigits);
        }
        Object intDigits = column.getAttribute("numberIntegerDigits");
        if (intDigits != null && (integerDigits = ObjectUtils.getInteger((Object)intDigits)) > 0) {
            nf.setMinimumIntegerDigits(integerDigits);
        }
        return nf;
    }

    protected DateFormat getDateFormat(DataType dataType, InputControl.ValueInfo vi, Column column) {
        String pattern = null;
        int type = 2;
        String format = this.getFormatString(vi, DATE_FORMAT, DATE_FORMAT_ATTRIBUTE);
        if (format != null) {
            if (StringUtils.compareEqual((String)format, (String)"full", (boolean)true)) {
                type = 0;
            } else if (StringUtils.compareEqual((String)format, (String)"medium", (boolean)true)) {
                type = 2;
            } else if (StringUtils.compareEqual((String)format, (String)"short", (boolean)true)) {
                type = 3;
            } else if (StringUtils.compareEqual((String)format, (String)"long", (boolean)true)) {
                type = 1;
            } else {
                pattern = format;
            }
        }
        DateFormat df = StringUtils.isNotEmpty(pattern) ? new SimpleDateFormat(pattern, vi.getLocale()) : (dataType == DataType.DATE ? DateFormat.getDateInstance(type, vi.getLocale()) : DateFormat.getDateTimeInstance(type, type, vi.getLocale()));
        return df;
    }

    protected String getUnitString(InputControl.ValueInfo vi) {
        String numberType;
        String format = this.getFormatString(vi, FORMAT_UNIT, FORMAT_UNIT_ATTRIBUTE);
        if (format != null) {
            return format.length() > 0 ? vi.getTextResolver().resolveText(format) : null;
        }
        Column column = vi.getColumn();
        if (column != null && column.getDataType() == DataType.DECIMAL && (numberType = StringUtils.toString((Object)column.getAttribute("numberType"))) != null) {
            if ("CURRENCY".equalsIgnoreCase(numberType)) {
                String currencyCode = StringUtils.toString((Object)column.getAttribute("currencyCode"));
                if (currencyCode != null) {
                    if (currencyCode.equalsIgnoreCase("EUR")) {
                        return "\u20ac";
                    }
                    if (currencyCode.equalsIgnoreCase("USD")) {
                        return "$";
                    }
                    return currencyCode;
                }
            } else if ("PERCENT".equalsIgnoreCase(numberType)) {
                return "%";
            }
        }
        return null;
    }

    protected Object parseNumber(String value, NumberFormat nf) {
        try {
            Number number = nf.parse(value);
            if (number instanceof BigDecimal) {
                int scale = nf.getMaximumFractionDigits();
                number = ((BigDecimal)number).setScale(scale, RoundingMode.HALF_UP);
            }
            return number;
        }
        catch (ParseException pe) {
            throw new NumberFormatException("Not a number: " + value + " Exception: " + pe.toString());
        }
    }

    protected Object parseDate(String s, DateFormat df) {
        try {
            df.setLenient(true);
            return df.parseObject(s);
        }
        catch (ParseException pe) {
            throw new RuntimeException("Invalid date format: " + s, pe);
        }
    }

    public static class NumberInputConverter
    implements Converter,
    StateHolder {
        private NumberFormat nf;
        private boolean trans = false;

        public NumberInputConverter() {
            this.nf = null;
        }

        public NumberInputConverter(NumberFormat nf) {
            this.nf = nf;
        }

        public Object saveState(FacesContext context) {
            return this.nf;
        }

        public void restoreState(FacesContext context, Object state) {
            this.nf = (NumberFormat)state;
        }

        public boolean isTransient() {
            return this.trans;
        }

        public void setTransient(boolean newTransientValue) {
            this.trans = newTransientValue;
        }

        public String getAsString(FacesContext context, UIComponent component, Object value) {
            if (ObjectUtils.isEmpty((Object)value)) {
                return "";
            }
            if (!(value instanceof Number)) {
                log.error("getAsString: \"{}\" is not a number!", (Object)value.getClass().getName());
                return value.toString();
            }
            return this.nf != null ? this.nf.format(value) : value.toString();
        }

        public Object getAsObject(FacesContext context, UIComponent component, String value) {
            if (ObjectUtils.isEmpty((Object)value)) {
                return null;
            }
            try {
                if (this.nf == null) {
                    return new BigDecimal(value);
                }
                Number number = this.nf.parse(value);
                if (number instanceof BigDecimal) {
                    int scale = this.nf.getMaximumFractionDigits();
                    number = ((BigDecimal)number).setScale(scale, RoundingMode.HALF_UP);
                }
                return number;
            }
            catch (ParseException e) {
                UIComponent inputComp = component.getParent();
                while (inputComp != null) {
                    Object column;
                    if ((inputComp instanceof InputTag || inputComp instanceof ControlTag) && (column = inputComp.getAttributes().get("column")) instanceof Column) {
                        throw new FieldIllegalValueException((Column)column, value);
                    }
                    if (!((inputComp = inputComp.getParent()) instanceof HtmlForm)) continue;
                }
                throw new InvalidValueException((Object)value);
            }
        }
    }
}

