/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.sqlserver;

import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.DBView;
import org.apache.empire.dbms.DBMSHandlerBase;
import org.apache.empire.dbms.sqlserver.DBMSHandlerMSSQL;

public class MSSqlDDLGenerator
extends DBDDLGenerator<DBMSHandlerMSSQL> {
    public MSSqlDDLGenerator(DBMSHandlerMSSQL dbms) {
        super(dbms);
        this.initDataTypes(dbms);
        this.alterColumnPhrase = " ALTER COLUMN ";
    }

    protected void initDataTypes(DBMSHandlerMSSQL dbms) {
        this.DATATYPE_CHAR = "NCHAR";
        this.DATATYPE_VARCHAR = "NVARCHAR";
        this.DATATYPE_DATE = "DATE";
        this.DATATYPE_DATETIME = dbms.isUseDateTime2() ? "DATETIME2" : "DATETIME";
        this.DATATYPE_TIMESTAMP = dbms.isUseDateTime2() ? "DATETIME2" : "DATETIME";
        this.DATATYPE_CLOB = "NTEXT";
        this.DATATYPE_BLOB = "IMAGE";
        this.DATATYPE_UNIQUEID = "UNIQUEIDENTIFIER";
    }

    @Override
    protected boolean appendColumnDataType(DataType type, double size, DBTableColumn c, DBSQLBuilder sql) {
        switch (type) {
            case AUTOINC: {
                super.appendColumnDataType(type, size, c, sql);
                if (((DBMSHandlerMSSQL)this.dbms).isUseSequenceTable()) break;
                int minValue = ObjectUtils.getInteger(c.getAttribute("minValue"), 1);
                sql.append(" IDENTITY(");
                sql.append(String.valueOf(minValue));
                sql.append(", 1) NOT NULL");
                return false;
            }
            case VARCHAR: 
            case CHAR: {
                if (type == DataType.CHAR) {
                    sql.append(c.isSingleByteChars() ? this.DATATYPE_CHAR.substring(1) : this.DATATYPE_CHAR);
                } else {
                    sql.append(c.isSingleByteChars() ? this.DATATYPE_VARCHAR.substring(1) : this.DATATYPE_VARCHAR);
                }
                int len = Math.abs((int)size);
                if (len == 0) {
                    len = type == DataType.CHAR ? 1 : 100;
                }
                sql.append("(");
                sql.append(String.valueOf(len));
                sql.append(")");
                break;
            }
            case UNIQUEID: {
                sql.append(this.DATATYPE_UNIQUEID);
                if (!c.isAutoGenerated()) break;
                sql.append(" ROWGUIDCOL");
                break;
            }
            case BLOB: {
                sql.append(this.DATATYPE_BLOB);
                break;
            }
            default: {
                return super.appendColumnDataType(type, size, c, sql);
            }
        }
        return true;
    }

    @Override
    protected void createDatabase(DBDatabase db, DBSQLScript script) {
        String databaseName = ((DBMSHandlerMSSQL)this.dbms).getDatabaseName();
        if (StringUtils.isNotEmpty(databaseName)) {
            script.addStmt("USE master");
            script.addStmt("IF NOT EXISTS(SELECT * FROM sysdatabases WHERE name = '" + databaseName + "') CREATE DATABASE " + databaseName);
            script.addStmt("USE " + databaseName);
            script.addStmt("SET DATEFORMAT ymd");
            if (((DBMSHandlerMSSQL)this.dbms).isUseSequenceTable() && db.getTable(((DBMSHandlerMSSQL)this.dbms).getSequenceTableName()) == null) {
                new DBMSHandlerBase.DBSeqTable(((DBMSHandlerMSSQL)this.dbms).getSequenceTableName(), db);
            }
        }
        super.createDatabase(db, script);
    }

    @Override
    protected void appendIndexType(DBIndex index, DBSQLBuilder sql) {
        if (index.getType() == DBIndex.DBIndexType.FULLTEXT) {
            sql.append("FULLTEXT ");
            return;
        }
        super.appendIndexType(index, sql);
        if (index.getOptions() != null) {
            sql.append(index.getOptions());
            sql.append(" ");
        }
    }

    @Override
    protected void addCreateIndexStmt(DBIndex index, DBSQLBuilder sql, DBSQLScript script) {
        DBIndex.DBIndexType indexType = index.getType();
        if (indexType == DBIndex.DBIndexType.UNIQUE_ALLOW_NULL) {
            boolean first = true;
            for (DBColumn col : index.getColumns()) {
                if (col.isRequired()) continue;
                sql.append(first ? " WHERE " : " AND ");
                col.addSQL(sql, 1L);
                sql.append(" IS NOT NULL");
                first = false;
            }
        } else if (indexType == DBIndex.DBIndexType.FULLTEXT) {
            sql.replace(index.getName(), "");
            String options = index.getOptions();
            if (StringUtils.isNotEmpty(options)) {
                sql.append(" ");
                sql.append(options);
            } else {
                DBIndex pkIndex = index.getTable().getPrimaryKey();
                if (pkIndex != null) {
                    sql.append(" KEY INDEX ");
                    sql.append(pkIndex.getName());
                } else {
                    log.warn("name of KEY INDEX not supplied for FULLTEXT index.");
                }
            }
        }
        super.addCreateIndexStmt(index, sql, script);
    }

    @Override
    protected void addCreateViewStmt(DBView v, DBSQLBuilder sql, DBSQLScript script) {
        String stmt = sql.toString();
        stmt = StringUtils.replace(stmt, "CREATE VIEW", "CREATE OR ALTER VIEW");
        script.addStmt(stmt);
    }

    @Override
    public void getDDLScript(DBDDLGenerator.DDLActionType type, DBObject dbo, DBSQLScript script) {
        if (type == DBDDLGenerator.DDLActionType.DROP && dbo instanceof DBIndex && ((DBIndex)dbo).getType() == DBIndex.DBIndexType.FULLTEXT) {
            DBSQLBuilder sql = ((DBMSHandlerMSSQL)this.dbms).createSQLBuilder();
            sql.append("DROP FULLTEXT INDEX ON ");
            String schema = ((DBDatabase)dbo.getDatabase()).getSchema();
            if (StringUtils.isNotEmpty(schema)) {
                sql.append(schema);
                sql.append(".");
            }
            this.appendElementName(sql, ((DBIndex)dbo).getTable().getName());
            script.addStmt(sql);
        } else {
            super.getDDLScript(type, dbo, script);
        }
    }
}

