/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.kafka;

import java.util.List;
import org.apache.hop.beam.transforms.kafka.BeamProduce;
import org.apache.hop.beam.transforms.kafka.BeamProduceMeta;
import org.apache.hop.beam.transforms.kafka.ConfigOption;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BeamProduceDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = BeamProduce.class;
    private final BeamProduceMeta input;
    int middle;
    int margin;
    private TextVar wBootstrapServers;
    private TextVar wTopic;
    private TextVar wKeyField;
    private TextVar wMessageField;
    private TableView wConfigOptions;

    public BeamProduceDialog(Shell parent, IVariables variables, BeamProduceMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BeamProduceDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)this.margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlBootstrapServers = new Label((Composite)this.shell, 131072);
        wlBootstrapServers.setText(BaseMessages.getString(PKG, (String)"BeamProduceDialog.BootstrapServers", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBootstrapServers);
        FormData fdlBootstrapServers = new FormData();
        fdlBootstrapServers.left = new FormAttachment(0, 0);
        fdlBootstrapServers.top = new FormAttachment((Control)lastControl, this.margin);
        fdlBootstrapServers.right = new FormAttachment(this.middle, -this.margin);
        wlBootstrapServers.setLayoutData((Object)fdlBootstrapServers);
        this.wBootstrapServers = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wBootstrapServers);
        FormData fdBootstrapServers = new FormData();
        fdBootstrapServers.left = new FormAttachment(this.middle, 0);
        fdBootstrapServers.top = new FormAttachment((Control)wlBootstrapServers, 0, 0x1000000);
        fdBootstrapServers.right = new FormAttachment(100, 0);
        this.wBootstrapServers.setLayoutData((Object)fdBootstrapServers);
        lastControl = this.wBootstrapServers;
        Label wlTopic = new Label((Composite)this.shell, 131072);
        wlTopic.setText(BaseMessages.getString(PKG, (String)"BeamProduceDialog.Topic", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTopic);
        FormData fdlTopic = new FormData();
        fdlTopic.left = new FormAttachment(0, 0);
        fdlTopic.top = new FormAttachment((Control)lastControl, this.margin);
        fdlTopic.right = new FormAttachment(this.middle, -this.margin);
        wlTopic.setLayoutData((Object)fdlTopic);
        this.wTopic = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTopic);
        FormData fdTopic = new FormData();
        fdTopic.left = new FormAttachment(this.middle, 0);
        fdTopic.top = new FormAttachment((Control)wlTopic, 0, 0x1000000);
        fdTopic.right = new FormAttachment(100, 0);
        this.wTopic.setLayoutData((Object)fdTopic);
        lastControl = this.wTopic;
        Label wlKeyField = new Label((Composite)this.shell, 131072);
        wlKeyField.setText(BaseMessages.getString(PKG, (String)"BeamProduceDialog.KeyField", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKeyField);
        FormData fdlKeyField = new FormData();
        fdlKeyField.left = new FormAttachment(0, 0);
        fdlKeyField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlKeyField.right = new FormAttachment(this.middle, -this.margin);
        wlKeyField.setLayoutData((Object)fdlKeyField);
        this.wKeyField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wKeyField);
        FormData fdKeyField = new FormData();
        fdKeyField.left = new FormAttachment(this.middle, 0);
        fdKeyField.top = new FormAttachment((Control)wlKeyField, 0, 0x1000000);
        fdKeyField.right = new FormAttachment(100, 0);
        this.wKeyField.setLayoutData((Object)fdKeyField);
        lastControl = this.wKeyField;
        Label wlMessageField = new Label((Composite)this.shell, 131072);
        wlMessageField.setText(BaseMessages.getString(PKG, (String)"BeamProduceDialog.MessageField", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMessageField);
        FormData fdlMessageField = new FormData();
        fdlMessageField.left = new FormAttachment(0, 0);
        fdlMessageField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlMessageField.right = new FormAttachment(this.middle, -this.margin);
        wlMessageField.setLayoutData((Object)fdlMessageField);
        this.wMessageField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wMessageField);
        FormData fdMessageField = new FormData();
        fdMessageField.left = new FormAttachment(this.middle, 0);
        fdMessageField.top = new FormAttachment((Control)wlMessageField, 0, 0x1000000);
        fdMessageField.right = new FormAttachment(100, 0);
        this.wMessageField.setLayoutData((Object)fdMessageField);
        lastControl = this.wMessageField;
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamProduceDialog.ConfigOptions.Column.Parameter", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamProduceDialog.ConfigOptions.Column.Value", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamProduceDialog.ConfigOptions.Column.Type", (String[])new String[0]), 2, ConfigOption.Type.getTypeNames(), false)};
        columns[0].setUsingVariables(true);
        columns[1].setUsingVariables(true);
        this.wConfigOptions = new TableView(this.variables, (Composite)this.shell, 0, columns, this.input.getConfigOptions().size(), null, this.props);
        PropsUi.setLook((Widget)this.wConfigOptions);
        FormData fdConfigOptions = new FormData();
        fdConfigOptions.left = new FormAttachment(0, 0);
        fdConfigOptions.right = new FormAttachment(100, 0);
        fdConfigOptions.top = new FormAttachment((Control)lastControl, this.margin);
        fdConfigOptions.bottom = new FormAttachment((Control)this.wOk, -this.margin * 2);
        this.wConfigOptions.setLayoutData((Object)fdConfigOptions);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wBootstrapServers.setText(Const.NVL((String)this.input.getBootstrapServers(), (String)""));
        this.wTopic.setText(Const.NVL((String)this.input.getTopic(), (String)""));
        this.wKeyField.setText(Const.NVL((String)this.input.getKeyField(), (String)""));
        this.wMessageField.setText(Const.NVL((String)this.input.getMessageField(), (String)""));
        for (int i = 0; i < this.input.getConfigOptions().size(); ++i) {
            ConfigOption option = this.input.getConfigOptions().get(i);
            TableItem item = this.wConfigOptions.table.getItem(i);
            item.setText(1, Const.NVL((String)option.getParameter(), (String)""));
            item.setText(2, Const.NVL((String)option.getValue(), (String)""));
            item.setText(3, option.getType() != null ? option.getType().name() : "");
        }
        this.wConfigOptions.optimizeTableView();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(BeamProduceMeta in) {
        this.transformName = this.wTransformName.getText();
        in.setBootstrapServers(this.wBootstrapServers.getText());
        in.setTopic(this.wTopic.getText());
        in.setKeyField(this.wKeyField.getText());
        in.setMessageField(this.wMessageField.getText());
        in.getConfigOptions().clear();
        List nonEmptyItems = this.wConfigOptions.getNonEmptyItems();
        for (TableItem item : nonEmptyItems) {
            String parameter = item.getText(1);
            String value = item.getText(2);
            ConfigOption.Type type = ConfigOption.Type.getTypeFromName(item.getText(3));
            in.getConfigOptions().add(new ConfigOption(parameter, value, type));
        }
        this.input.setChanged();
    }
}

