/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.memgroupby;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.memgroupby.GAggregate;
import org.apache.hop.pipeline.transforms.memgroupby.GGroup;
import org.apache.hop.pipeline.transforms.memgroupby.MemoryGroupBy;
import org.apache.hop.pipeline.transforms.memgroupby.MemoryGroupByData;
import org.apache.hop.pipeline.transforms.memgroupby.beam.GroupByTransform;

@Transform(id="MemoryGroupBy", image="memorygroupby.svg", name="i18n::MemoryGroupBy.Name", description="i18n::MemoryGroupBy.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Statistics", keywords={"i18n::MemoryGroupByMeta.keyword"}, documentationUrl="/pipeline/transforms/memgroupby.html")
public class MemoryGroupByMeta
extends BaseTransformMeta<MemoryGroupBy, MemoryGroupByData>
implements IBeamPipelineTransformHandler {
    private static final Class<?> PKG = MemoryGroupByMeta.class;
    @HopMetadataProperty(groupKey="group", key="field")
    private List<GGroup> groups = new ArrayList<GGroup>();
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="AGGREGATES", injectionGroupDescription="MemoryGroupBy.Injection.AGGREGATES", injectionKey="AGGREGATEFIELD", injectionKeyDescription="MemoryGroupBy.Injection.AGGREGATEFIELD")
    private List<GAggregate> aggregates = new ArrayList<GAggregate>();
    @HopMetadataProperty(key="give_back_row", injectionKey="ALWAYSGIVINGBACKONEROW", injectionKeyDescription="MemoryGroupBy.Injection.ALWAYSGIVINGBACKONEROW")
    private boolean alwaysGivingBackOneRow;

    public MemoryGroupByMeta() {
    }

    public MemoryGroupByMeta(MemoryGroupByMeta meta) {
        this();
        for (GGroup group : meta.groups) {
            this.groups.add(new GGroup(group));
        }
        for (GAggregate aggregate : meta.aggregates) {
            this.aggregates.add(new GAggregate(aggregate));
        }
        this.alwaysGivingBackOneRow = meta.alwaysGivingBackOneRow;
    }

    public MemoryGroupByMeta clone() {
        return new MemoryGroupByMeta(this);
    }

    public void getFields(IRowMeta r, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        RowMeta fields = new RowMeta();
        for (GGroup group : this.groups) {
            IValueMeta valueMeta = r.searchValueMeta(group.getField());
            if (valueMeta == null) continue;
            valueMeta.setStorageType(0);
            fields.addValueMeta(valueMeta);
        }
        for (GAggregate aggregate : this.aggregates) {
            IValueMeta valueMeta;
            IValueMeta subj = r.searchValueMeta(aggregate.getSubject());
            if (subj == null && aggregate.getType() != GroupType.CountAny) continue;
            String valueName = aggregate.getField();
            int valueType = 0;
            int length = -1;
            int precision = -1;
            String mask = null;
            switch (aggregate.getType()) {
                case First: 
                case Last: 
                case FirstIncludingNull: 
                case LastIncludingNull: 
                case Minimum: 
                case Maximum: {
                    valueType = subj.getType();
                    mask = subj.getConversionMask();
                    break;
                }
                case CountDistinct: 
                case CountAll: 
                case CountAny: {
                    valueType = 5;
                    mask = "0";
                    break;
                }
                case Sum: 
                case Average: {
                    valueType = subj.isNumeric() ? subj.getType() : 1;
                    mask = subj.getConversionMask();
                    break;
                }
                case Median: 
                case Percentile: 
                case StandardDeviation: {
                    valueType = 1;
                    mask = subj.getConversionMask();
                    break;
                }
                case ConcatComma: 
                case ConcatString: 
                case ConcatDistinct: {
                    valueType = 2;
                    break;
                }
            }
            if (aggregate.getType() == GroupType.Sum && valueType != 5 && valueType != 1 && valueType != 6) {
                valueType = 1;
            }
            if (valueType == 0) continue;
            try {
                valueMeta = ValueMetaFactory.createValueMeta((String)valueName, (int)valueType);
            }
            catch (HopPluginException e) {
                this.log.logError(BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.Exception.UnknownValueMetaType", (String[])new String[0]), new Object[]{valueType, e});
                valueMeta = new ValueMetaNone(valueName);
            }
            valueMeta.setOrigin(origin);
            valueMeta.setLength(length, precision);
            if (mask != null) {
                valueMeta.setConversionMask(mask);
            }
            fields.addValueMeta(valueMeta);
        }
        r.clear();
        r.addRowMeta((IRowMeta)fields);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.CheckResult.ReceivingInfoOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean isInput() {
        return false;
    }

    public boolean isOutput() {
        return false;
    }

    public void handleTransform(ILogChannel log, IVariables variables, String runConfigurationName, IBeamPipelineEngineRunConfiguration runConfiguration, String dataSamplersJson, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input, String parentLogChannelId) throws HopException {
        MemoryGroupByMeta meta = new MemoryGroupByMeta();
        BeamHop.loadTransformMetadata((ITransformMeta)meta, (TransformMeta)transformMeta, (IHopMetadataProvider)metadataProvider, (PipelineMeta)pipelineMeta);
        String[] subjectFields = new String[meta.getAggregates().size()];
        String[] aggregateCodes = new String[meta.getAggregates().size()];
        for (int i = 0; i < meta.getAggregates().size(); ++i) {
            GAggregate aggregate = meta.getAggregates().get(i);
            aggregateCodes[i] = aggregate.getType().getCode();
            subjectFields[i] = aggregate.getSubject();
        }
        ArrayList groups = new ArrayList();
        meta.getGroups().forEach(group -> groups.add(group.getField()));
        GroupByTransform groupByTransform = new GroupByTransform(transformMeta.getName(), JsonRowMeta.toJson((IRowMeta)rowMeta), groups.toArray(new String[0]), subjectFields, aggregateCodes, new String[0]);
        PCollection transformPCollection = (PCollection)input.apply(transformMeta.getName(), (PTransform)groupByTransform);
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)transformPCollection);
        log.logBasic("Handled Group By (TRANSFORM) : " + transformMeta.getName() + ", gets data from " + previousTransforms.size() + " previous transform(s)");
    }

    public List<GGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<GGroup> groups) {
        this.groups = groups;
    }

    public List<GAggregate> getAggregates() {
        return this.aggregates;
    }

    public void setAggregates(List<GAggregate> aggregates) {
        this.aggregates = aggregates;
    }

    public boolean isAlwaysGivingBackOneRow() {
        return this.alwaysGivingBackOneRow;
    }

    public void setAlwaysGivingBackOneRow(boolean alwaysGivingBackOneRow) {
        this.alwaysGivingBackOneRow = alwaysGivingBackOneRow;
    }

    public boolean supportsMultiCopyExecution() {
        return false;
    }

    public static enum GroupType implements IEnumHasCode
    {
        None("-", "-"),
        Sum("SUM", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.SUM", (String[])new String[0])),
        Average("AVERAGE", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.AVERAGE", (String[])new String[0])),
        Median("MEDIAN", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.MEDIAN", (String[])new String[0])),
        Percentile("PERCENTILE", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.PERCENTILE", (String[])new String[0])),
        Minimum("MIN", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.MIN", (String[])new String[0])),
        Maximum("MAX", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.MAX", (String[])new String[0])),
        CountAll("COUNT_ALL", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.CONCAT_ALL", (String[])new String[0])),
        ConcatComma("CONCAT_COMMA", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.CONCAT_COMMA", (String[])new String[0])),
        First("FIRST", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.FIRST", (String[])new String[0])),
        Last("LAST", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.LAST", (String[])new String[0])),
        FirstIncludingNull("FIRST_INCL_NULL", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.FIRST_INCL_NULL", (String[])new String[0])),
        LastIncludingNull("LAST_INCL_NULL", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.LAST_INCL_NULL", (String[])new String[0])),
        StandardDeviation("STD_DEV", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.STANDARD_DEVIATION", (String[])new String[0])),
        ConcatString("CONCAT_STRING", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.CONCAT_STRING", (String[])new String[0])),
        CountDistinct("COUNT_DISTINCT", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.COUNT_DISTINCT", (String[])new String[0])),
        CountAny("COUNT_ANY", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.COUNT_ANY", (String[])new String[0])),
        ConcatDistinct("CONCAT_DISTINCT", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.CONCAT_DISTINCT", (String[])new String[0]));

        private String code;
        private String description;

        private GroupType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            String[] descriptions = new String[GroupType.values().length];
            for (int i = 0; i < GroupType.values().length; ++i) {
                descriptions[i] = GroupType.values()[i].getDescription();
            }
            return descriptions;
        }

        public static GroupType getTypeWithDescription(String description) {
            for (GroupType value : GroupType.values()) {
                if (!value.getDescription().equalsIgnoreCase(description)) continue;
                return value;
            }
            return None;
        }

        public static GroupType getTypeWithCode(String code) {
            for (GroupType value : GroupType.values()) {
                if (!value.getCode().equalsIgnoreCase(code)) continue;
                return value;
            }
            return None;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

