/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import java.io.IOException;

public class PacketKexDHReply {
    byte[] payload;
    byte[] hostKey;
    byte[] publicKey;
    byte[] signature;

    public PacketKexDHReply(byte[] payload, int off, int len) throws IOException {
        this.payload = new byte[len];
        System.arraycopy(payload, off, this.payload, 0, len);
        TypesReader tr = new TypesReader(payload, off, len);
        int packet_type = tr.readByte();
        if (packet_type != 31) {
            throw new IOException("This is not a SSH_MSG_KEXDH_REPLY! (" + packet_type + ")");
        }
        this.hostKey = tr.readByteString();
        this.publicKey = tr.readByteString();
        this.signature = tr.readByteString();
        if (tr.remain() != 0) {
            throw new IOException("PADDING IN SSH_MSG_KEXDH_REPLY!");
        }
    }

    public byte[] getF() {
        return this.publicKey;
    }

    public byte[] getHostKey() {
        return this.hostKey;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

