/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.examples;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WordCount {
    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        WordCountOptions options = (WordCountOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(WordCountOptions.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)p.apply("ReadLines", (PTransform)TextIO.read().from(options.getInputFile()))).apply((PTransform)new CountWords())).apply((PTransform)MapElements.via((SimpleFunction)new FormatAsTextFn()))).apply("WriteCounts", (PTransform)TextIO.write().to(options.getOutput()));
        p.run().waitUntilFinish();
    }

    public static interface WordCountOptions
    extends PipelineOptions {
        @Description(value="Path of the file to read from")
        @Default.String(value="gs://beam-samples/shakespeare/kinglear.txt")
        public @UnknownKeyFor @NonNull @Initialized String getInputFile();

        public void setInputFile(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Path of the file to write to")
        public @UnknownKeyFor @NonNull @Initialized String getOutput();

        public void setOutput(@UnknownKeyFor @NonNull @Initialized String var1);
    }

    public static class CountWords
    extends PTransform<PCollection<String>, PCollection<KV<String, Long>>> {
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> lines) {
            PCollection words = (PCollection)lines.apply((PTransform)ParDo.of((DoFn)new ExtractWordsFn()));
            return (PCollection)words.apply(Count.perElement());
        }
    }

    public static class FormatAsTextFn
    extends SimpleFunction<KV<String, Long>, String> {
        public @UnknownKeyFor @NonNull @Initialized String apply(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> input) {
            return (String)input.getKey() + ": " + input.getValue();
        }
    }

    static class ExtractWordsFn
    extends DoFn<String, String> {
        private final @UnknownKeyFor @NonNull @Initialized Counter emptyLines = Metrics.counter(ExtractWordsFn.class, (String)"emptyLines");

        ExtractWordsFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            String[] words;
            if (((String)c.element()).trim().isEmpty()) {
                this.emptyLines.inc();
            }
            for (String word : words = ((String)c.element()).split("[^\\p{L}]+")) {
                if (word.isEmpty()) continue;
                c.output((Object)word);
            }
        }
    }
}

