/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.jdbc.JdbcTypeMapping;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@Deprecated
public class JdbcConfig {
    private static final Logger log = LoggerFactory.getLogger(JdbcConfig.class);
    public static final String PROP_AUTO_COMMIT = "autoCommit";
    public static final String PROP_CREATE_DATABASE = "createDatabaseIfNotExist";
    public static final String PROP_CONTINUE_BATCH = "continueBatchOnError";
    public static final String PROP_DATABASE_TERM = "databaseTerm";
    public static final String PROP_DIALECT = "dialect";
    public static final String PROP_EXTERNAL_DATABASE = "externalDatabase";
    public static final String PROP_FETCH_SIZE = "fetchSize";
    public static final String PROP_LOCAL_FILE = "localFile";
    public static final String PROP_JDBC_COMPLIANT = "jdbcCompliant";
    public static final String PROP_NAMED_PARAM = "namedParameter";
    public static final String PROP_NULL_AS_DEFAULT = "nullAsDefault";
    public static final String PROP_TX_SUPPORT = "transactionSupport";
    public static final String PROP_TYPE_MAP = "typeMappings";
    public static final String PROP_WRAPPER_OBJ = "wrapperObject";
    static final String TERM_COMMENT = "comment";
    static final String TERM_DATABASE = "database";
    static final String TERM_TABLE = "table";
    static final String TERM_CATALOG = "catalog";
    static final String TERM_SCHEMA = "schema";
    private static final String BOOLEAN_FALSE = "false";
    private static final String BOOLEAN_TRUE = "true";
    private static final String DEFAULT_AUTO_COMMIT = "true";
    private static final String DEFAULT_CREATE_DATABASE = "false";
    private static final String DEFAULT_CONTINUE_BATCH = "false";
    private static final String DEFAULT_DATABASE_TERM = "catalog";
    private static final String DEFAULT_DIALECT = "";
    private static final String DEFAULT_EXTERNAL_DATABASE = "true";
    private static final String DEFAULT_FETCH_SIZE = "0";
    private static final String DEFAULT_LOCAL_FILE = "false";
    private static final String DEFAULT_JDBC_COMPLIANT = "true";
    private static final String DEFAULT_NAMED_PARAM = "false";
    private static final String DEFAULT_NULL_AS_DEFAULT = "0";
    private static final String DEFAULT_TX_SUPPORT = "false";
    private static final String DEFAULT_TYPE_MAP = "";
    private static final String DEFAULT_WRAPPER_OBJ = "false";
    private final Properties properties = new Properties();
    private final boolean autoCommit;
    private final boolean createDb;
    private final boolean continueBatch;
    private final int fetchSize;
    private final boolean localFile;
    private final boolean jdbcCompliant;
    private final String databaseTerm;
    private final JdbcTypeMapping dialect;
    private final boolean externalDatabase;
    private final boolean namedParameter;
    private final int nullAsDefault;
    private final boolean txSupport;
    private final Map<String, Class<?>> typeMap;
    private final boolean wrapperObject;

    static DriverPropertyInfo newDriverProperty(String name, String defaultValue, String description, String ... choices) {
        DriverPropertyInfo info = new DriverPropertyInfo(name, defaultValue);
        info.description = description;
        if (choices != null && choices.length > 0) {
            info.choices = choices;
        }
        return info;
    }

    public static List<DriverPropertyInfo> getDriverProperties() {
        return Collections.unmodifiableList(new ArrayList<DriverPropertyInfo>(Arrays.asList(JdbcConfig.newDriverProperty(PROP_AUTO_COMMIT, "true", "Whether to enable auto commit when connection is created.", new String[0]), JdbcConfig.newDriverProperty(PROP_CREATE_DATABASE, "false", "Whether to automatically create database when it does not exist.", "true", "false"), JdbcConfig.newDriverProperty(PROP_CONTINUE_BATCH, "false", "Whether to continue batch process when error occurred.", "true", "false"), JdbcConfig.newDriverProperty(PROP_FETCH_SIZE, "0", "Default fetch size, negative or zero means no preferred option.", new String[0]), JdbcConfig.newDriverProperty(PROP_LOCAL_FILE, "false", "Whether to use local file for INFILE/OUTFILE or not.", "true", "false"), JdbcConfig.newDriverProperty(PROP_JDBC_COMPLIANT, "true", "Whether to enable JDBC-compliant features like fake transaction and standard UPDATE and DELETE statements.", "true", "false"), JdbcConfig.newDriverProperty(PROP_DATABASE_TERM, "catalog", "Default JDBC term as synonymous to database.", "catalog", TERM_SCHEMA), JdbcConfig.newDriverProperty(PROP_DIALECT, "", "Dialect mainly for data type mapping, can be set to ansi or a full qualified class name implementing JdbcTypeMapping.", new String[0]), JdbcConfig.newDriverProperty(PROP_EXTERNAL_DATABASE, "true", "Whether to enable external database support or not.", "true", "false"), JdbcConfig.newDriverProperty(PROP_NAMED_PARAM, "false", "Whether to use named parameter(e.g. :ts(DateTime64(6)) or :value etc.) instead of standard JDBC question mark placeholder.", "true", "false"), JdbcConfig.newDriverProperty(PROP_NULL_AS_DEFAULT, "0", "Default approach to handle null value, sets to 0 or negative number to throw exception when target column is not nullable, 1 to disable the null-check, and 2 or higher to replace null to default value of corresponding data type.", new String[0]), JdbcConfig.newDriverProperty(PROP_TX_SUPPORT, "false", "Whether to enable transaction support or not.", "true", "false"), JdbcConfig.newDriverProperty(PROP_TYPE_MAP, "", "Default type mappings between ClickHouse data type and Java class. You can define multiple mappings using comma as separator.", new String[0]), JdbcConfig.newDriverProperty(PROP_WRAPPER_OBJ, "false", "Whether to return wrapper object like Array or Struct in ResultSet.getObject method.", "true", "false"))));
    }

    String removeAndGetPropertyValue(Properties props, String key) {
        if (props == null || props.isEmpty() || key == null || key.isEmpty()) {
            return null;
        }
        Object raw = props.remove(key);
        if (raw != null) {
            this.properties.put(key, raw);
            return raw.toString();
        }
        return null;
    }

    boolean extractBooleanValue(Properties props, String key, String defaultValue) {
        String value = this.removeAndGetPropertyValue(props, key);
        return Boolean.parseBoolean(value != null ? value : defaultValue);
    }

    int extractIntValue(Properties props, String key, String defaultValue) {
        String value = this.removeAndGetPropertyValue(props, key);
        return Integer.parseInt(value != null ? value : defaultValue);
    }

    JdbcTypeMapping extractDialectValue(Properties props, String key, String defaultValue) {
        JdbcTypeMapping mapper;
        String value = this.removeAndGetPropertyValue(props, key);
        if (value == null) {
            value = defaultValue;
        }
        if (ClickHouseChecker.isNullOrBlank(value)) {
            mapper = JdbcTypeMapping.getDefaultMapping();
        } else if ("ansi".equalsIgnoreCase(value)) {
            mapper = JdbcTypeMapping.getAnsiMapping();
        } else {
            try {
                Class<?> clazz = JdbcConfig.class.getClassLoader().loadClass(value);
                mapper = (JdbcTypeMapping)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                log.warn((Object)"Failed to load custom JDBC type mapping [%s], due to: %s", value, t.getMessage());
                mapper = JdbcTypeMapping.getDefaultMapping();
            }
        }
        return mapper;
    }

    String extractStringValue(Properties props, String key, String defaultValue) {
        String value = this.removeAndGetPropertyValue(props, key);
        return value != null ? value : defaultValue;
    }

    Map<String, Class<?>> extractTypeMapValue(Properties props, String key, String defaultValue) {
        String value = this.removeAndGetPropertyValue(props, key);
        if (value == null) {
            value = defaultValue;
        }
        if (ClickHouseChecker.isNullOrBlank(value)) {
            return Collections.emptyMap();
        }
        LinkedHashMap map = new LinkedHashMap();
        ClassLoader loader = JdbcConfig.class.getClassLoader();
        for (Map.Entry<String, String> e : ClickHouseOption.toKeyValuePairs(value).entrySet()) {
            Class<?> clazz = null;
            try {
                clazz = loader.loadClass(e.getValue());
            }
            catch (Throwable t) {
                log.warn((Object)"Failed to add mapping [%s]=[%s], due to: %s", e.getKey(), e.getValue(), t.getMessage());
            }
            if (clazz == null) continue;
            map.put(e.getKey(), clazz);
        }
        return Collections.unmodifiableMap(map);
    }

    public JdbcConfig() {
        this(null);
    }

    public JdbcConfig(Properties props) {
        this.autoCommit = this.extractBooleanValue(props, PROP_AUTO_COMMIT, "true");
        this.createDb = this.extractBooleanValue(props, PROP_CREATE_DATABASE, "false");
        this.continueBatch = this.extractBooleanValue(props, PROP_CONTINUE_BATCH, "false");
        this.databaseTerm = this.extractStringValue(props, PROP_DATABASE_TERM, "catalog");
        this.dialect = this.extractDialectValue(props, PROP_DIALECT, "");
        this.externalDatabase = this.extractBooleanValue(props, PROP_EXTERNAL_DATABASE, "true");
        this.fetchSize = this.extractIntValue(props, PROP_FETCH_SIZE, "0");
        this.localFile = this.extractBooleanValue(props, PROP_LOCAL_FILE, "false");
        this.jdbcCompliant = this.extractBooleanValue(props, PROP_JDBC_COMPLIANT, "true");
        this.namedParameter = this.extractBooleanValue(props, PROP_NAMED_PARAM, "false");
        this.nullAsDefault = this.extractIntValue(props, PROP_NULL_AS_DEFAULT, "0");
        this.txSupport = this.extractBooleanValue(props, PROP_TX_SUPPORT, "false");
        this.typeMap = this.extractTypeMapValue(props, PROP_TYPE_MAP, "");
        this.wrapperObject = this.extractBooleanValue(props, PROP_WRAPPER_OBJ, "false");
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public boolean isCreateDbIfNotExist() {
        return this.createDb;
    }

    public boolean isContinueBatchOnError() {
        return this.continueBatch;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean useLocalFile() {
        return this.localFile;
    }

    public String getDatabaseTerm() {
        return this.databaseTerm;
    }

    public boolean useCatalog() {
        return "catalog".equals(this.databaseTerm);
    }

    public boolean useSchema() {
        return TERM_SCHEMA.equals(this.databaseTerm);
    }

    public JdbcTypeMapping getDialect() {
        return this.dialect;
    }

    public boolean isExternalDatabaseSupported() {
        return this.externalDatabase;
    }

    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    public boolean isJdbcCompliant() {
        return this.jdbcCompliant;
    }

    public boolean isTransactionSupported() {
        return this.txSupport;
    }

    public int getNullAsDefault() {
        return this.nullAsDefault;
    }

    public boolean useNamedParameter() {
        return this.namedParameter;
    }

    public boolean useWrapperObject() {
        return this.wrapperObject;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        return props;
    }
}

