/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.HopLogLayout;
import org.apache.hop.core.logging.HopLoggingEvent;

public class LogChannelFileWriterBuffer {
    private HopLogLayout layout;
    private String logChannelId;
    private final List<HopLoggingEvent> buffer = Collections.synchronizedList(new LinkedList());

    public LogChannelFileWriterBuffer(String logChannelId) {
        this.logChannelId = logChannelId;
        this.layout = new HopLogLayout(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(HopLoggingEvent event) {
        List<HopLoggingEvent> list = this.buffer;
        synchronized (list) {
            this.buffer.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getBuffer() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        List<HopLoggingEvent> list = this.buffer;
        synchronized (list) {
            for (HopLoggingEvent event : this.buffer) {
                stringBuffer.append(this.layout.format(event)).append(Const.CR);
            }
            this.buffer.clear();
        }
        return stringBuffer;
    }

    public String getLogChannelId() {
        return this.logChannelId;
    }
}

