/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.util;

import io.github.spannm.jackcess.DataType;
import io.github.spannm.jackcess.Table;
import io.github.spannm.jackcess.impl.ColumnImpl;
import io.github.spannm.jackcess.impl.DatabaseImpl;
import io.github.spannm.jackcess.util.ColumnMatcher;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class SimpleColumnMatcher
implements ColumnMatcher {
    public static final SimpleColumnMatcher INSTANCE = new SimpleColumnMatcher();

    @Override
    public boolean matches(Table table, String columnName, Object value1, Object value2) {
        if (SimpleColumnMatcher.equals(value1, value2)) {
            return true;
        }
        if (value1 != null && value2 != null && value1.getClass() != value2.getClass()) {
            DataType dataType = table.getColumn(columnName).getType();
            try {
                DatabaseImpl db = (DatabaseImpl)table.getDatabase();
                Object internalV1 = ColumnImpl.toInternalValue(dataType, value1, db);
                Object internalV2 = ColumnImpl.toInternalValue(dataType, value2, db);
                return SimpleColumnMatcher.equals(internalV1, internalV2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean equals(Object o1, Object o2) {
        return Objects.equals(o1, o2) || o1 instanceof byte[] && o2 instanceof byte[] && Arrays.equals((byte[])o1, (byte[])o2);
    }
}

