/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.Trace;
import com.ibm.as400.data.SystemResourceFinder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

class ParseException
extends Exception {
    Vector m_messages = new Vector();

    ParseException() {
    }

    ParseException(String string) {
        super(string);
    }

    void addMessage(String string) {
        this.m_messages.addElement(string);
    }

    public void reportErrors() {
        this.reportErrors(new PrintWriter(System.err, true));
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    private void reportErrors(PrintWriter printWriter) {
        int n = this.m_messages.size();
        for (int i = 0; i < n; ++i) {
            String string;
            if (i == 0 && (string = (String)this.m_messages.elementAt(i)) != null && string.indexOf("java.io.FileNotFoundException") != -1 && string.indexOf(".dtd") != -1) {
                n = 1;
            }
            printWriter.println((String)this.m_messages.elementAt(i));
        }
        if (n == 1) {
            printWriter.println(SystemResourceFinder.format("ONE_PARSE_ERROR"));
        } else {
            printWriter.println(SystemResourceFinder.format("MANY_PARSE_ERRORS", new Object[]{new Integer(n)}));
        }
        if (printWriter.checkError()) {
            Trace.log(2, "Error when reporting errors to PrintWriter.");
            System.err.println(this.toString());
        }
    }

    public String getMessage() {
        StringWriter stringWriter = new StringWriter();
        this.reportErrors(new PrintWriter(stringWriter));
        String string = stringWriter.toString();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }
}

