/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TimePartitioning;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class TableDestination
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1L;
    private final @UnknownKeyFor @NonNull @Initialized String tableSpec;
    private final @Nullable @UnknownKeyFor @Initialized String tableDescription;
    private final @Nullable @UnknownKeyFor @Initialized String jsonTimePartitioning;
    private final @Nullable @UnknownKeyFor @Initialized String jsonClustering;

    public TableDestination(@UnknownKeyFor @NonNull @Initialized String tableSpec, @Nullable @UnknownKeyFor @Initialized String tableDescription) {
        this(tableSpec, tableDescription, (String)null, (String)null);
    }

    public TableDestination(@UnknownKeyFor @NonNull @Initialized TableReference tableReference, @Nullable @UnknownKeyFor @Initialized String tableDescription) {
        this(tableReference, tableDescription, (String)null, (String)null);
    }

    public TableDestination(@UnknownKeyFor @NonNull @Initialized TableReference tableReference, @Nullable @UnknownKeyFor @Initialized String tableDescription, @UnknownKeyFor @NonNull @Initialized TimePartitioning timePartitioning) {
        this(BigQueryHelpers.toTableSpec(tableReference), tableDescription, timePartitioning != null ? BigQueryHelpers.toJsonString(timePartitioning) : null, (String)null);
    }

    public TableDestination(@UnknownKeyFor @NonNull @Initialized String tableSpec, @Nullable @UnknownKeyFor @Initialized String tableDescription, @UnknownKeyFor @NonNull @Initialized TimePartitioning timePartitioning) {
        this(tableSpec, tableDescription, timePartitioning != null ? BigQueryHelpers.toJsonString(timePartitioning) : null, (String)null);
    }

    public TableDestination(@UnknownKeyFor @NonNull @Initialized String tableSpec, @Nullable @UnknownKeyFor @Initialized String tableDescription, @UnknownKeyFor @NonNull @Initialized TimePartitioning timePartitioning, @UnknownKeyFor @NonNull @Initialized Clustering clustering) {
        this(tableSpec, tableDescription, timePartitioning != null ? BigQueryHelpers.toJsonString(timePartitioning) : null, clustering != null ? BigQueryHelpers.toJsonString(clustering) : null);
    }

    public TableDestination(@UnknownKeyFor @NonNull @Initialized String tableSpec, @Nullable @UnknownKeyFor @Initialized String tableDescription, @Nullable @UnknownKeyFor @Initialized String jsonTimePartitioning) {
        this(tableSpec, tableDescription, jsonTimePartitioning, (String)null);
    }

    public TableDestination(@UnknownKeyFor @NonNull @Initialized TableReference tableReference, @Nullable @UnknownKeyFor @Initialized String tableDescription, @Nullable @UnknownKeyFor @Initialized String jsonTimePartitioning) {
        this(BigQueryHelpers.toTableSpec(tableReference), tableDescription, jsonTimePartitioning, (String)null);
    }

    public TableDestination(@UnknownKeyFor @NonNull @Initialized TableReference tableReference, @Nullable @UnknownKeyFor @Initialized String tableDescription, @Nullable @UnknownKeyFor @Initialized String jsonTimePartitioning, @Nullable @UnknownKeyFor @Initialized String jsonClustering) {
        this(BigQueryHelpers.toTableSpec(tableReference), tableDescription, jsonTimePartitioning, jsonClustering);
    }

    public TableDestination(@UnknownKeyFor @NonNull @Initialized String tableSpec, @Nullable @UnknownKeyFor @Initialized String tableDescription, @Nullable @UnknownKeyFor @Initialized String jsonTimePartitioning, @Nullable @UnknownKeyFor @Initialized String jsonClustering) {
        this.tableSpec = tableSpec;
        this.tableDescription = tableDescription;
        this.jsonTimePartitioning = jsonTimePartitioning;
        this.jsonClustering = jsonClustering;
    }

    public @UnknownKeyFor @NonNull @Initialized TableDestination withTableReference(@UnknownKeyFor @NonNull @Initialized TableReference tableReference) {
        return new TableDestination(tableReference, this.tableDescription, this.jsonTimePartitioning, this.jsonClustering);
    }

    public @UnknownKeyFor @NonNull @Initialized String getTableSpec() {
        return this.tableSpec;
    }

    public @UnknownKeyFor @NonNull @Initialized String getTableUrn(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bigQueryOptions) {
        TableReference table = this.getTableReference();
        if (Strings.isNullOrEmpty((String)table.getProjectId())) {
            table.setProjectId(bigQueryOptions.getBigQueryProject() == null ? bigQueryOptions.getProject() : bigQueryOptions.getBigQueryProject());
        }
        return String.format("projects/%s/datasets/%s/tables/%s", table.getProjectId(), table.getDatasetId(), table.getTableId());
    }

    public @UnknownKeyFor @NonNull @Initialized TableReference getTableReference() {
        return BigQueryHelpers.parseTableSpec(this.tableSpec);
    }

    public @Nullable @UnknownKeyFor @Initialized String getJsonTimePartitioning() {
        return this.jsonTimePartitioning;
    }

    public @Nullable @UnknownKeyFor @Initialized TimePartitioning getTimePartitioning() {
        if (this.jsonTimePartitioning == null) {
            return null;
        }
        return BigQueryHelpers.fromJsonString(this.jsonTimePartitioning, TimePartitioning.class);
    }

    public @Nullable @UnknownKeyFor @Initialized String getJsonClustering() {
        return this.jsonClustering;
    }

    public @Nullable @UnknownKeyFor @Initialized Clustering getClustering() {
        if (this.jsonClustering == null) {
            return null;
        }
        return BigQueryHelpers.fromJsonString(this.jsonClustering, Clustering.class);
    }

    public @Nullable @UnknownKeyFor @Initialized String getTableDescription() {
        return this.tableDescription;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        String toString = "tableSpec: " + this.tableSpec;
        if (this.tableDescription != null) {
            toString = toString + " tableDescription: " + this.tableDescription;
        }
        return toString;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (!(o instanceof TableDestination)) {
            return false;
        }
        TableDestination other = (TableDestination)o;
        return Objects.equals(this.tableSpec, other.tableSpec) && Objects.equals(this.tableDescription, other.tableDescription) && Objects.equals(this.jsonTimePartitioning, other.jsonTimePartitioning);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.tableSpec, this.tableDescription, this.jsonTimePartitioning);
    }
}

