/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionMode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionPosition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestriction;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PartitionRestrictionProgressChecker {
    protected @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Timestamp> timeSupplier = () -> Timestamp.now();

    @VisibleForTesting
    public void setTimeSupplier(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Timestamp> timeSupplier) {
        this.timeSupplier = timeSupplier;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress(@UnknownKeyFor @NonNull @Initialized PartitionRestriction restriction, @Nullable @UnknownKeyFor @Initialized PartitionPosition lastClaimedPosition) {
        BigDecimal totalWork = restriction.getEndTimestamp().compareTo(Timestamp.MAX_VALUE) == 0 ? BigDecimal.valueOf(this.timeSupplier.get().getSeconds()) : BigDecimal.valueOf(restriction.getEndTimestamp().getSeconds());
        PartitionMode currentMode = Optional.ofNullable(lastClaimedPosition).map(PartitionPosition::getMode).orElse(restriction.getMode());
        if (currentMode == PartitionMode.STOP) {
            double workCompleted = totalWork.doubleValue();
            double workRemaining = 1.0;
            return RestrictionTracker.Progress.from((double)workCompleted, (double)1.0);
        }
        long currentSecondsNum = Optional.ofNullable(lastClaimedPosition).flatMap(PartitionPosition::getTimestamp).map(Timestamp::getSeconds).orElse(currentMode == PartitionMode.UPDATE_STATE || currentMode == PartitionMode.QUERY_CHANGE_STREAM ? restriction.getStartTimestamp().getSeconds() : restriction.getEndTimestamp().getSeconds());
        BigDecimal workCompleted = BigDecimal.valueOf(currentSecondsNum);
        BigDecimal workRemaining = totalWork.subtract(workCompleted).max(BigDecimal.ONE);
        return RestrictionTracker.Progress.from((double)workCompleted.doubleValue(), (double)workRemaining.doubleValue());
    }
}

