/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.core.IBigtableDataClient;
import com.google.cloud.bigtable.core.IBulkMutation;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.cloud.bigtable.grpc.scanner.FlatRowConverter;
import com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.cloud.bigtable.util.ApiFutureUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi(value="For internal usage only - please use BigtableDataClient")
public class BigtableDataClientWrapper
implements IBigtableDataClient {
    private final BigtableDataClient delegate;
    private final RequestContext requestContext;

    public BigtableDataClientWrapper(BigtableDataClient bigtableDataClient, RequestContext requestContext) {
        this.delegate = bigtableDataClient;
        this.requestContext = requestContext;
    }

    @Override
    public void mutateRow(RowMutation rowMutation) {
        MutateRowRequest mutateRowRequest = rowMutation.toProto(this.requestContext);
        this.delegate.mutateRow(mutateRowRequest);
    }

    @Override
    public ApiFuture<Void> mutateRowAsync(RowMutation rowMutation) {
        ListenableFuture<MutateRowResponse> response = this.delegate.mutateRowAsync(rowMutation.toProto(this.requestContext));
        return ApiFutureUtil.transformAndAdapt(response, new Function<MutateRowResponse, Void>(){

            @Nullable
            public Void apply(@Nullable MutateRowResponse mutateRowResponse) {
                return null;
            }
        });
    }

    @Override
    public Row readModifyWriteRow(ReadModifyWriteRow readModifyWriteRow) {
        ReadModifyWriteRowResponse response = this.delegate.readModifyWriteRow(readModifyWriteRow.toProto(this.requestContext));
        return new DefaultRowAdapter().createRowFromProto(response.getRow());
    }

    @Override
    public ApiFuture<Row> readModifyWriteRowAsync(ReadModifyWriteRow readModifyWriteRow) {
        ListenableFuture<ReadModifyWriteRowResponse> response = this.delegate.readModifyWriteRowAsync(readModifyWriteRow.toProto(this.requestContext));
        return ApiFutureUtil.transformAndAdapt(response, new Function<ReadModifyWriteRowResponse, Row>(){

            public Row apply(ReadModifyWriteRowResponse response) {
                return new DefaultRowAdapter().createRowFromProto(response.getRow());
            }
        });
    }

    @Override
    public IBulkMutation createBulkMutationBatcher(String tableId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public ApiFuture<Boolean> checkAndMutateRowAsync(ConditionalRowMutation conditionalRowMutation) {
        CheckAndMutateRowRequest request = conditionalRowMutation.toProto(this.requestContext);
        ListenableFuture<CheckAndMutateRowResponse> response = this.delegate.checkAndMutateRowAsync(request);
        return ApiFutureUtil.transformAndAdapt(response, new Function<CheckAndMutateRowResponse, Boolean>(){

            public Boolean apply(CheckAndMutateRowResponse checkAndMutateRowResponse) {
                return checkAndMutateRowResponse.getPredicateMatched();
            }
        });
    }

    @Override
    public Boolean checkAndMutateRow(ConditionalRowMutation conditionalRowMutation) {
        CheckAndMutateRowResponse response = this.delegate.checkAndMutateRow(conditionalRowMutation.toProto(this.requestContext));
        return response.getPredicateMatched();
    }

    @Override
    public List<KeyOffset> sampleRowKeys(String tableId) {
        String fullTableName = NameUtil.formatTableName((String)this.requestContext.getProjectId(), (String)this.requestContext.getInstanceId(), (String)tableId);
        SampleRowKeysRequest requestProto = SampleRowKeysRequest.newBuilder().setTableName(fullTableName).build();
        List<SampleRowKeysResponse> responseProto = this.delegate.sampleRowKeys(requestProto);
        ImmutableList.Builder keyOffsetBuilder = ImmutableList.builderWithExpectedSize((int)responseProto.size());
        for (SampleRowKeysResponse rowKeys : responseProto) {
            keyOffsetBuilder.add((Object)KeyOffset.create((ByteString)rowKeys.getRowKey(), (long)rowKeys.getOffsetBytes()));
        }
        return keyOffsetBuilder.build();
    }

    @Override
    public ApiFuture<List<KeyOffset>> sampleRowKeysAsync(String tableId) {
        String fullTableName = NameUtil.formatTableName((String)this.requestContext.getProjectId(), (String)this.requestContext.getInstanceId(), (String)tableId);
        SampleRowKeysRequest requestProto = SampleRowKeysRequest.newBuilder().setTableName(fullTableName).build();
        ListenableFuture<List<SampleRowKeysResponse>> responseProto = this.delegate.sampleRowKeysAsync(requestProto);
        return ApiFutureUtil.transformAndAdapt(responseProto, new Function<List<SampleRowKeysResponse>, List<KeyOffset>>(){

            public List<KeyOffset> apply(@Nonnull List<SampleRowKeysResponse> rowKeysList) {
                if (rowKeysList == null || rowKeysList.isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
                ImmutableList.Builder keyOffsetBuilder = ImmutableList.builderWithExpectedSize((int)rowKeysList.size());
                for (SampleRowKeysResponse rowKeys : rowKeysList) {
                    keyOffsetBuilder.add((Object)KeyOffset.create((ByteString)rowKeys.getRowKey(), (long)rowKeys.getOffsetBytes()));
                }
                return keyOffsetBuilder.build();
            }
        });
    }

    @Override
    public ResultScanner<Row> readRows(Query request) {
        final ResultScanner<FlatRow> delegate = this.readFlatRows(request);
        return new ResultScanner<Row>(){

            @Override
            public Row next() throws IOException {
                return FlatRowConverter.convertToModelRow((FlatRow)delegate.next());
            }

            public Row[] next(int count) throws IOException {
                FlatRow[] flatRows = (FlatRow[])delegate.next(count);
                Row[] rows = new Row[flatRows.length];
                for (int i = 0; i < flatRows.length; ++i) {
                    rows[i] = FlatRowConverter.convertToModelRow(flatRows[i]);
                }
                return rows;
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }

            @Override
            public int available() {
                return delegate.available();
            }
        };
    }

    @Override
    public ApiFuture<List<Row>> readRowsAsync(Query request) {
        ListenableFuture<List<FlatRow>> responseProto = this.delegate.readFlatRowsAsync(request.toProto(this.requestContext));
        return ApiFutureUtil.transformAndAdapt(responseProto, new Function<List<FlatRow>, List<Row>>(){

            public List<Row> apply(List<FlatRow> flatRowList) {
                ImmutableList.Builder rowBuilder = ImmutableList.builderWithExpectedSize((int)flatRowList.size());
                for (FlatRow flatRow : flatRowList) {
                    rowBuilder.add((Object)FlatRowConverter.convertToModelRow(flatRow));
                }
                return rowBuilder.build();
            }
        });
    }

    @Override
    public List<FlatRow> readFlatRowsList(Query request) {
        return this.delegate.readFlatRowsList(request.toProto(this.requestContext));
    }

    @Override
    public ResultScanner<FlatRow> readFlatRows(Query request) {
        return this.delegate.readFlatRows(request.toProto(this.requestContext));
    }

    @Override
    public ApiFuture<List<FlatRow>> readFlatRowsAsync(Query request) {
        return ApiFutureUtil.adapt(this.delegate.readFlatRowsAsync(request.toProto(this.requestContext)));
    }

    @Override
    public void readFlatRowsAsync(Query request, StreamObserver<FlatRow> observer) {
        this.delegate.readFlatRows(request.toProto(this.requestContext), observer);
    }
}

