/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.AppProfile;
import com.google.bigtable.admin.v2.BigtableInstanceAdminGrpc;
import com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.admin.v2.CreateAppProfileRequest;
import com.google.bigtable.admin.v2.CreateClusterRequest;
import com.google.bigtable.admin.v2.CreateInstanceRequest;
import com.google.bigtable.admin.v2.DeleteAppProfileRequest;
import com.google.bigtable.admin.v2.DeleteClusterRequest;
import com.google.bigtable.admin.v2.DeleteInstanceRequest;
import com.google.bigtable.admin.v2.GetAppProfileRequest;
import com.google.bigtable.admin.v2.GetClusterRequest;
import com.google.bigtable.admin.v2.Instance;
import com.google.bigtable.admin.v2.ListAppProfilesRequest;
import com.google.bigtable.admin.v2.ListAppProfilesResponse;
import com.google.bigtable.admin.v2.ListClustersRequest;
import com.google.bigtable.admin.v2.ListClustersResponse;
import com.google.bigtable.admin.v2.ListInstancesRequest;
import com.google.bigtable.admin.v2.ListInstancesResponse;
import com.google.bigtable.admin.v2.PartialUpdateInstanceRequest;
import com.google.bigtable.admin.v2.UpdateAppProfileRequest;
import com.google.cloud.bigtable.grpc.BigtableInstanceClient;
import com.google.cloud.bigtable.util.OperationUtil;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsGrpc;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@InternalApi(value="For internal usage only")
public class BigtableInstanceGrpcClient
implements BigtableInstanceClient {
    private final BigtableInstanceAdminGrpc.BigtableInstanceAdminBlockingStub instanceClient;
    private final OperationUtil operationUtil;

    public BigtableInstanceGrpcClient(Channel channel) {
        this.instanceClient = BigtableInstanceAdminGrpc.newBlockingStub((Channel)channel);
        this.operationUtil = new OperationUtil(OperationsGrpc.newBlockingStub((Channel)channel));
    }

    @Override
    public Operation createInstance(CreateInstanceRequest request) {
        return this.instanceClient.createInstance(request);
    }

    @Override
    public Operation getOperation(GetOperationRequest request) {
        return this.operationUtil.getOperation(request);
    }

    @Override
    public void waitForOperation(Operation operation) throws IOException, TimeoutException {
        this.operationUtil.waitForOperation(operation, 10L, TimeUnit.MINUTES);
    }

    @Override
    public void waitForOperation(Operation operation, long timeout, TimeUnit timeUnit) throws TimeoutException, IOException {
        this.operationUtil.waitForOperation(operation, timeout, timeUnit);
    }

    @Override
    public ListInstancesResponse listInstances(ListInstancesRequest request) {
        return this.instanceClient.listInstances(request);
    }

    @Override
    public Instance updateInstance(Instance instance) {
        return this.instanceClient.updateInstance(instance);
    }

    @Override
    public Empty deleteInstance(DeleteInstanceRequest request) {
        return this.instanceClient.deleteInstance(request);
    }

    @Override
    public Cluster getCluster(GetClusterRequest request) {
        return this.instanceClient.getCluster(request);
    }

    @Override
    public ListClustersResponse listCluster(ListClustersRequest request) {
        return this.instanceClient.listClusters(request);
    }

    @Override
    public Operation updateCluster(Cluster cluster) {
        return this.instanceClient.updateCluster(cluster);
    }

    @Override
    public Empty deleteCluster(DeleteClusterRequest request) {
        return this.instanceClient.deleteCluster(request);
    }

    @Override
    public Operation partialUpdateInstance(PartialUpdateInstanceRequest request) {
        return this.instanceClient.partialUpdateInstance(request);
    }

    @Override
    public AppProfile createAppProfile(CreateAppProfileRequest request) {
        return this.instanceClient.createAppProfile(request);
    }

    @Override
    public AppProfile getAppProfile(GetAppProfileRequest request) {
        return this.instanceClient.getAppProfile(request);
    }

    @Override
    public ListAppProfilesResponse listAppProfiles(ListAppProfilesRequest request) {
        return this.instanceClient.listAppProfiles(request);
    }

    @Override
    public Operation updateAppProfile(UpdateAppProfileRequest request) {
        return this.instanceClient.updateAppProfile(request);
    }

    @Override
    public Empty deleteAppProfile(DeleteAppProfileRequest request) {
        return this.instanceClient.deleteAppProfile(request);
    }

    @Override
    public Policy getIamPolicy(GetIamPolicyRequest request) {
        return this.instanceClient.getIamPolicy(request);
    }

    @Override
    public Policy setIamPolicy(SetIamPolicyRequest request) {
        return this.instanceClient.setIamPolicy(request);
    }

    @Override
    public TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return this.instanceClient.testIamPermissions(request);
    }

    @Override
    public Operation createCluster(CreateClusterRequest request) {
        return this.instanceClient.createCluster(request);
    }
}

