/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class LengthPrefixCoder<@UnknownKeyFor T>
extends StructuredCoder<T> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder;

    public static <T> @UnknownKeyFor @NonNull @Initialized LengthPrefixCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        Preconditions.checkNotNull(valueCoder, (Object)"Coder not expected to be null");
        return new LengthPrefixCoder<T>(valueCoder);
    }

    private LengthPrefixCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        this.valueCoder = valueCoder;
    }

    @Override
    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.valueCoder.encode(value, bos, Coder.Context.OUTER);
        VarInt.encode(bos.size(), outStream);
        bos.writeTo(outStream);
    }

    @Override
    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        long size = VarInt.decodeLong(inStream);
        return this.valueCoder.decode(ByteStreams.limit((InputStream)inStream, (long)size), Coder.Context.OUTER);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return ImmutableList.of(this.valueCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getValueCoder() {
        return this.valueCoder;
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.valueCoder.verifyDeterministic();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return this.valueCoder.consistentWithEquals();
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(T value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.valueCoder instanceof StructuredCoder) {
            long valueSize = ((StructuredCoder)this.valueCoder).getEncodedElementByteSize(value);
            return (long)VarInt.getLength(valueSize) + valueSize;
        }
        return super.getEncodedElementByteSize(value);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(T value) {
        return this.valueCoder.isRegisterByteSizeObserverCheap(value);
    }
}

