/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.CompressedSource;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class ReadAllViaFileBasedSource<@UnknownKeyFor T>
extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<T>> {
    public static final @UnknownKeyFor @NonNull @Initialized boolean DEFAULT_USES_RESHUFFLE = true;
    private final @UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FileBasedSource<T>> createSource;
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
    private final @UnknownKeyFor @NonNull @Initialized ReadFileRangesFnExceptionHandler exceptionHandler;
    private final @UnknownKeyFor @NonNull @Initialized boolean usesReshuffle;

    public ReadAllViaFileBasedSource(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FileBasedSource<T>> createSource, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        this(desiredBundleSizeBytes, createSource, coder, true, new ReadFileRangesFnExceptionHandler());
    }

    public ReadAllViaFileBasedSource(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FileBasedSource<T>> createSource, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized boolean usesReshuffle, @UnknownKeyFor @NonNull @Initialized ReadFileRangesFnExceptionHandler exceptionHandler) {
        this.desiredBundleSizeBytes = desiredBundleSizeBytes;
        this.createSource = createSource;
        this.coder = coder;
        this.usesReshuffle = usesReshuffle;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection< @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile> input) {
        PCollection ranges = (PCollection)((Object)input.apply("Split into ranges", ParDo.of(new SplitIntoRangesFn(this.desiredBundleSizeBytes))));
        if (this.usesReshuffle) {
            ranges = (PCollection)ranges.apply("Reshuffle", Reshuffle.viaRandomKey());
        }
        return ((PCollection)ranges.apply("Read ranges", ParDo.of(new ReadFileRangesFn(this.createSource, this.exceptionHandler)))).setCoder(this.coder);
    }

    public static class ReadFileRangesFnExceptionHandler
    implements Serializable {
        public @UnknownKeyFor @NonNull @Initialized boolean apply( @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile file, @UnknownKeyFor @NonNull @Initialized OffsetRange range, @UnknownKeyFor @NonNull @Initialized Exception e) {
            return true;
        }
    }

    private static class ReadFileRangesFn<@UnknownKeyFor T>
    extends DoFn<KV<FileIO.ReadableFile, OffsetRange>, T> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FileBasedSource<T>> createSource;
        private final @UnknownKeyFor @NonNull @Initialized ReadFileRangesFnExceptionHandler exceptionHandler;

        private ReadFileRangesFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FileBasedSource<T>> createSource, @UnknownKeyFor @NonNull @Initialized ReadFileRangesFnExceptionHandler exceptionHandler) {
            this.createSource = createSource;
            this.exceptionHandler = exceptionHandler;
        }

        @DoFn.ProcessElement
        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
        public void process(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized IOException {
            block15: {
                FileIO.ReadableFile file = (FileIO.ReadableFile)((KV)c.element()).getKey();
                OffsetRange range = (OffsetRange)((KV)c.element()).getValue();
                CompressedSource<T> source = CompressedSource.from(this.createSource.apply(file.getMetadata().resourceId().toString())).withCompression(file.getCompression());
                try (BoundedSource.BoundedReader reader = ((FileBasedSource)source).createForSubrangeOfFile(file.getMetadata(), range.getFrom(), range.getTo()).createReader(c.getPipelineOptions());){
                    boolean more = reader.start();
                    while (more) {
                        c.output(reader.getCurrent());
                        more = reader.advance();
                    }
                }
                catch (RuntimeException e) {
                    if (!this.exceptionHandler.apply(file, range, e)) break block15;
                    throw e;
                }
            }
        }
    }

    private static class SplitIntoRangesFn
    extends DoFn<FileIO.ReadableFile, KV<FileIO.ReadableFile, OffsetRange>> {
        private final @UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes;

        private SplitIntoRangesFn(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes) {
            this.desiredBundleSizeBytes = desiredBundleSizeBytes;
        }

        @DoFn.ProcessElement
        public void process(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            MatchResult.Metadata metadata = ((FileIO.ReadableFile)c.element()).getMetadata();
            if (!metadata.isReadSeekEfficient()) {
                c.output(KV.of((FileIO.ReadableFile)c.element(), new OffsetRange(0L, metadata.sizeBytes())));
                return;
            }
            for (OffsetRange range : new OffsetRange(0L, metadata.sizeBytes()).split(this.desiredBundleSizeBytes, 0L)) {
                c.output(KV.of((FileIO.ReadableFile)c.element(), range));
            }
        }
    }
}

