/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.io.payloads;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.service.AutoService;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializerProvider;
import org.apache.beam.sdk.util.RowJson;
import org.apache.beam.sdk.util.RowJsonUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
@AutoService(value={PayloadSerializerProvider.class})
public class JsonPayloadSerializerProvider
implements PayloadSerializerProvider {
    @Override
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "json";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PayloadSerializer getSerializer(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> tableParams) {
        ObjectMapper deserializeMapper = RowJsonUtils.newObjectMapperWith(RowJson.RowJsonDeserializer.forSchema(schema));
        ObjectMapper serializeMapper = RowJsonUtils.newObjectMapperWith(RowJson.RowJsonSerializer.forSchema(schema));
        return PayloadSerializer.of(row -> RowJsonUtils.rowToJson(serializeMapper, row).getBytes(StandardCharsets.UTF_8), bytes -> RowJsonUtils.jsonToRow(deserializeMapper, new String((byte[])bytes, StandardCharsets.UTF_8)));
    }
}

