/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.FieldTypeDescriptors;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.transforms.AutoValue_SchemaAggregateFn_Inner;
import org.apache.beam.sdk.schemas.utils.RowSelector;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFns;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental(value=Experimental.Kind.SCHEMAS)
class SchemaAggregateFn {
    SchemaAggregateFn() {
    }

    static @UnknownKeyFor @NonNull @Initialized Inner create() {
        return new AutoValue_SchemaAggregateFn_Inner.Builder().setFieldAggregations(Lists.newArrayList()).build();
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    static abstract class Inner
    extends Combine.CombineFn<Row, Object[], Row> {
        Inner() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        abstract @Nullable @UnknownKeyFor @Initialized Schema getInputSchema();

        abstract @Nullable @UnknownKeyFor @Initialized Schema getOutputSchema();

        abstract @Nullable @UnknownKeyFor @Initialized CombineFns.ComposedCombineFn getComposedCombineFn();

        abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldAggregation> getFieldAggregations();

        @UnknownKeyFor @NonNull @Initialized Inner withSchema(@UnknownKeyFor @NonNull @Initialized Schema inputSchema) {
            List<FieldAggregation> fieldAggregations = this.getFieldAggregations().stream().map(f -> f.resolve(inputSchema)).collect(Collectors.toList());
            CombineFns.ComposedCombineFn<Row> composedCombineFn = null;
            for (int i = 0; i < fieldAggregations.size(); ++i) {
                Coder extractOutputCoder;
                SimpleFunction extractFunction;
                FieldAggregation fieldAggregation = (FieldAggregation)fieldAggregations.get(i);
                if (fieldAggregation.fieldsToAggregate.referencesSingleField()) {
                    extractFunction = new ExtractSingleFieldFunction(inputSchema, fieldAggregation.aggregateBaseValues, fieldAggregation);
                    Schema.FieldType fieldType = fieldAggregation.flattenedInputSubSchema.getField(0).getType();
                    if (fieldAggregation.aggregateBaseValues) {
                        while (fieldType.getTypeName().isLogicalType()) {
                            fieldType = fieldType.getLogicalType().getBaseType();
                        }
                    }
                    extractOutputCoder = SchemaCoder.coderForFieldType(fieldType);
                } else {
                    extractFunction = new ExtractFieldsFunction(inputSchema, fieldAggregation);
                    extractOutputCoder = SchemaCoder.of(fieldAggregation.inputSubSchema);
                }
                composedCombineFn = i == 0 ? CombineFns.compose().with(extractFunction, extractOutputCoder, fieldAggregation.fn, fieldAggregation.combineTag) : composedCombineFn.with(extractFunction, extractOutputCoder, fieldAggregation.fn, fieldAggregation.combineTag);
            }
            return this.toBuilder().setInputSchema(inputSchema).setComposedCombineFn(composedCombineFn).setFieldAggregations(fieldAggregations).build();
        }

        <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized Inner aggregateFields(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldsToAggregate, @UnknownKeyFor @NonNull @Initialized boolean aggregateBaseValues,  @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return this.aggregateFields(fieldsToAggregate, aggregateBaseValues, fn, Schema.Field.of(outputFieldName, FieldTypeDescriptors.fieldTypeForJavaType(fn.getOutputType())));
        }

        <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized Inner aggregateFields(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldsToAggregate, @UnknownKeyFor @NonNull @Initialized boolean aggregateBaseValues,  @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            List<FieldAggregation> fieldAggregations = this.getFieldAggregations();
            TupleTag<Object> combineTag = new TupleTag<Object>(Integer.toString(fieldAggregations.size()));
            FieldAggregation<CombineInputT, AccumT, CombineOutputT> fieldAggregation = new FieldAggregation<CombineInputT, AccumT, CombineOutputT>(fieldsToAggregate, aggregateBaseValues, outputField, fn, combineTag);
            fieldAggregations.add(fieldAggregation);
            return this.toBuilder().setOutputSchema(this.getOutputSchema(fieldAggregations)).setFieldAggregations(fieldAggregations).build();
        }

        private @UnknownKeyFor @NonNull @Initialized Schema getOutputSchema(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldAggregation> fieldAggregations) {
            Schema.Builder outputSchema = Schema.builder();
            for (FieldAggregation aggregation : fieldAggregations) {
                outputSchema.addField(aggregation.outputField);
            }
            return outputSchema.build();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] createAccumulator() {
            return this.getComposedCombineFn().createAccumulator();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] addInput(@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] accumulator, @UnknownKeyFor @NonNull @Initialized Row input) {
            return this.getComposedCombineFn().addInput(accumulator, input);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized []> accumulator) {
            return this.getComposedCombineFn().mergeAccumulators(accumulator);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized []> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Row> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            return this.getComposedCombineFn().getAccumulatorCoder(registry, inputCoder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Row> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Row> inputCoder) {
            return SchemaCoder.of(this.getOutputSchema());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Row extractOutput(@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] accumulator) {
            CombineFns.CoCombineResult coCombineResult = this.getComposedCombineFn().extractOutput(accumulator);
            Row.Builder output = Row.withSchema(this.getOutputSchema());
            for (FieldAggregation fieldAggregation : this.getFieldAggregations()) {
                Object aggregate = coCombineResult.get(fieldAggregation.combineTag);
                output.addValue(aggregate);
            }
            return output.build();
        }

        private static class ExtractFieldsFunction
        extends SimpleFunction<Row, Row> {
            private final @UnknownKeyFor @NonNull @Initialized RowSelector rowSelector;

            private ExtractFieldsFunction(@UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized FieldAggregation fieldAggregation) {
                this.rowSelector = new SelectHelpers.RowSelectorContainer(inputSchema, fieldAggregation.fieldsToAggregate, true);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Row apply(@UnknownKeyFor @NonNull @Initialized Row row) {
                return this.rowSelector.select(row);
            }
        }

        private static class ExtractSingleFieldFunction<@UnknownKeyFor OutputT>
        extends SimpleFunction<Row, OutputT> {
            private final @UnknownKeyFor @NonNull @Initialized RowSelector rowSelector;
            private final @UnknownKeyFor @NonNull @Initialized boolean extractBaseValue;
            private final @Nullable @UnknownKeyFor @Initialized RowSelector flatteningSelector;
            private final @UnknownKeyFor @NonNull @Initialized FieldAggregation fieldAggregation;

            private ExtractSingleFieldFunction(@UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized boolean extractBaseValue, @UnknownKeyFor @NonNull @Initialized FieldAggregation fieldAggregation) {
                this.rowSelector = new SelectHelpers.RowSelectorContainer(inputSchema, fieldAggregation.fieldsToAggregate, true);
                this.extractBaseValue = extractBaseValue;
                this.flatteningSelector = fieldAggregation.needsFlattening ? new SelectHelpers.RowSelectorContainer(fieldAggregation.inputSubSchema, fieldAggregation.flattenedFieldAccessDescriptor, true) : null;
                this.fieldAggregation = fieldAggregation;
            }

            @Override
            public OutputT apply(@UnknownKeyFor @NonNull @Initialized Row row) {
                Row selected = this.rowSelector.select(row);
                if (this.fieldAggregation.needsFlattening) {
                    selected = this.flatteningSelector.select(selected);
                }
                if (this.extractBaseValue && selected.getSchema().getField(0).getType().getTypeName().isLogicalType()) {
                    return (OutputT)selected.getBaseValue(0, Object.class);
                }
                return (OutputT)selected.getValue(0);
            }
        }

        @AutoValue.Builder
        @AutoValue.CopyAnnotations
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setInputSchema(@Nullable @UnknownKeyFor @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setOutputSchema(@Nullable @UnknownKeyFor @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setComposedCombineFn(@Nullable @UnknownKeyFor @Initialized CombineFns.ComposedCombineFn var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFieldAggregations(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldAggregation> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Inner build();
        }

        static class FieldAggregation<@UnknownKeyFor FieldT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
        implements Serializable {
            @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldsToAggregate;
            private final @UnknownKeyFor @NonNull @Initialized boolean aggregateBaseValues;
            private final @UnknownKeyFor @NonNull @Initialized Schema.Field outputField;
            private final  @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<FieldT, AccumT, OutputT> fn;
            private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Object> combineTag;
            private final @Nullable @UnknownKeyFor @Initialized Schema inputSubSchema;
            private final @Nullable @UnknownKeyFor @Initialized FieldAccessDescriptor flattenedFieldAccessDescriptor;
            private final @Nullable @UnknownKeyFor @Initialized Schema flattenedInputSubSchema;
            private final @UnknownKeyFor @NonNull @Initialized Schema aggregationSchema;
            private final @UnknownKeyFor @NonNull @Initialized boolean needsFlattening;

            FieldAggregation(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldsToAggregate, @UnknownKeyFor @NonNull @Initialized boolean aggregateBaseValues, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField,  @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<FieldT, AccumT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Object> combineTag) {
                this(fieldsToAggregate, aggregateBaseValues, outputField, fn, combineTag, Schema.builder().addField(outputField).build(), null);
            }

            FieldAggregation(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldsToAggregate, @UnknownKeyFor @NonNull @Initialized boolean aggregateBaseValues, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField,  @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<FieldT, AccumT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Object> combineTag, @UnknownKeyFor @NonNull @Initialized Schema aggregationSchema, @Nullable @UnknownKeyFor @Initialized Schema inputSchema) {
                this.aggregateBaseValues = aggregateBaseValues;
                if (inputSchema != null) {
                    this.fieldsToAggregate = fieldsToAggregate.resolve(inputSchema);
                    if (aggregateBaseValues) {
                        Preconditions.checkArgument((boolean)fieldsToAggregate.referencesSingleField());
                    }
                    this.inputSubSchema = SelectHelpers.getOutputSchema(inputSchema, this.fieldsToAggregate);
                    this.flattenedFieldAccessDescriptor = SelectHelpers.allLeavesDescriptor(this.inputSubSchema, SelectHelpers.CONCAT_FIELD_NAMES);
                    this.flattenedInputSubSchema = SelectHelpers.getOutputSchema(this.inputSubSchema, this.flattenedFieldAccessDescriptor);
                    this.needsFlattening = !inputSchema.equals(this.flattenedInputSubSchema);
                } else {
                    this.fieldsToAggregate = fieldsToAggregate;
                    this.inputSubSchema = null;
                    this.flattenedFieldAccessDescriptor = null;
                    this.flattenedInputSubSchema = null;
                    this.needsFlattening = false;
                }
                this.outputField = outputField;
                this.fn = fn;
                this.combineTag = combineTag;
                this.aggregationSchema = aggregationSchema;
            }

            @UnknownKeyFor @NonNull @Initialized FieldAggregation<FieldT, AccumT, OutputT> resolve(@UnknownKeyFor @NonNull @Initialized Schema schema) {
                return new FieldAggregation<FieldT, AccumT, OutputT>(this.fieldsToAggregate, this.aggregateBaseValues, this.outputField, this.fn, this.combineTag, this.aggregationSchema, schema);
            }
        }
    }
}

