/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class PValues {
    private PValues() {
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fullyExpand(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> partiallyExpanded) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<TupleTag<?>, PValue> pvalue : partiallyExpanded.entrySet()) {
            if (pvalue.getValue() instanceof PCollection) {
                PCollection previous = result.put(pvalue.getKey(), (PCollection)pvalue.getValue());
                if (previous == null) continue;
                throw new IllegalArgumentException(String.format("Found conflicting %ss in flattened expansion of %s: %s maps to %s and %s", partiallyExpanded, TupleTag.class.getSimpleName(), pvalue.getKey(), previous, pvalue.getValue()));
            }
            if (pvalue.getValue().expand().size() == 1 && ((PValue)Iterables.getOnlyElement(pvalue.getValue().expand().values())).equals(pvalue.getValue())) {
                throw new IllegalStateException(String.format("Non %s %s that expands into itself %s", PCollection.class.getSimpleName(), PValue.class.getSimpleName(), pvalue.getValue()));
            }
            for (Map.Entry<TupleTag<?>, PValue> valueComponent : pvalue.getValue().expand().entrySet()) {
                if (!(valueComponent.getValue() instanceof PCollection)) {
                    throw new IllegalStateException(String.format("A %s contained in %s expanded to a non-%s: %s", PValue.class.getSimpleName(), partiallyExpanded, PCollection.class.getSimpleName(), valueComponent.getValue()));
                }
                @Nullable PCollection previous = result.put(valueComponent.getKey(), (PCollection)valueComponent.getValue());
                if (previous == null) continue;
                throw new IllegalArgumentException(String.format("Found conflicting %ss in flattened expansion of %s: %s maps to %s and %s", partiallyExpanded, TupleTag.class.getSimpleName(), valueComponent.getKey(), previous, valueComponent.getValue()));
            }
        }
        return result;
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> expandOutput(@UnknownKeyFor @NonNull @Initialized POutput output) {
        return PValues.fullyExpand(output.expand());
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> expandInput(@UnknownKeyFor @NonNull @Initialized PInput input) {
        return PValues.fullyExpand(input.expand());
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> expandValue(@UnknownKeyFor @NonNull @Initialized PValue value) {
        return PValues.fullyExpand(value.expand());
    }
}

