/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.util.HashSet;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class UnconsumedReads {
    public static void ensureAllReadsConsumed(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        final HashSet unconsumed = new HashSet();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                unconsumed.removeAll(node.getInputs().values());
            }

            public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
                String urn = PTransformTranslation.urnForTransformOrNull(producer.getTransform());
                if ("beam:transform:read:v1".equals(urn)) {
                    unconsumed.add((PCollection)value);
                }
            }
        });
        int i = 0;
        for (PCollection unconsumedPCollection : unconsumed) {
            UnconsumedReads.consume(unconsumedPCollection, i);
            ++i;
        }
    }

    private static <T> void consume(@UnknownKeyFor @NonNull @Initialized PCollection<T> unconsumedPCollection, @UnknownKeyFor @NonNull @Initialized int uniq) {
        String uniqueName = "DropInputs" + (uniq == 0 ? "" : Integer.valueOf(uniq));
        unconsumedPCollection.apply(uniqueName, (PTransform)ParDo.of(new NoOpDoFn()));
    }

    private static class NoOpDoFn<@UnknownKeyFor T>
    extends DoFn<T, T> {
        private NoOpDoFn() {
        }

        @DoFn.ProcessElement
        public void doNothing(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
        }
    }
}

