/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.repackaged.direct_java.runners.core.InMemoryStateInternals;
import org.apache.beam.repackaged.direct_java.runners.core.StateInternals;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespace;
import org.apache.beam.repackaged.direct_java.runners.core.StateTable;
import org.apache.beam.repackaged.direct_java.runners.core.StateTag;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.MapState;
import org.apache.beam.sdk.state.MultimapState;
import org.apache.beam.sdk.state.OrderedListState;
import org.apache.beam.sdk.state.SetState;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.state.StateContexts;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.state.WatermarkHoldState;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.util.CombineFnUtil;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class CopyOnAccessInMemoryStateInternals<@UnknownKeyFor K>
implements StateInternals {
    private final @UnknownKeyFor @NonNull @Initialized CopyOnAccessInMemoryStateTable table;
    private K key;

    public static <K> @UnknownKeyFor @NonNull @Initialized CopyOnAccessInMemoryStateInternals withUnderlying(K key, @Nullable @UnknownKeyFor @Initialized CopyOnAccessInMemoryStateInternals underlying) {
        return new CopyOnAccessInMemoryStateInternals<K>(key, underlying);
    }

    private CopyOnAccessInMemoryStateInternals(K key, @UnknownKeyFor @NonNull @Initialized CopyOnAccessInMemoryStateInternals underlying) {
        this.key = key;
        this.table = new CopyOnAccessInMemoryStateTable(underlying == null ? null : underlying.table);
    }

    public @UnknownKeyFor @NonNull @Initialized CopyOnAccessInMemoryStateInternals commit() {
        this.table.commit();
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getEarliestWatermarkHold() {
        Preconditions.checkState((boolean)this.table.earliestWatermarkHold.isPresent(), (String)"Can't get the earliest watermark hold in a %s before it is committed", (Object)this.getClass().getSimpleName());
        return (Instant)this.table.earliestWatermarkHold.get();
    }

    @Override
    public <T extends State> T state(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized StateTag<T> address, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> c) {
        return this.table.get(namespace, address, c);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object getKey() {
        return this.key;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return Iterables.isEmpty(this.table.values());
    }

    private static class CopyOnAccessInMemoryStateTable
    extends StateTable {
        private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized StateTable> underlying;
        private @UnknownKeyFor @NonNull @Initialized StateBinderFactory binderFactory;
        private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Instant> earliestWatermarkHold;

        public CopyOnAccessInMemoryStateTable(@UnknownKeyFor @NonNull @Initialized StateTable underlying) {
            this.underlying = Optional.ofNullable(underlying);
            this.binderFactory = new CopyOnBindBinderFactory(this.underlying);
            this.earliestWatermarkHold = Optional.empty();
        }

        private void commit() {
            Instant earliestHold = this.getEarliestWatermarkHold();
            if (this.underlying.isPresent()) {
                ReadThroughBinderFactory readThroughBinder;
                this.binderFactory = readThroughBinder = new ReadThroughBinderFactory(this.underlying.get());
                Instant earliestUnderlyingHold = readThroughBinder.readThroughAndGetEarliestHold(this);
                if (earliestUnderlyingHold.isBefore((ReadableInstant)earliestHold)) {
                    earliestHold = earliestUnderlyingHold;
                }
            }
            this.earliestWatermarkHold = Optional.of(earliestHold);
            this.clearEmpty();
            this.binderFactory = new InMemoryStateBinderFactory();
            this.underlying = Optional.empty();
        }

        private @UnknownKeyFor @NonNull @Initialized Instant getEarliestWatermarkHold() {
            Instant earliest = BoundedWindow.TIMESTAMP_MAX_VALUE;
            for (State existingState : this.values()) {
                Instant hold;
                if (!(existingState instanceof WatermarkHoldState) || (hold = (Instant)((WatermarkHoldState)existingState).read()) == null || !hold.isBefore((ReadableInstant)earliest)) continue;
                earliest = hold;
            }
            return earliest;
        }

        private void clearEmpty() {
            HashSet<StateNamespace> emptyNamespaces = new HashSet<StateNamespace>(this.getNamespacesInUse());
            block0: for (StateNamespace namespace : this.getNamespacesInUse()) {
                for (State existingState : this.getTagsInUse(namespace).values()) {
                    if (((InMemoryStateInternals.InMemoryState)existingState).isCleared()) continue;
                    emptyNamespaces.remove(namespace);
                    continue block0;
                }
            }
            for (StateNamespace empty : emptyNamespaces) {
                this.clearNamespace(empty);
            }
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized StateTag.StateBinder binderForNamespace(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> c) {
            return this.binderFactory.forNamespace(namespace, c);
        }

        private static class InMemoryStateBinderFactory
        implements StateBinderFactory {
            @Override
            public @UnknownKeyFor @NonNull @Initialized StateTag.StateBinder forNamespace(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> c) {
                return new InMemoryStateInternals.InMemoryStateBinder(c);
            }
        }

        private static class ReadThroughBinderFactory<@UnknownKeyFor K>
        implements StateBinderFactory {
            private final @UnknownKeyFor @NonNull @Initialized StateTable underlying;

            public ReadThroughBinderFactory(@UnknownKeyFor @NonNull @Initialized StateTable underlying) {
                this.underlying = underlying;
            }

            public @UnknownKeyFor @NonNull @Initialized Instant readThroughAndGetEarliestHold(@UnknownKeyFor @NonNull @Initialized StateTable readTo) {
                Instant earliestHold = BoundedWindow.TIMESTAMP_MAX_VALUE;
                for (StateNamespace namespace : this.underlying.getNamespacesInUse()) {
                    for (Map.Entry<StateTag, State> existingState : this.underlying.getTagsInUse(namespace).entrySet()) {
                        Instant hold;
                        Object state;
                        if (((InMemoryStateInternals.InMemoryState)existingState.getValue()).isCleared() || !((state = readTo.get(namespace, existingState.getKey(), StateContexts.nullContext())) instanceof WatermarkHoldState) || (hold = (Instant)((WatermarkHoldState)state).read()) == null || !hold.isBefore((ReadableInstant)earliestHold)) continue;
                        earliestHold = hold;
                    }
                }
                return earliestHold;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized StateTag.StateBinder forNamespace(final @UnknownKeyFor @NonNull @Initialized StateNamespace namespace, final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> c) {
                return new StateTag.StateBinder(){

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized WatermarkHoldState bindWatermark(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized WatermarkHoldState> address, @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
                        return underlying.get(namespace, address, c);
                    }

                    @Override
                    public <T> @UnknownKeyFor @NonNull @Initialized ValueState<T> bindValue(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized ValueState<T>> address, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
                        return underlying.get(namespace, address, c);
                    }

                    @Override
                    public <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bindCombiningValue(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> address, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder, // Could not load outer class - annotation placement on inner may be incorrect
                     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
                        return underlying.get(namespace, address, c);
                    }

                    @Override
                    public <T> @UnknownKeyFor @NonNull @Initialized BagState<T> bindBag(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized BagState<T>> address, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
                        return underlying.get(namespace, address, c);
                    }

                    @Override
                    public <T> @UnknownKeyFor @NonNull @Initialized SetState<T> bindSet(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized SetState<T>> address, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
                        return underlying.get(namespace, address, c);
                    }

                    @Override
                    public <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized MapState<KeyT, ValueT> bindMap(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized MapState<KeyT, ValueT>> address, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> mapKeyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> mapValueCoder) {
                        return underlying.get(namespace, address, c);
                    }

                    @Override
                    public <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized MultimapState<KeyT, ValueT> bindMultimap(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized MultimapState<KeyT, ValueT>> address, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> valueCoder) {
                        return underlying.get(namespace, address, c);
                    }

                    @Override
                    public <T> @UnknownKeyFor @NonNull @Initialized OrderedListState<T> bindOrderedList(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized OrderedListState<T>> address, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
                        return underlying.get(namespace, address, c);
                    }

                    @Override
                    public <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bindCombiningValueWithContext(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> address, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder, // Could not load outer class - annotation placement on inner may be incorrect
                     @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
                        return this.bindCombiningValue(address, accumCoder, CombineFnUtil.bindContext(combineFn, (StateContext)c));
                    }
                };
            }
        }

        private static class CopyOnBindBinderFactory
        implements StateBinderFactory {
            private final @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized StateTable> underlying;

            public CopyOnBindBinderFactory(@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized StateTable> underlying) {
                this.underlying = underlying;
            }

            private @UnknownKeyFor @NonNull @Initialized boolean containedInUnderlying(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> tag) {
                return this.underlying.isPresent() && this.underlying.get().isNamespaceInUse(namespace) && this.underlying.get().getTagsInUse(namespace).containsKey(tag);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized StateTag.StateBinder forNamespace(final @UnknownKeyFor @NonNull @Initialized StateNamespace namespace, final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> c) {
                return new StateTag.StateBinder(){

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized WatermarkHoldState bindWatermark(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized WatermarkHoldState> address, @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
                        if (this.containedInUnderlying(namespace, address)) {
                            InMemoryStateInternals.InMemoryState existingState = (InMemoryStateInternals.InMemoryState)((StateTable)underlying.get()).get(namespace, address, c);
                            return (WatermarkHoldState)existingState.copy();
                        }
                        return new InMemoryStateInternals.InMemoryWatermarkHold(timestampCombiner);
                    }

                    @Override
                    public <T> @UnknownKeyFor @NonNull @Initialized ValueState<T> bindValue(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized ValueState<T>> address, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
                        if (this.containedInUnderlying(namespace, address)) {
                            InMemoryStateInternals.InMemoryState existingState = (InMemoryStateInternals.InMemoryState)((StateTable)underlying.get()).get(namespace, address, c);
                            return (ValueState)existingState.copy();
                        }
                        return new InMemoryStateInternals.InMemoryValue<T>(coder);
                    }

                    @Override
                    public <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bindCombiningValue(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> address, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder, // Could not load outer class - annotation placement on inner may be incorrect
                     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
                        if (this.containedInUnderlying(namespace, address)) {
                            InMemoryStateInternals.InMemoryState existingState = (InMemoryStateInternals.InMemoryState)((StateTable)underlying.get()).get(namespace, address, c);
                            return (CombiningState)existingState.copy();
                        }
                        return new InMemoryStateInternals.InMemoryCombiningState<InputT, AccumT, OutputT>(combineFn, accumCoder);
                    }

                    @Override
                    public <T> @UnknownKeyFor @NonNull @Initialized BagState<T> bindBag(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized BagState<T>> address, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
                        if (this.containedInUnderlying(namespace, address)) {
                            InMemoryStateInternals.InMemoryState existingState = (InMemoryStateInternals.InMemoryState)((StateTable)underlying.get()).get(namespace, address, c);
                            return (BagState)existingState.copy();
                        }
                        return new InMemoryStateInternals.InMemoryBag<T>(elemCoder);
                    }

                    @Override
                    public <T> @UnknownKeyFor @NonNull @Initialized SetState<T> bindSet(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized SetState<T>> address, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
                        if (this.containedInUnderlying(namespace, address)) {
                            InMemoryStateInternals.InMemoryState existingState = (InMemoryStateInternals.InMemoryState)((StateTable)underlying.get()).get(namespace, address, c);
                            return (SetState)existingState.copy();
                        }
                        return new InMemoryStateInternals.InMemorySet<T>(elemCoder);
                    }

                    @Override
                    public <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized MapState<KeyT, ValueT> bindMap(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized MapState<KeyT, ValueT>> address, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> mapKeyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> mapValueCoder) {
                        if (this.containedInUnderlying(namespace, address)) {
                            InMemoryStateInternals.InMemoryState existingState = (InMemoryStateInternals.InMemoryState)((StateTable)underlying.get()).get(namespace, address, c);
                            return (MapState)existingState.copy();
                        }
                        return new InMemoryStateInternals.InMemoryMap<KeyT, ValueT>(mapKeyCoder, mapValueCoder);
                    }

                    @Override
                    public <T> @UnknownKeyFor @NonNull @Initialized OrderedListState<T> bindOrderedList(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized OrderedListState<T>> address, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
                        if (this.containedInUnderlying(namespace, address)) {
                            InMemoryStateInternals.InMemoryState existingState = (InMemoryStateInternals.InMemoryState)((StateTable)underlying.get()).get(namespace, address, c);
                            return (OrderedListState)existingState.copy();
                        }
                        return new InMemoryStateInternals.InMemoryOrderedList<T>(elemCoder);
                    }

                    @Override
                    public <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized MultimapState<KeyT, ValueT> bindMultimap(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized MultimapState<KeyT, ValueT>> address, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> valueCoder) {
                        if (this.containedInUnderlying(namespace, address)) {
                            InMemoryStateInternals.InMemoryState existingState = (InMemoryStateInternals.InMemoryState)((StateTable)underlying.get()).get(namespace, address, c);
                            return (MultimapState)existingState.copy();
                        }
                        return new InMemoryStateInternals.InMemoryMultimap<KeyT, ValueT>(keyCoder, valueCoder);
                    }

                    @Override
                    public <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bindCombiningValueWithContext(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> address, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder, // Could not load outer class - annotation placement on inner may be incorrect
                     @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
                        return this.bindCombiningValue(address, accumCoder, CombineFnUtil.bindContext(combineFn, (StateContext)c));
                    }
                };
            }
        }

        private static interface StateBinderFactory {
            public @UnknownKeyFor @NonNull @Initialized StateTag.StateBinder forNamespace(@UnknownKeyFor @NonNull @Initialized StateNamespace var1, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> var2);
        }
    }
}

