/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.udf;

import java.util.List;
import org.apache.flink.api.common.distributions.CommonRangeBoundaries;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;

public class AssignRangeIndex<IN>
extends RichMapPartitionFunction<IN, Tuple2<Integer, IN>> {
    private TypeComparatorFactory<IN> typeComparator;

    public AssignRangeIndex(TypeComparatorFactory<IN> typeComparator) {
        this.typeComparator = typeComparator;
    }

    public void mapPartition(Iterable<IN> values, Collector<Tuple2<Integer, IN>> out) throws Exception {
        List broadcastVariable = this.getRuntimeContext().getBroadcastVariable("RangeBoundaries");
        if (broadcastVariable == null || broadcastVariable.size() != 1) {
            throw new RuntimeException("AssignRangePartition require a single RangeBoundaries as broadcast input.");
        }
        Object[][] boundaryObjects = (Object[][])broadcastVariable.get(0);
        CommonRangeBoundaries rangeBoundaries = new CommonRangeBoundaries(this.typeComparator.createComparator(), boundaryObjects);
        Tuple2 tupleWithPartitionId = new Tuple2();
        for (IN record : values) {
            tupleWithPartitionId.f0 = rangeBoundaries.getRangeIndex(record);
            tupleWithPartitionId.f1 = record;
            out.collect((Object)tupleWithPartitionId);
        }
    }
}

