/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class EnterOrderedListDialog
extends Dialog {
    private static final Class<?> PKG = EnterOrderedListDialog.class;
    public static final int LARGE_MARGIN = 15;
    private String[] input;
    private String[] retval;
    private Stack<String> selection = new Stack();
    private Shell shell;
    private List wListSource;
    private List wListTarget;
    private Button wButtonAdd;
    private Button wButtonAddAll;
    private Button wButtonRemoveAll;
    private Button wButtonRemove;
    private Button wButtonUp;
    private Button wDuttonDown;
    private boolean opened;

    public EnterOrderedListDialog(Shell parent, int style, String[] input) {
        super(parent, style);
        this.input = input;
        this.retval = null;
        this.opened = false;
    }

    public String[] open() {
        PropsUi props = PropsUi.getInstance();
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterOrderedListDialog.Title", (String[])new String[0]));
        this.shell.setMinimumSize(500, 380);
        this.shell.setLayout((Layout)new FormLayout());
        Composite top = new Composite((Composite)this.shell, 0);
        FormLayout topLayout = new FormLayout();
        topLayout.marginHeight = 15;
        topLayout.marginWidth = 15;
        top.setLayout((Layout)topLayout);
        top.setLayoutData((Object)new FormDataBuilder().top().bottom(100, -50).left().right(100, 0).result());
        PropsUi.setLook((Widget)top);
        Composite bottom = new Composite((Composite)this.shell, 0);
        FormLayout bottomLayout = new FormLayout();
        bottomLayout.marginHeight = 15;
        bottomLayout.marginWidth = 15;
        bottom.setLayout((Layout)bottomLayout);
        bottom.setLayoutData((Object)new FormDataBuilder().top((Control)top, 0).bottom().right().result());
        PropsUi.setLook((Widget)bottom);
        Composite leftPane = new Composite(top, 0);
        leftPane.setLayout((Layout)new FormLayout());
        leftPane.setLayoutData((Object)new FormDataBuilder().top().left().bottom(100, 0).right(50, -36).result());
        PropsUi.setLook((Widget)leftPane);
        Label lblListSource = new Label(leftPane, 0);
        lblListSource.setText(BaseMessages.getString(PKG, (String)"EnterOrderedListDialog.AvailableItems.Label", (String[])new String[0]));
        lblListSource.setLayoutData((Object)new FormDataBuilder().top().left().result());
        PropsUi.setLook((Widget)lblListSource);
        this.wListSource = new List(leftPane, 2818);
        this.wListSource.setLayoutData((Object)new FormDataBuilder().top((Control)lblListSource, 5).left().bottom(100, 0).right(100, 0).result());
        this.wListSource.addListener(13, e -> this.updateButton());
        this.wListSource.addListener(14, e -> this.addToSelection(this.wListSource.getSelection()));
        this.wListSource.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\r') {
                    EnterOrderedListDialog.this.addToSelection(EnterOrderedListDialog.this.wListSource.getSelection());
                }
            }
        });
        PropsUi.setLook((Widget)this.wListSource);
        Composite middlePane = new Composite(top, 0);
        middlePane.setLayout((Layout)new FormLayout());
        middlePane.setLayoutData((Object)new FormDataBuilder().top().left((Control)leftPane, -36).bottom(100, 0).right(50, 36).result());
        PropsUi.setLook((Widget)middlePane);
        Label label = new Label(middlePane, 0);
        label.setLayoutData((Object)new FormDataBuilder().top().left().result());
        PropsUi.setLook((Widget)label);
        Composite gButtonGroup = new Composite(middlePane, 0);
        RowLayout layout = new RowLayout();
        layout.wrap = false;
        layout.type = 512;
        layout.marginTop = 0;
        layout.marginLeft = 15;
        layout.marginRight = 15;
        gButtonGroup.setLayout((Layout)layout);
        gButtonGroup.setLayoutData((Object)new FormDataBuilder().top((Control)label, 5).left().bottom(100, 0).right(100, 0).result());
        PropsUi.setLook((Widget)gButtonGroup);
        this.wButtonAdd = new Button(gButtonGroup, 8);
        this.wButtonAdd.setImage(GuiResource.getInstance().getImageAddSingle());
        this.wButtonAdd.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOrderedListDialog.AddOne.Tooltip", (String[])new String[0]));
        this.wButtonAdd.setLayoutData((Object)new RowData(32, 32));
        this.wButtonAdd.addListener(13, e -> this.addToSelection(this.wListSource.getSelection()));
        this.wButtonAddAll = new Button(gButtonGroup, 8);
        this.wButtonAddAll.setImage(GuiResource.getInstance().getImageAddAll());
        this.wButtonAddAll.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOrderedListDialog.AddAll.Tooltip", (String[])new String[0]));
        this.wButtonAddAll.setLayoutData((Object)new RowData(32, 32));
        this.wButtonAddAll.addListener(13, e -> this.addToSelection(this.wListSource.getItems()));
        this.wButtonRemove = new Button(gButtonGroup, 8);
        this.wButtonRemove.setImage(GuiResource.getInstance().getImageRemoveSingle());
        this.wButtonRemove.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOrderedListDialog.RemoveOne.Tooltip", (String[])new String[0]));
        this.wButtonRemove.setLayoutData((Object)new RowData(32, 32));
        this.wButtonRemove.addListener(13, e -> this.removeFromSelection(this.wListTarget.getSelection()));
        this.wButtonRemoveAll = new Button(gButtonGroup, 8);
        this.wButtonRemoveAll.setImage(GuiResource.getInstance().getImageRemoveAll());
        this.wButtonRemoveAll.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOrderedListDialog.RemoveAll.Tooltip", (String[])new String[0]));
        this.wButtonRemoveAll.setLayoutData((Object)new RowData(32, 32));
        this.wButtonRemoveAll.addListener(13, e -> this.removeFromSelection(this.wListTarget.getItems()));
        this.wButtonUp = new Button(gButtonGroup, 8);
        this.wButtonUp.setImage(GuiResource.getInstance().getImageUp());
        this.wButtonUp.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOrderedListDialog.Up.Tooltip", (String[])new String[0]));
        this.wButtonUp.setLayoutData((Object)new RowData(32, 32));
        this.wButtonUp.addListener(13, e -> this.upToSelection(this.wListTarget.getSelection()));
        this.wDuttonDown = new Button(gButtonGroup, 8);
        this.wDuttonDown.setImage(GuiResource.getInstance().getImageDown());
        this.wDuttonDown.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOrderedListDialog.Down.Tooltip", (String[])new String[0]));
        this.wDuttonDown.setLayoutData((Object)new RowData(32, 32));
        this.wDuttonDown.addListener(13, e -> this.downToSelection(this.wListTarget.getSelection()));
        this.wButtonAddAll.pack();
        int offset = this.wButtonAddAll.computeSize((int)-1, (int)-1).x / 2;
        FormData fdButtonGroup = new FormData();
        this.wButtonAddAll.pack();
        fdButtonGroup.left = new FormAttachment(50, -(this.wButtonAddAll.getSize().x / 2) - 5);
        fdButtonGroup.top = new FormAttachment(50, -offset);
        gButtonGroup.setLayoutData((Object)new FormDataBuilder().top((Control)label, 5).left(50, -offset).result());
        Composite rightPane = new Composite(top, 0);
        rightPane.setLayout((Layout)new FormLayout());
        rightPane.setLayoutData((Object)new FormDataBuilder().top().left((Control)middlePane, 0).bottom(100, 0).right(100, 0).result());
        PropsUi.setLook((Widget)rightPane);
        Label lblListTarget = new Label(rightPane, 0);
        lblListTarget.setText(BaseMessages.getString(PKG, (String)"EnterOrderedListDialog.Selection.Label", (String[])new String[0]));
        lblListTarget.setLayoutData((Object)new FormDataBuilder().top().left().result());
        PropsUi.setLook((Widget)lblListTarget);
        this.wListTarget = new List(rightPane, 2818);
        this.wListTarget.setLayoutData((Object)new FormDataBuilder().top((Control)lblListTarget, 5).left().bottom(100, 0).right(100, 0).result());
        this.wListTarget.addListener(13, e -> this.updateButton());
        this.wListTarget.addListener(14, e -> this.removeFromSelection(this.wListTarget.getSelection()));
        this.wListTarget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\r') {
                    EnterOrderedListDialog.this.removeFromSelection(EnterOrderedListDialog.this.wListTarget.getSelection());
                }
            }
        });
        PropsUi.setLook((Widget)this.wListTarget);
        Button wCancel = new Button(bottom, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.dispose());
        Button wOK = new Button(bottom, 8);
        wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOK.addListener(13, e -> this.ok());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOK, wCancel}, props.getMargin(), null);
        Transfer[] ttypes = new Transfer[]{TextTransfer.getInstance()};
        DragSource ddSource = new DragSource((Control)this.wListSource, 3);
        ddSource.setTransfer(ttypes);
        ddSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                String[] ti = EnterOrderedListDialog.this.wListSource.getSelection();
                Object data = new String();
                for (int i = 0; i < ti.length; ++i) {
                    data = (String)data + ti[i] + Const.CR;
                }
                event.data = data;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        DropTarget ddTarget = new DropTarget((Control)this.wListTarget, 3);
        ddTarget.setTransfer(ttypes);
        ddTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 13;
            }

            public void drop(DropTargetEvent event) {
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                StringTokenizer strtok = new StringTokenizer((String)event.data, Const.CR);
                while (strtok.hasMoreTokens()) {
                    String source = strtok.nextToken();
                    EnterOrderedListDialog.this.addToSelection(source);
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        this.opened = true;
        this.update();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.dispose());
        return this.retval;
    }

    protected void update() {
        if (!this.opened) {
            return;
        }
        this.wListSource.removeAll();
        for (String element : this.input) {
            if (this.selection.indexOf(element) >= 0) continue;
            this.wListSource.add(element);
        }
        String[] currentSelection = this.wListTarget.getSelection();
        this.wListTarget.removeAll();
        for (String element : this.selection) {
            this.wListTarget.add(element);
        }
        this.wListTarget.setSelection(currentSelection);
        this.updateButton();
    }

    protected void updateButton() {
        int index = this.wListTarget.getSelectionIndex();
        this.wButtonAdd.setEnabled(this.wListSource.getSelectionIndex() >= 0);
        this.wButtonAddAll.setEnabled(this.wListSource.getItemCount() > 0);
        this.wButtonRemove.setEnabled(index >= 0);
        this.wButtonRemoveAll.setEnabled(this.selection.size() > 0);
        this.wButtonUp.setEnabled(this.selection.size() > 1 && index > 0);
        this.wDuttonDown.setEnabled(this.selection.size() > 1 && index >= 0 && index < this.selection.size() - 1);
    }

    public void addToSelection(String ... elements) {
        for (String element : elements) {
            if (Utils.isEmpty((CharSequence)element)) continue;
            this.selection.push(element);
        }
        this.update();
    }

    public void removeFromSelection(String ... elements) {
        for (String element : elements) {
            this.selection.remove(element);
        }
        this.update();
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        PropsUi.getInstance().setScreen(winprop);
        this.shell.dispose();
    }

    public void ok() {
        this.retval = this.wListTarget.getItems();
        this.dispose();
    }

    private void upToSelection(String ... elements) {
        String element;
        int index;
        String[] stringArray = elements;
        int n = stringArray.length;
        for (int i = 0; i < n && (index = this.selection.indexOf(element = stringArray[i])) > 0; ++i) {
            this.selection.remove(index);
            this.selection.add(index - 1, element);
        }
        this.update();
    }

    private void downToSelection(String ... elements) {
        String element;
        int index;
        for (int i = elements.length - 1; i >= 0 && (index = this.selection.indexOf(element = elements[i])) < this.selection.size() - 1; --i) {
            this.selection.remove(index);
            this.selection.add(index + 1, element);
        }
        this.update();
    }
}

