/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.stateful;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.MapState;
import org.apache.beam.sdk.state.MultimapState;
import org.apache.beam.sdk.state.OrderedListState;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.state.SetState;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.state.WatermarkHoldState;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.util.CombineFnUtil;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Table;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;

class SparkStateInternals<@UnknownKeyFor K>
implements StateInternals {
    private final K key;
    private final @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> stateTable;

    private SparkStateInternals(K key) {
        this.key = key;
        this.stateTable = HashBasedTable.create();
    }

    private SparkStateInternals(K key, @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> stateTable) {
        this.key = key;
        this.stateTable = stateTable;
    }

    static <K> @UnknownKeyFor @NonNull @Initialized SparkStateInternals<K> forKey(K key) {
        return new SparkStateInternals<K>(key);
    }

    static <K> @UnknownKeyFor @NonNull @Initialized SparkStateInternals<K> forKeyAndState(K key, @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> stateTable) {
        return new SparkStateInternals<K>(key, stateTable);
    }

    public @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getState() {
        return this.stateTable;
    }

    public K getKey() {
        return this.key;
    }

    public <T extends State> T state(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized StateTag<T> address, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> c) {
        return (T)address.bind((StateTag.StateBinder)new SparkStateBinder(namespace, c));
    }

    private final class SparkBagState<@UnknownKeyFor T>
    extends AbstractState<List<T>>
    implements BagState<T> {
        private SparkBagState(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized StateTag<BagState<T>> address, Coder<T> coder) {
            super(namespace, address, (Coder)ListCoder.of(coder));
        }

        public @UnknownKeyFor @NonNull @Initialized SparkStateInternals. @UnknownKeyFor @NonNull @Initialized SparkBagState<T> readLater() {
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized List<T> read() {
            ArrayList value = (ArrayList)super.readValue();
            if (value == null) {
                value = new ArrayList();
            }
            return value;
        }

        public void add(T input) {
            Iterable value = this.read();
            value.add(input);
            this.writeValue(value);
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> readLater() {
                    return this;
                }

                public @UnknownKeyFor @NonNull @Initialized Boolean read() {
                    return SparkStateInternals.this.stateTable.get((Object)SparkBagState.this.namespace.stringKey(), (Object)SparkBagState.this.address.getId()) == null;
                }
            };
        }
    }

    private class SparkCombiningState<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    extends AbstractState<AccumT>
    implements CombiningState<InputT, AccumT, OutputT> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn;

        private SparkCombiningState(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized StateTag<CombiningState<InputT, AccumT, OutputT>> address, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> coder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            super(namespace, address, coder);
            this.combineFn = combineFn;
        }

        public @UnknownKeyFor @NonNull @Initialized SparkStateInternals. @UnknownKeyFor @NonNull @Initialized SparkCombiningState<K, InputT, AccumT, OutputT> readLater() {
            return this;
        }

        public OutputT read() {
            return (OutputT)this.combineFn.extractOutput(this.getAccum());
        }

        public void add(InputT input) {
            Object accum = this.combineFn.addInput(this.getAccum(), input);
            this.writeValue(accum);
        }

        public AccumT getAccum() {
            Object accum = this.readValue();
            if (accum == null) {
                accum = this.combineFn.createAccumulator();
            }
            return (AccumT)accum;
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> readLater() {
                    return this;
                }

                public @UnknownKeyFor @NonNull @Initialized Boolean read() {
                    return SparkStateInternals.this.stateTable.get((Object)SparkCombiningState.this.namespace.stringKey(), (Object)SparkCombiningState.this.address.getId()) == null;
                }
            };
        }

        public void addAccum(AccumT accum) {
            accum = this.combineFn.mergeAccumulators(Arrays.asList(this.getAccum(), accum));
            this.writeValue(accum);
        }

        public AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators) {
            return (AccumT)this.combineFn.mergeAccumulators(accumulators);
        }
    }

    private class SparkWatermarkHoldState
    extends AbstractState<Instant>
    implements WatermarkHoldState {
        private final @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner;

        SparkWatermarkHoldState(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized StateTag<WatermarkHoldState> address, TimestampCombiner timestampCombiner) {
            super(namespace, address, (Coder)InstantCoder.of());
            this.timestampCombiner = timestampCombiner;
        }

        public @UnknownKeyFor @NonNull @Initialized SparkStateInternals. @UnknownKeyFor @NonNull @Initialized SparkWatermarkHoldState readLater() {
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant read() {
            return (Instant)this.readValue();
        }

        public void add(@UnknownKeyFor @NonNull @Initialized Instant outputTime) {
            Instant combined = this.read();
            combined = combined == null ? outputTime : this.getTimestampCombiner().combine(new Instant[]{combined, outputTime});
            this.writeValue(combined);
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> readLater() {
                    return this;
                }

                public @UnknownKeyFor @NonNull @Initialized Boolean read() {
                    return SparkStateInternals.this.stateTable.get((Object)SparkWatermarkHoldState.this.namespace.stringKey(), (Object)SparkWatermarkHoldState.this.address.getId()) == null;
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized TimestampCombiner getTimestampCombiner() {
            return this.timestampCombiner;
        }
    }

    private class SparkValueState<@UnknownKeyFor T>
    extends AbstractState<T>
    implements ValueState<T> {
        private SparkValueState(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized StateTag<ValueState<T>> address, Coder<T> coder) {
            super(namespace, address, coder);
        }

        public @UnknownKeyFor @NonNull @Initialized SparkStateInternals. @UnknownKeyFor @NonNull @Initialized SparkValueState<T> readLater() {
            return this;
        }

        public T read() {
            return this.readValue();
        }

        public void write(T input) {
            this.writeValue(input);
        }
    }

    private class AbstractState<@UnknownKeyFor T> {
        final @UnknownKeyFor @NonNull @Initialized StateNamespace namespace;
        final @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized State> address;
        final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

        private AbstractState(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized StateTag<? extends State> address, Coder<T> coder) {
            this.namespace = namespace;
            this.address = address;
            this.coder = coder;
        }

        T readValue() {
            byte[] buf = (byte[])SparkStateInternals.this.stateTable.get((Object)this.namespace.stringKey(), (Object)this.address.getId());
            if (buf != null) {
                return CoderHelpers.fromByteArray(buf, this.coder);
            }
            return null;
        }

        void writeValue(T input) {
            SparkStateInternals.this.stateTable.put((Object)this.namespace.stringKey(), (Object)this.address.getId(), (Object)CoderHelpers.toByteArray(input, this.coder));
        }

        public void clear() {
            SparkStateInternals.this.stateTable.remove((Object)this.namespace.stringKey(), (Object)this.address.getId());
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractState that = (AbstractState)o;
            return this.namespace.equals(that.namespace) && this.address.equals(that.address);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + this.address.hashCode();
            return result;
        }
    }

    private class SparkStateBinder
    implements StateTag.StateBinder {
        private final @UnknownKeyFor @NonNull @Initialized StateNamespace namespace;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> c;

        private SparkStateBinder(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized StateNamespace namespace, StateContext<?> c) {
            this.namespace = namespace;
            this.c = c;
        }

        public <T> @UnknownKeyFor @NonNull @Initialized ValueState<T> bindValue(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized ValueState<T>> address, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return new SparkValueState(this.namespace, address, coder);
        }

        public <T> @UnknownKeyFor @NonNull @Initialized BagState<T> bindBag(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized BagState<T>> address, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
            return new SparkBagState(this.namespace, address, elemCoder);
        }

        public <T> @UnknownKeyFor @NonNull @Initialized SetState<T> bindSet(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized SetState<T>> spec, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
            throw new UnsupportedOperationException(String.format("%s is not supported", SetState.class.getSimpleName()));
        }

        public <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized MapState<KeyT, ValueT> bindMap(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized MapState<KeyT, ValueT>> spec, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> mapKeyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> mapValueCoder) {
            throw new UnsupportedOperationException(String.format("%s is not supported", MapState.class.getSimpleName()));
        }

        public <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized MultimapState<KeyT, ValueT> bindMultimap(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized MultimapState<KeyT, ValueT>> spec, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> valueCoder) {
            throw new UnsupportedOperationException(String.format("%s is not supported", MultimapState.class.getSimpleName()));
        }

        public <T> @UnknownKeyFor @NonNull @Initialized OrderedListState<T> bindOrderedList(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized OrderedListState<T>> spec, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
            throw new UnsupportedOperationException(String.format("%s is not supported", OrderedListState.class.getSimpleName()));
        }

        public <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bindCombiningValue(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> address, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            return new SparkCombiningState(this.namespace, address, accumCoder, combineFn);
        }

        public <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bindCombiningValueWithContext(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> address, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
            return new SparkCombiningState(this.namespace, address, accumCoder, CombineFnUtil.bindContext(combineFn, this.c));
        }

        public @UnknownKeyFor @NonNull @Initialized WatermarkHoldState bindWatermark(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized WatermarkHoldState> address, @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
            return new SparkWatermarkHoldState(this.namespace, address, timestampCombiner);
        }
    }
}

