/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.io;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.avro.io.AvroIO;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@Internal
@AutoService(value={SchemaIOProvider.class})
public class AvroSchemaIOProvider
implements SchemaIOProvider {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "avro";
    }

    public @UnknownKeyFor @NonNull @Initialized Schema configurationSchema() {
        return Schema.builder().addNullableField("writeWindowSizeSeconds", Schema.FieldType.INT64).build();
    }

    public @UnknownKeyFor @NonNull @Initialized AvroSchemaIO from(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row configuration, @UnknownKeyFor @NonNull @Initialized Schema dataSchema) {
        return new AvroSchemaIO(location, dataSchema, configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean requiresDataSchema() {
        return true;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    private static class AvroSchemaIO
    implements SchemaIO,
    Serializable {
        protected final @UnknownKeyFor @NonNull @Initialized Schema dataSchema;
        protected final @UnknownKeyFor @NonNull @Initialized String location;
        protected final @Nullable @UnknownKeyFor @Initialized Duration windowSize;

        private AvroSchemaIO(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Schema dataSchema, @UnknownKeyFor @NonNull @Initialized Row configuration) {
            this.dataSchema = dataSchema;
            this.location = location;
            this.windowSize = configuration.getInt64("writeWindowSizeSeconds") != null ? Duration.standardSeconds((long)configuration.getInt64("writeWindowSizeSeconds")) : null;
        }

        public @UnknownKeyFor @NonNull @Initialized Schema schema() {
            return this.dataSchema;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
                    return (PCollection)((PCollection)begin.apply("AvroIORead", AvroIO.readGenericRecords(AvroUtils.toAvroSchema(dataSchema, null, null)).withBeamSchemas(true).from(location))).apply("ToRows", Convert.toRows());
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized POutput> buildWriter() {
            return new PTransform<PCollection<Row>, POutput>(){

                public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                    PCollection asRecords = (PCollection)input.apply("ToGenericRecords", Convert.to(GenericRecord.class));
                    AvroIO.Write<GenericRecord> avroWrite = AvroIO.writeGenericRecords(AvroUtils.toAvroSchema(dataSchema, null, null)).to(location);
                    if (input.isBounded() == PCollection.IsBounded.UNBOUNDED || windowSize != null) {
                        asRecords = (PCollection)asRecords.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)(windowSize == null ? Duration.standardMinutes((long)1L) : windowSize))));
                        avroWrite = avroWrite.withWindowedWrites().withNumShards(1);
                    } else {
                        avroWrite = avroWrite.withoutSharding();
                    }
                    return (PDone)asRecords.apply("AvroIOWrite", avroWrite);
                }
            };
        }
    }
}

