/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.googleapis;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.NameResolver;
import net.snowflake.client.jdbc.internal.grpc.NameResolverProvider;
import net.snowflake.client.jdbc.internal.grpc.googleapis.GoogleCloudToProdNameResolver;
import net.snowflake.client.jdbc.internal.grpc.internal.GrpcUtil;
import net.snowflake.client.jdbc.internal.grpc.xds.InternalSharedXdsClientPoolProvider;

@Internal
public final class GoogleCloudToProdNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "google-c2p";
    private final String scheme;

    public GoogleCloudToProdNameResolverProvider() {
        this(SCHEME);
    }

    GoogleCloudToProdNameResolverProvider(String scheme) {
        this.scheme = Preconditions.checkNotNull(scheme, "scheme");
    }

    @Override
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (this.scheme.equals(targetUri.getScheme())) {
            return new GoogleCloudToProdNameResolver(targetUri, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, new SharedXdsClientPoolProviderBootstrapSetter());
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return this.scheme;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 4;
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }

    private static final class SharedXdsClientPoolProviderBootstrapSetter
    implements GoogleCloudToProdNameResolver.BootstrapSetter {
        private SharedXdsClientPoolProviderBootstrapSetter() {
        }

        @Override
        public void setBootstrap(Map<String, ?> bootstrap) {
            InternalSharedXdsClientPoolProvider.setDefaultProviderBootstrapOverride(bootstrap);
        }
    }
}

