/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileBasedSink<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT, @UnknownKeyFor OutputT>
implements Serializable,
HasDisplayData {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FileBasedSink.class);
    static final @UnknownKeyFor @NonNull @Initialized String TEMP_DIRECTORY_PREFIX = ".temp-beam";
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, OutputT> dynamicDestinations;
    private final @UnknownKeyFor @NonNull @Initialized WritableByteChannelFactory writableByteChannelFactory;
    private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> tempDirectoryProvider;

    public static @UnknownKeyFor @NonNull @Initialized ResourceId convertToFileResourceIfPossible(@UnknownKeyFor @NonNull @Initialized String outputPrefix) {
        try {
            return FileSystems.matchNewResource(outputPrefix, false);
        }
        catch (Exception e) {
            return FileSystems.matchNewResource(outputPrefix, true);
        }
    }

    public FileBasedSink(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> tempDirectoryProvider, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, OutputT> dynamicDestinations) {
        this(tempDirectoryProvider, dynamicDestinations, Compression.UNCOMPRESSED);
    }

    public FileBasedSink(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> tempDirectoryProvider, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, OutputT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized WritableByteChannelFactory writableByteChannelFactory) {
        this.tempDirectoryProvider = ValueProvider.NestedValueProvider.of(tempDirectoryProvider, new ExtractDirectory());
        this.dynamicDestinations = (DynamicDestinations)Preconditions.checkNotNull(dynamicDestinations);
        this.writableByteChannelFactory = writableByteChannelFactory;
    }

    public FileBasedSink(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> tempDirectoryProvider, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, OutputT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized Compression compression) {
        this(tempDirectoryProvider, dynamicDestinations, CompressionType.fromCanonical(compression));
    }

    public @UnknownKeyFor @NonNull @Initialized DynamicDestinations<UserT, DestinationT, OutputT> getDynamicDestinations() {
        return this.dynamicDestinations;
    }

    public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> getTempDirectoryProvider() {
        return this.tempDirectoryProvider;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
    }

    public abstract @UnknownKeyFor @NonNull @Initialized WriteOperation<DestinationT, OutputT> createWriteOperation();

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        this.getDynamicDestinations().populateDisplayData(builder);
    }

    protected final @UnknownKeyFor @NonNull @Initialized WritableByteChannelFactory getWritableByteChannelFactory() {
        return this.writableByteChannelFactory;
    }

    public static interface WritableByteChannelFactory
    extends OutputFileHints {
        public @UnknownKeyFor @NonNull @Initialized WritableByteChannel create(@UnknownKeyFor @NonNull @Initialized WritableByteChannel var1) throws @UnknownKeyFor @NonNull @Initialized IOException;
    }

    public static interface OutputFileHints
    extends Serializable {
        public @Nullable @UnknownKeyFor @Initialized String getMimeType();

        public @Nullable @UnknownKeyFor @Initialized String getSuggestedFilenameSuffix();
    }

    public static final class FileResultCoder<@UnknownKeyFor DestinationT>
    extends StructuredCoder<FileResult<DestinationT>> {
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> FILENAME_CODER = StringUtf8Coder.of();
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Integer> SHARD_CODER = VarIntCoder.of();
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized PaneInfo> PANE_INFO_CODER = NullableCoder.of(PaneInfo.PaneInfoCoder.INSTANCE);
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder;

        protected FileResultCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder) {
            this.windowCoder = NullableCoder.of(windowCoder);
            this.destinationCoder = destinationCoder;
        }

        public static <DestinationT> @UnknownKeyFor @NonNull @Initialized FileResultCoder<DestinationT> of(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder) {
            return new FileResultCoder<DestinationT>(windowCoder, destinationCoder);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.singletonList(this.destinationCoder);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getComponents() {
            return Arrays.asList(this.windowCoder, this.destinationCoder);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized FileResult<DestinationT> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null value");
            }
            FILENAME_CODER.encode(value.getTempFilename().toString(), outStream);
            this.windowCoder.encode(value.getWindow(), outStream);
            PANE_INFO_CODER.encode(value.getPaneInfo(), outStream);
            SHARD_CODER.encode(value.getShard(), outStream);
            this.destinationCoder.encode(value.getDestination(), outStream);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FileResult<DestinationT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String tempFilename = FILENAME_CODER.decode(inStream);
            BoundedWindow window = this.windowCoder.decode(inStream);
            PaneInfo paneInfo = PANE_INFO_CODER.decode(inStream);
            int shard = SHARD_CODER.decode(inStream);
            DestinationT destination = this.destinationCoder.decode(inStream);
            return new FileResult<DestinationT>(FileSystems.matchNewResource(tempFilename, false), shard, window, paneInfo, destination);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            FILENAME_CODER.verifyDeterministic();
            this.windowCoder.verifyDeterministic();
            PANE_INFO_CODER.verifyDeterministic();
            SHARD_CODER.verifyDeterministic();
            this.destinationCoder.verifyDeterministic();
        }
    }

    public static final class FileResult<@UnknownKeyFor DestinationT> {
        private final @UnknownKeyFor @NonNull @Initialized ResourceId tempFilename;
        private final @UnknownKeyFor @NonNull @Initialized int shard;
        private final @UnknownKeyFor @NonNull @Initialized BoundedWindow window;
        private final @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo;
        private final DestinationT destination;

        public FileResult(@UnknownKeyFor @NonNull @Initialized ResourceId tempFilename, @UnknownKeyFor @NonNull @Initialized int shard, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, DestinationT destination) {
            Preconditions.checkArgument((window != null ? 1 : 0) != 0, (Object)"window can not be null");
            Preconditions.checkArgument((paneInfo != null ? 1 : 0) != 0, (Object)"paneInfo can not be null");
            this.tempFilename = tempFilename;
            this.shard = shard;
            this.window = window;
            this.paneInfo = paneInfo;
            this.destination = destination;
        }

        public @UnknownKeyFor @NonNull @Initialized ResourceId getTempFilename() {
            return this.tempFilename;
        }

        public @UnknownKeyFor @NonNull @Initialized int getShard() {
            return this.shard;
        }

        public @UnknownKeyFor @NonNull @Initialized FileResult<DestinationT> withShard(@UnknownKeyFor @NonNull @Initialized int shard) {
            return new FileResult<DestinationT>(this.tempFilename, shard, this.window, this.paneInfo, this.destination);
        }

        public @Nullable @UnknownKeyFor @Initialized BoundedWindow getWindow() {
            return this.window;
        }

        public @UnknownKeyFor @NonNull @Initialized PaneInfo getPaneInfo() {
            return this.paneInfo;
        }

        public DestinationT getDestination() {
            return this.destination;
        }

        public @UnknownKeyFor @NonNull @Initialized ResourceId getDestinationFile(@UnknownKeyFor @NonNull @Initialized boolean windowedWrites, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized int numShards, @UnknownKeyFor @NonNull @Initialized OutputFileHints outputFileHints) {
            Preconditions.checkArgument((this.getShard() != -1 ? 1 : 0) != 0);
            Preconditions.checkArgument((numShards > 0 ? 1 : 0) != 0);
            FilenamePolicy policy = dynamicDestinations.getFilenamePolicy(this.destination);
            if (windowedWrites) {
                return policy.windowedFilename(this.getShard(), numShards, this.getWindow(), this.getPaneInfo(), outputFileHints);
            }
            return policy.unwindowedFilename(this.getShard(), numShards, outputFileHints);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(FileResult.class).add("tempFilename", (Object)this.tempFilename).add("shard", this.shard).add("window", (Object)this.window).add("paneInfo", (Object)this.paneInfo).toString();
        }
    }

    public static abstract class Writer<@UnknownKeyFor DestinationT, @UnknownKeyFor OutputT> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Writer.class);
        private final @UnknownKeyFor @NonNull @Initialized WriteOperation<DestinationT, OutputT> writeOperation;
        private @Nullable @UnknownKeyFor @Initialized String id;
        private @Nullable DestinationT destination;
        private @Nullable @UnknownKeyFor @Initialized ResourceId outputFile;
        private @Nullable @UnknownKeyFor @Initialized WritableByteChannel channel;
        private final @Nullable @UnknownKeyFor @Initialized String mimeType;

        public Writer(@UnknownKeyFor @NonNull @Initialized WriteOperation<DestinationT, OutputT> writeOperation, @UnknownKeyFor @NonNull @Initialized String mimeType) {
            Preconditions.checkNotNull(writeOperation);
            this.writeOperation = writeOperation;
            this.mimeType = mimeType;
        }

        protected abstract void prepareWrite(@UnknownKeyFor @NonNull @Initialized WritableByteChannel var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

        protected void writeHeader() throws @UnknownKeyFor @NonNull @Initialized Exception {
        }

        protected void writeFooter() throws @UnknownKeyFor @NonNull @Initialized Exception {
        }

        protected void finishWrite() throws @UnknownKeyFor @NonNull @Initialized Exception {
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized String spreadUid(@UnknownKeyFor @NonNull @Initialized String uId) {
            return String.format("%08x%s", uId.hashCode(), uId);
        }

        public final void open(@UnknownKeyFor @NonNull @Initialized String uId) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.id = Writer.spreadUid(uId);
            ResourceId tempDirectory = this.getWriteOperation().getTempDirectory();
            this.outputFile = tempDirectory.resolve(this.id, ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
            Verify.verifyNotNull((Object)this.outputFile, (String)"FileSystems are not allowed to return null from resolve: %s", (Object[])new Object[]{tempDirectory});
            WritableByteChannelFactory factory = ((FileBasedSink)this.getWriteOperation().getSink()).writableByteChannelFactory;
            String channelMimeType = (String)MoreObjects.firstNonNull((Object)factory.getMimeType(), (Object)this.mimeType);
            CreateOptions.StandardCreateOptions createOptions = ((CreateOptions.StandardCreateOptions.Builder)((CreateOptions.StandardCreateOptions.Builder)CreateOptions.StandardCreateOptions.builder().setMimeType(channelMimeType)).setExpectFileToNotExist(true)).build();
            WritableByteChannel tempChannel = FileSystems.create(this.outputFile, createOptions);
            try {
                this.channel = factory.create(tempChannel);
            }
            catch (Exception e) {
                Writer.closeChannelAndThrow(tempChannel, this.outputFile, e);
            }
            try {
                LOG.debug("Preparing write to {}.", (Object)this.outputFile);
                this.prepareWrite(this.channel);
                LOG.debug("Writing header to {}.", (Object)this.outputFile);
                this.writeHeader();
            }
            catch (Exception e) {
                LOG.error("Beginning write to {} failed, closing channel.", (Object)this.outputFile, (Object)e);
                Writer.closeChannelAndThrow(this.channel, this.outputFile, e);
            }
            LOG.debug("Starting write of bundle {} to {}.", (Object)this.id, (Object)this.outputFile);
        }

        public abstract void write(OutputT var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

        public @UnknownKeyFor @NonNull @Initialized ResourceId getOutputFile() {
            return this.outputFile;
        }

        private static void closeChannelAndThrow(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel, @UnknownKeyFor @NonNull @Initialized ResourceId filename, @UnknownKeyFor @NonNull @Initialized Exception prior) throws @UnknownKeyFor @NonNull @Initialized Exception {
            try {
                channel.close();
            }
            catch (Exception e) {
                LOG.error("Closing channel for {} failed.", (Object)filename, (Object)e);
                prior.addSuppressed(e);
            }
            throw prior;
        }

        public final void cleanup() throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.outputFile != null) {
                LOG.info("Deleting temporary file {}", (Object)this.outputFile);
                FileSystems.delete(Collections.singletonList(this.outputFile), MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES);
            }
        }

        public final void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
            Preconditions.checkState((this.outputFile != null ? 1 : 0) != 0, (Object)"FileResult.close cannot be called with a null outputFile");
            LOG.debug("Closing {}", (Object)this.outputFile);
            try {
                this.writeFooter();
            }
            catch (Exception e) {
                Writer.closeChannelAndThrow(this.channel, this.outputFile, e);
            }
            try {
                this.finishWrite();
            }
            catch (Exception e) {
                Writer.closeChannelAndThrow(this.channel, this.outputFile, e);
            }
            if (this.channel.isOpen()) {
                LOG.debug("Closing channel to {}.", (Object)this.outputFile);
                try {
                    this.channel.close();
                }
                catch (Exception e) {
                    throw new IOException(String.format("Failed closing channel to %s", this.outputFile), e);
                }
            }
            LOG.info("Successfully wrote temporary file {}", (Object)this.outputFile);
        }

        public @UnknownKeyFor @NonNull @Initialized WriteOperation<DestinationT, OutputT> getWriteOperation() {
            return this.writeOperation;
        }

        void setDestination(DestinationT destination) {
            this.destination = destination;
        }

        public DestinationT getDestination() {
            return this.destination;
        }
    }

    public static abstract class WriteOperation<@UnknownKeyFor DestinationT, @UnknownKeyFor OutputT>
    implements Serializable {
        protected final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized FileBasedSink<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, OutputT> sink;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> baseTempDirectory;
        private @UnknownKeyFor @NonNull @Initialized TempSubDirType tempSubdirType;
        private final @UnknownKeyFor @NonNull @Initialized UUID subdirUUID;
        protected @UnknownKeyFor @NonNull @Initialized boolean windowedWrites;

        protected static @UnknownKeyFor @NonNull @Initialized ResourceId buildTemporaryFilename(@UnknownKeyFor @NonNull @Initialized ResourceId tempDirectory, @UnknownKeyFor @NonNull @Initialized String filename) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return tempDirectory.resolve(filename, ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        }

        public WriteOperation(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized FileBasedSink<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, OutputT> sink) {
            this(sink, sink.getTempDirectoryProvider(), TempSubDirType.UNIQUE);
        }

        public WriteOperation(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized FileBasedSink<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, OutputT> sink, @UnknownKeyFor @NonNull @Initialized ResourceId tempDirectory) {
            this(sink, ValueProvider.StaticValueProvider.of(tempDirectory), TempSubDirType.NONE);
        }

        private WriteOperation(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized FileBasedSink<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, OutputT> sink, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> tempDirectory, @UnknownKeyFor @NonNull @Initialized TempSubDirType tempSubdirType) {
            this.sink = sink;
            this.baseTempDirectory = tempDirectory;
            this.tempSubdirType = tempSubdirType;
            this.subdirUUID = UUID.randomUUID();
            this.windowedWrites = false;
        }

        public @UnknownKeyFor @NonNull @Initialized ResourceId getTempDirectory() {
            String tempDirName;
            if (this.tempSubdirType == TempSubDirType.NONE) {
                return this.baseTempDirectory.get();
            }
            if (this.tempSubdirType == TempSubDirType.UNIQUE) {
                tempDirName = String.format(".temp-beam-%s", this.subdirUUID);
            } else {
                assert (this.tempSubdirType == TempSubDirType.CONSISTENT);
                tempDirName = FileBasedSink.TEMP_DIRECTORY_PREFIX;
            }
            return this.baseTempDirectory.get().getCurrentDirectory().resolve(tempDirName, ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized Writer<DestinationT, OutputT> createWriter() throws @UnknownKeyFor @NonNull @Initialized Exception;

        public void setWindowedWrites() {
            this.windowedWrites = true;
            this.tempSubdirType = TempSubDirType.CONSISTENT;
        }

        public void removeTemporaryFiles(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ResourceId> filenames) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.removeTemporaryFiles(filenames, !this.windowedWrites);
        }

        protected final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized FileResult<DestinationT>, @UnknownKeyFor @NonNull @Initialized ResourceId>> finalizeDestination(@Nullable DestinationT dest, @Nullable @UnknownKeyFor @Initialized BoundedWindow window, @Nullable @UnknownKeyFor @Initialized Integer numShards, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized FileResult<DestinationT>> existingResults) throws @UnknownKeyFor @NonNull @Initialized Exception {
            int effectiveNumShards;
            Collection<FileResult<DestinationT>> completeResults = this.windowedWrites ? existingResults : this.createMissingEmptyShards(dest, numShards, existingResults);
            for (FileResult<DestinationT> res : completeResults) {
                Preconditions.checkArgument((boolean)Objects.equals(dest, res.getDestination()), (String)"File result has wrong destination: expected %s, got %s", dest, res.getDestination());
                Preconditions.checkArgument((boolean)Objects.equals(window, res.getWindow()), (String)"File result has wrong window: expected %s, got %s", (Object)window, (Object)res.getWindow());
            }
            ArrayList outputFilenames = Lists.newArrayList();
            if (numShards != null) {
                effectiveNumShards = numShards;
                for (FileResult<DestinationT> res : completeResults) {
                    Preconditions.checkArgument((res.getShard() != -1 ? 1 : 0) != 0, (String)"Fixed sharding into %s shards was specified, but file result %s does not specify a shard", (Object)numShards, res);
                }
            } else {
                effectiveNumShards = Iterables.size(completeResults);
                for (FileResult<DestinationT> res : completeResults) {
                    Preconditions.checkArgument((res.getShard() == -1 ? 1 : 0) != 0, (String)"Runner-chosen sharding was specified, but file result %s explicitly specifies a shard", res);
                }
            }
            ArrayList resultsWithShardNumbers = Lists.newArrayList();
            if (numShards != null) {
                resultsWithShardNumbers = Lists.newArrayList(completeResults);
            } else {
                int i = 0;
                for (FileResult<Object> fileResult : completeResults) {
                    resultsWithShardNumbers.add(fileResult.withShard(i++));
                }
            }
            HashMap distinctFilenames = Maps.newHashMap();
            for (FileResult<Object> fileResult : resultsWithShardNumbers) {
                Preconditions.checkArgument((fileResult.getShard() != -1 ? 1 : 0) != 0, (String)"Should have set shard number on %s", fileResult);
                ResourceId finalFilename = fileResult.getDestinationFile(this.windowedWrites, this.getSink().getDynamicDestinations(), effectiveNumShards, this.getSink().getWritableByteChannelFactory());
                Preconditions.checkArgument((!distinctFilenames.containsKey(finalFilename) ? 1 : 0) != 0, (String)"Filename policy must generate unique filenames, but generated the same name %s for file results %s and %s", (Object)finalFilename, fileResult, distinctFilenames.get(finalFilename));
                distinctFilenames.put(finalFilename, fileResult);
                outputFilenames.add(KV.of(fileResult, finalFilename));
            }
            return outputFilenames;
        }

        private @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized FileResult<DestinationT>> createMissingEmptyShards(@Nullable DestinationT dest, @Nullable @UnknownKeyFor @Initialized Integer numShards, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized FileResult<DestinationT>> existingResults) throws @UnknownKeyFor @NonNull @Initialized Exception {
            HashSet missingShardNums;
            LOG.info("Finalizing for destination {} num shards {}.", dest, (Object)existingResults.size());
            if (numShards != null) {
                Preconditions.checkArgument((existingResults.size() <= numShards ? 1 : 0) != 0, (String)"Fixed sharding into %s shards was specified, but got %s file results", (Object)numShards, (int)existingResults.size());
            }
            if (numShards == null) {
                missingShardNums = existingResults.isEmpty() ? ImmutableSet.of((Object)-1) : ImmutableSet.of();
            } else {
                missingShardNums = Sets.newHashSet();
                for (int i = 0; i < numShards; ++i) {
                    missingShardNums.add(i);
                }
                for (FileResult<DestinationT> res : existingResults) {
                    Preconditions.checkArgument((res.getShard() != -1 ? 1 : 0) != 0, (String)"Fixed sharding into %s shards was specified, but file result %s does not specify a shard", (Object)numShards, res);
                    missingShardNums.remove(res.getShard());
                }
            }
            ArrayList completeResults = Lists.newArrayList(existingResults);
            if (!missingShardNums.isEmpty()) {
                LOG.info("Creating {} empty output shards in addition to {} written for destination {}.", new Object[]{missingShardNums.size(), existingResults.size(), dest});
                Iterator<FileResult<Object>> iterator = missingShardNums.iterator();
                while (iterator.hasNext()) {
                    int shard = (Integer)((Object)iterator.next());
                    String uuid = UUID.randomUUID().toString();
                    LOG.info("Opening empty writer {} for destination {}", (Object)uuid, dest);
                    Writer<DestinationT, OutputT> writer = this.createWriter();
                    writer.setDestination(dest);
                    writer.open(uuid);
                    writer.close();
                    completeResults.add(new FileResult<DestinationT>(writer.getOutputFile(), shard, GlobalWindow.INSTANCE, PaneInfo.ON_TIME_AND_ONLY_FIRING, dest));
                }
                LOG.debug("Done creating extra shards for {}.", dest);
            }
            return completeResults;
        }

        @VisibleForTesting
        final void moveToOutputFiles(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized FileResult<DestinationT>, @UnknownKeyFor @NonNull @Initialized ResourceId>> resultsToFinalFilenames) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int numFiles = resultsToFinalFilenames.size();
            LOG.debug("Copying {} files.", (Object)numFiles);
            ArrayList<ResourceId> srcFiles = new ArrayList<ResourceId>();
            ArrayList<ResourceId> dstFiles = new ArrayList<ResourceId>();
            for (KV<FileResult<DestinationT>, ResourceId> entry : resultsToFinalFilenames) {
                srcFiles.add(entry.getKey().getTempFilename());
                dstFiles.add(entry.getValue());
                LOG.info("Will copy temporary file {} to final location {}", entry.getKey(), (Object)entry.getValue());
            }
            FileSystems.rename(srcFiles, dstFiles, MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES, MoveOptions.StandardMoveOptions.SKIP_IF_DESTINATION_EXISTS);
            this.removeTemporaryFiles(Collections.emptyList());
        }

        @VisibleForTesting
        final void removeTemporaryFiles(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ResourceId> knownFiles, @UnknownKeyFor @NonNull @Initialized boolean shouldRemoveTemporaryDirectory) throws @UnknownKeyFor @NonNull @Initialized IOException {
            HashSet<ResourceId> allMatches = new HashSet<ResourceId>(knownFiles);
            for (ResourceId match : allMatches) {
                LOG.info("Will remove known temporary file {}", (Object)match);
            }
            ResourceId tempDir = this.getTempDirectory();
            if (shouldRemoveTemporaryDirectory) {
                LOG.debug("Removing temporary bundle output files in {}.", (Object)tempDir);
                try {
                    MatchResult singleMatch = (MatchResult)Iterables.getOnlyElement(FileSystems.match(Collections.singletonList(tempDir.toString() + "*")));
                    for (MatchResult.Metadata matchResult : singleMatch.metadata()) {
                        if (!allMatches.add(matchResult.resourceId())) continue;
                        LOG.warn("Will also remove unknown temporary file {}. This might indicate that other process/job is using the same temporary folder and result in data consistency issues.", (Object)matchResult.resourceId());
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to match temporary files under: [{}].", (Object)tempDir);
                }
            }
            FileSystems.delete(allMatches, MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES);
            if (shouldRemoveTemporaryDirectory) {
                try {
                    FileSystems.delete(Collections.singletonList(tempDir), MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES);
                }
                catch (Exception e) {
                    LOG.warn("Failed to remove temporary directory: [{}].", (Object)tempDir);
                }
            }
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized FileBasedSink<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, OutputT> getSink() {
            return this.sink;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.getClass().getSimpleName() + "{tempDirectory=" + this.getTempDirectory() + ", windowedWrites=" + this.windowedWrites + '}';
        }

        private static enum TempSubDirType {
            NONE,
            UNIQUE,
            CONSISTENT;

        }
    }

    private static class ExtractDirectory
    implements SerializableFunction<ResourceId, ResourceId> {
        private ExtractDirectory() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ResourceId apply(@UnknownKeyFor @NonNull @Initialized ResourceId input) {
            return input.getCurrentDirectory();
        }
    }

    public static abstract class FilenamePolicy
    implements Serializable {
        public abstract @UnknownKeyFor @NonNull @Initialized ResourceId windowedFilename(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized BoundedWindow var3, @UnknownKeyFor @NonNull @Initialized PaneInfo var4, @UnknownKeyFor @NonNull @Initialized OutputFileHints var5);

        public abstract @Nullable @UnknownKeyFor @Initialized ResourceId unwindowedFilename(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized OutputFileHints var3);

        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        }
    }

    public static abstract class DynamicDestinations<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT, @UnknownKeyFor OutputT>
    implements HasDisplayData,
    Serializable {
        private transient @Nullable @UnknownKeyFor @Initialized SideInputAccessor sideInputAccessor;

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
            return ImmutableList.of();
        }

        protected final <SideInputT> SideInputT sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<SideInputT> view) {
            Preconditions.checkState((this.sideInputAccessor != null ? 1 : 0) != 0, (String)"sideInput called on %s but side inputs have not been initialized", (Object)this.getClass().getName());
            return this.sideInputAccessor.sideInput(view);
        }

        final void setSideInputAccessor(@UnknownKeyFor @NonNull @Initialized SideInputAccessor sideInputAccessor) {
            this.sideInputAccessor = sideInputAccessor;
        }

        final void setSideInputAccessorFromProcessContext(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            this.sideInputAccessor = new SideInputAccessorViaProcessContext(context);
        }

        public abstract OutputT formatRecord(UserT var1);

        public abstract DestinationT getDestination(UserT var1);

        public abstract DestinationT getDefaultDestination();

        public @Nullable @UnknownKeyFor @Initialized Coder<DestinationT> getDestinationCoder() {
            return null;
        }

        public abstract @UnknownKeyFor @NonNull @Initialized FilenamePolicy getFilenamePolicy(DestinationT var1);

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        }

        final @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> getDestinationCoderWithDefault(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            Coder<DestinationT> destinationCoder = this.getDestinationCoder();
            if (destinationCoder != null) {
                return destinationCoder;
            }
            @Nullable TypeDescriptor<V> descriptor = TypeDescriptors.extractFromTypeParameters(this, DynamicDestinations.class, new TypeDescriptors.TypeVariableExtractor<DynamicDestinations<UserT, DestinationT, OutputT>, DestinationT>(){});
            try {
                return registry.getCoder(descriptor);
            }
            catch (CannotProvideCoderException e) {
                throw new CannotProvideCoderException("Failed to infer coder for DestinationT from type " + descriptor + ", please provide it explicitly by overriding getDestinationCoder()", e);
            }
        }

        static class SideInputAccessorViaProcessContext
        implements SideInputAccessor {
            private /*
             * Issues handling annotations - annotations may be inaccurate
             */
             @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext;

            SideInputAccessorViaProcessContext(/*
             * Issues handling annotations - annotations may be inaccurate
             */
             @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext) {
                this.processContext = processContext;
            }

            @Override
            public <SideInputT> SideInputT sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<SideInputT> view) {
                return this.processContext.sideInput(view);
            }
        }

        static interface SideInputAccessor {
            public <SideInputT> SideInputT sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<SideInputT> var1);
        }
    }

    @Deprecated
    public static enum CompressionType implements WritableByteChannelFactory
    {
        UNCOMPRESSED(Compression.UNCOMPRESSED),
        GZIP(Compression.GZIP),
        BZIP2(Compression.BZIP2),
        ZSTD(Compression.ZSTD),
        LZO(Compression.LZO),
        LZOP(Compression.LZOP),
        DEFLATE(Compression.DEFLATE),
        SNAPPY(Compression.SNAPPY);

        private final @UnknownKeyFor @NonNull @Initialized Compression canonical;

        private CompressionType(Compression canonical) {
            this.canonical = canonical;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getSuggestedFilenameSuffix() {
            return this.canonical.getSuggestedSuffix();
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String getMimeType() {
            return this.canonical == Compression.UNCOMPRESSED ? null : "application/octet-stream";
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WritableByteChannel create(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.canonical.writeCompressed(channel);
        }

        public static @UnknownKeyFor @NonNull @Initialized CompressionType fromCanonical(@UnknownKeyFor @NonNull @Initialized Compression canonical) {
            switch (canonical) {
                case AUTO: {
                    throw new IllegalArgumentException("AUTO is not supported for writing");
                }
                case UNCOMPRESSED: {
                    return UNCOMPRESSED;
                }
                case GZIP: {
                    return GZIP;
                }
                case BZIP2: {
                    return BZIP2;
                }
                case ZIP: {
                    throw new IllegalArgumentException("ZIP is unsupported");
                }
                case ZSTD: {
                    return ZSTD;
                }
                case LZO: {
                    return LZO;
                }
                case LZOP: {
                    return LZOP;
                }
                case DEFLATE: {
                    return DEFLATE;
                }
                case SNAPPY: {
                    return SNAPPY;
                }
            }
            throw new UnsupportedOperationException("Unsupported compression type: " + (Object)((Object)canonical));
        }
    }
}

